/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.transaction.work;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleWorkListener
implements WorkListener {
    static final Logger logger = LoggerFactory.getLogger(SimpleWorkListener.class);
    private long acceptedTime = -1L;
    private long startedTime = -1L;
    private final WorkListener delegate;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    public SimpleWorkListener(WorkListener workListener) {
        this.delegate = workListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitForStart() {
        try {
            this.lock.lock();
            while (this.acceptedTime < 0L || this.startedTime < 0L) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException ex) {
                    logger.debug(ex.getMessage());
                }
            }
            long l = this.startedTime - this.acceptedTime;
            Object var4_3 = null;
            this.lock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalStarted() {
        try {
            this.lock.lock();
            this.condition.signalAll();
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public void workAccepted(WorkEvent event) {
        if (this.delegate != null) {
            this.delegate.workAccepted(event);
        }
        this.acceptedTime = System.currentTimeMillis();
    }

    public void workCompleted(WorkEvent event) {
        if (this.delegate != null) {
            this.delegate.workCompleted(event);
        }
    }

    public void workRejected(WorkEvent event) {
        if (this.delegate != null) {
            this.delegate.workRejected(event);
        }
    }

    public void workStarted(WorkEvent event) {
        if (this.delegate != null) {
            this.delegate.workStarted(event);
        }
        this.startedTime = System.currentTimeMillis();
        this.signalStarted();
    }
}

