/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.transaction.archive;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAResourceArchive
implements XAResource {
    static final Logger logger = LoggerFactory.getLogger(XAResourceArchive.class);
    public static final int DEFAULT_VOTE = -1;
    private boolean suspended;
    private boolean delisted;
    private boolean completed;
    private boolean readonly;
    private boolean committed;
    private boolean rolledback;
    private boolean heuristic;
    private boolean identified;
    private transient boolean recovered;
    private Xid xid;
    private int vote = -1;
    private XAResourceDescriptor descriptor;

    public void commit(Xid ignore, boolean onePhase) throws XAException {
        if (!this.readonly && !this.committed) {
            if (this.rolledback) {
                throw new XAException(6);
            }
            this.descriptor.commit(this.xid, onePhase);
        }
    }

    public void end(Xid ignore, int flags) throws XAException {
        this.descriptor.end(this.xid, flags);
    }

    public void forget(Xid ignore) throws XAException {
        this.descriptor.forget(this.xid);
    }

    public void forgetQuietly(Xid ignore) {
        try {
            this.descriptor.forget(this.xid);
        }
        catch (XAException ex) {
            logger.warn("Error occurred while forgeting xa-resource.", (Object)this.xid);
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.descriptor.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (XAResourceArchive.class.isInstance(xares)) {
            XAResourceArchive archive = (XAResourceArchive)xares;
            return this.descriptor.isSameRM(archive.getDescriptor());
        }
        return this.descriptor.isSameRM(xares);
    }

    public int prepare(Xid ignore) throws XAException {
        if (this.vote == -1) {
            this.vote = this.descriptor.prepare(this.xid);
            this.readonly = this.vote == 3;
        }
        return this.vote;
    }

    public Xid[] recover(int flag) throws XAException {
        return this.descriptor.recover(flag);
    }

    public void rollback(Xid ignore) throws XAException {
        if (!this.readonly) {
            if (this.committed) {
                throw new XAException(7);
            }
            if (!this.rolledback) {
                this.descriptor.rollback(this.xid);
            }
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.descriptor.setTransactionTimeout(seconds);
    }

    public void start(Xid ignore, int flags) throws XAException {
        this.descriptor.start(this.xid, flags);
    }

    public String toString() {
        return String.format("xa-res-archive[descriptor: %s]", this.descriptor);
    }

    public XAResourceDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(XAResourceDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public boolean isDelisted() {
        return this.delisted;
    }

    public void setDelisted(boolean delisted) {
        this.delisted = delisted;
    }

    public Xid getXid() {
        return this.xid;
    }

    public void setXid(Xid xid) {
        this.xid = xid;
    }

    public int getVote() {
        return this.vote;
    }

    public void setVote(int vote) {
        this.vote = vote;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public boolean isRolledback() {
        return this.rolledback;
    }

    public void setRolledback(boolean rolledback) {
        this.rolledback = rolledback;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isHeuristic() {
        return this.heuristic;
    }

    public void setHeuristic(boolean heuristic) {
        this.heuristic = heuristic;
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public void setRecovered(boolean recovered) {
        this.recovered = recovered;
    }

    public boolean isIdentified() {
        return this.identified;
    }

    public void setIdentified(boolean identified) {
        this.identified = identified;
    }
}

