/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.common.utils;

import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoCallback;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.bytesoft.common.utils.CommonUtils;
import org.nustaq.serialization.FSTConfiguration;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeUtils {
    static final Logger logger = LoggerFactory.getLogger(SerializeUtils.class);
    static final int SERIALIZER_DEFAULT = 0;
    static final int SERIALIZER_KRYO = 1;
    static final int SERIALIZER_HESSIAN = 2;
    static final int SERIALIZER_FST = 3;
    static final FSTConfiguration fstConfig = FSTConfiguration.createDefaultConfiguration();
    static final KryoPool kryoPool = new KryoPool.Builder(new KryoFactory(){

        public Kryo create() {
            Kryo kryo = new Kryo();
            StdInstantiatorStrategy stdInstantiatorStrategy = new StdInstantiatorStrategy();
            Kryo.DefaultInstantiatorStrategy instantiatorStrategy = new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)stdInstantiatorStrategy);
            kryo.setInstantiatorStrategy((InstantiatorStrategy)instantiatorStrategy);
            return kryo;
        }
    }).softReferences().build();

    public static byte[] serializeObject(Serializable obj) throws IOException {
        boolean serializer = false;
        byte[] dataArray = null;
        try {
            dataArray = SerializeUtils.kryoSerialize(obj);
            serializer = true;
        }
        catch (Exception ex) {
            dataArray = SerializeUtils.javaSerialize(obj);
            serializer = true;
        }
        byte[] byteArray = new byte[dataArray.length + 1];
        byteArray[0] = (byte)(serializer ? 1 : 0);
        System.arraycopy(dataArray, 0, byteArray, 1, dataArray.length);
        return byteArray;
    }

    public static Serializable deserializeObject(byte[] bytes) throws IOException {
        if (bytes.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] byteArray = new byte[bytes.length - 1];
        byte serializer = bytes[0];
        if (serializer == 1) {
            System.arraycopy(bytes, 1, byteArray, 0, byteArray.length);
            return SerializeUtils.kryoDeserialize(byteArray);
        }
        if (serializer == 2) {
            System.arraycopy(bytes, 1, byteArray, 0, byteArray.length);
            return SerializeUtils.hessianDeserialize(byteArray);
        }
        if (serializer == 3) {
            System.arraycopy(bytes, 1, byteArray, 0, byteArray.length);
            return SerializeUtils.fstDeserialize(byteArray);
        }
        if (serializer == 0) {
            System.arraycopy(bytes, 1, byteArray, 0, byteArray.length);
            return SerializeUtils.javaDeserialize(byteArray);
        }
        throw new IllegalArgumentException();
    }

    public static byte[] fstSerialize(Serializable obj) throws IOException {
        return fstConfig.asByteArray((Object)obj);
    }

    public static Serializable fstDeserialize(byte[] byteArray) throws IOException {
        return (Serializable)fstConfig.asObject(byteArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] javaSerialize(Serializable obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(baos));
        try {
            oos.writeObject(obj);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            CommonUtils.closeQuietly(oos);
            throw throwable;
        }
        CommonUtils.closeQuietly(oos);
        return baos.toByteArray();
    }

    public static Serializable javaDeserialize(byte[] byteArray) throws IOException {
        Serializable serializable;
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new ByteArrayInputStream(byteArray)));
        try {
            serializable = (Serializable)ois.readObject();
            Object var4_4 = null;
        }
        catch (ClassNotFoundException ex) {
            try {
                throw new IllegalStateException(ex);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                CommonUtils.closeQuietly(ois);
                throw throwable;
            }
        }
        CommonUtils.closeQuietly(ois);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] kryoSerialize(final Serializable obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        final Output output = new Output((OutputStream)baos);
        try {
            kryoPool.run((KryoCallback)new KryoCallback<Object>(){

                public Object execute(Kryo kryo) {
                    kryo.writeClassAndObject(output, (Object)obj);
                    return null;
                }
            });
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            CommonUtils.closeQuietly((Closeable)output);
            throw throwable;
        }
        CommonUtils.closeQuietly((Closeable)output);
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable kryoDeserialize(byte[] byteArray) throws IOException {
        Serializable serializable;
        final Input input = new Input((InputStream)new ByteArrayInputStream(byteArray));
        try {
            serializable = (Serializable)kryoPool.run((KryoCallback)new KryoCallback<Serializable>(){

                public Serializable execute(Kryo kryo) {
                    return (Serializable)kryo.readClassAndObject(input);
                }
            });
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            CommonUtils.closeQuietly((Closeable)input);
            throw throwable;
        }
        CommonUtils.closeQuietly((Closeable)input);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hessianSerialize(Serializable obj) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HessianOutput ho = new HessianOutput((OutputStream)baos);
        try {
            ho.writeObject((Object)obj);
            byArray = baos.toByteArray();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CommonUtils.closeQuietly(baos);
            throw throwable;
        }
        CommonUtils.closeQuietly(baos);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable hessianDeserialize(byte[] bytes) throws IOException {
        Serializable serializable;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        HessianInput hi = new HessianInput((InputStream)bais);
        try {
            Object result = hi.readObject();
            serializable = (Serializable)result;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            CommonUtils.closeQuietly(bais);
            throw throwable;
        }
        CommonUtils.closeQuietly(bais);
        return serializable;
    }
}

