/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.common.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.common.utils.SerializeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    static final Logger logger = LoggerFactory.getLogger(CommonUtils.class);

    public static boolean instanceEquals(String source, String target) {
        String[] targetArray;
        if (StringUtils.isBlank((CharSequence)source) && StringUtils.isNotBlank((CharSequence)target)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)target) && StringUtils.isNotBlank((CharSequence)source)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)target) && StringUtils.isBlank((CharSequence)source)) {
            return true;
        }
        String[] sourceArray = source.split("\\s*:\\s*");
        if (sourceArray.length != (targetArray = target.split("\\s*:\\s*")).length) {
            return false;
        }
        String sourceAddr = sourceArray[0];
        String targetAddr = targetArray[0];
        String sourcePort = sourceArray[sourceArray.length - 1];
        String targetPort = targetArray[targetArray.length - 1];
        return StringUtils.equalsIgnoreCase((CharSequence)sourceAddr, (CharSequence)targetAddr) && StringUtils.equalsIgnoreCase((CharSequence)sourcePort, (CharSequence)targetPort);
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        if (o2 != null) {
            return o2.equals(o1);
        }
        return true;
    }

    @Deprecated
    public static byte[] serializeObject(Serializable object) throws IOException {
        return SerializeUtils.serializeObject(object);
    }

    @Deprecated
    public static Serializable deserializeObject(byte[] byteArray) throws IOException {
        try {
            return SerializeUtils.deserializeObject(byteArray);
        }
        catch (Exception ex) {
            return SerializeUtils.hessianDeserialize(byteArray);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                logger.debug("Error occurred while closing resource {}.", (Object)closeable);
            }
        }
    }

    public static String getInetAddress() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface ni = enumeration.nextElement();
                if (ni.isLoopback() || !ni.isUp()) continue;
                Enumeration<InetAddress> inetAddrList = ni.getInetAddresses();
                while (inetAddrList.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrList.nextElement();
                    if (inetAddr.isLoopbackAddress() || inetAddr.isMulticastAddress() || inetAddr.isAnyLocalAddress() || !Inet4Address.class.isInstance(inetAddr)) continue;
                    return inetAddr.getHostAddress();
                }
            }
            InetAddress inetAddr = InetAddress.getLocalHost();
            return inetAddr.getHostAddress();
        }
        catch (Exception ex) {
            logger.error("Error occurred while getting ip address.", (Throwable)ex);
            return "127.0.0.1";
        }
    }

    public static String getInetAddress(String host) {
        try {
            InetAddress inetAddr = InetAddress.getByName(host);
            return inetAddr.getHostAddress();
        }
        catch (UnknownHostException ex) {
            logger.error("Error occurred while getting ip address: host= {}.", (Object)host, (Object)ex);
            return host;
        }
    }
}

