/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.common.utils;

public class ByteUtils {
    static final char DIGIT_START = '0';
    static final char DIGIT_END = '9';
    static final char LETTER_START = 'a';
    static final char LETTER_END = 'f';
    static final char UPPER_LETTER_START = 'A';
    static final char UPPER_LETTER_END = 'F';
    static final char[] CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static short byteArrayToShort(byte[] buf) {
        return ByteUtils.byteArrayToShort(buf, 0);
    }

    public static int byteArrayToInt(byte[] buf) {
        return ByteUtils.byteArrayToInt(buf, 0);
    }

    public static long byteArrayToLong(byte[] buf) {
        return ByteUtils.byteArrayToLong(buf, 0);
    }

    public static long byteArrayToLong(byte[] buf, int start) {
        if (start < 0 || start + 7 >= buf.length) {
            throw new IllegalArgumentException();
        }
        long value = ((long)buf[start] & 0xFFL) << 56;
        value |= ((long)buf[start + 1] & 0xFFL) << 48;
        value |= ((long)buf[start + 2] & 0xFFL) << 40;
        value |= ((long)buf[start + 3] & 0xFFL) << 32;
        value |= ((long)buf[start + 4] & 0xFFL) << 24;
        value |= ((long)buf[start + 5] & 0xFFL) << 16;
        value |= ((long)buf[start + 6] & 0xFFL) << 8;
        return value |= (long)buf[start + 7] & 0xFFL;
    }

    public static byte[] longToByteArray(long value) {
        byte[] result = new byte[8];
        result[7] = (byte)(value & 0xFFL);
        result[6] = (byte)(value >> 8 & 0xFFL);
        result[5] = (byte)(value >> 16 & 0xFFL);
        result[4] = (byte)(value >> 24 & 0xFFL);
        result[3] = (byte)(value >> 32 & 0xFFL);
        result[2] = (byte)(value >> 40 & 0xFFL);
        result[1] = (byte)(value >> 48 & 0xFFL);
        result[0] = (byte)(value >> 56 & 0xFFL);
        return result;
    }

    public static int byteArrayToInt(byte[] buf, int start) {
        if (start < 0 || start + 3 >= buf.length) {
            throw new IllegalArgumentException();
        }
        int value = (buf[start] & 0xFF) << 24;
        value |= (buf[start + 1] & 0xFF) << 16;
        value |= (buf[start + 2] & 0xFF) << 8;
        return value |= buf[start + 3] & 0xFF;
    }

    public static byte[] intToByteArray(int value) {
        byte[] result = new byte[4];
        result[3] = (byte)(value & 0xFF);
        result[2] = (byte)(value >> 8 & 0xFF);
        result[1] = (byte)(value >> 16 & 0xFF);
        result[0] = (byte)(value >> 24 & 0xFF);
        return result;
    }

    public static short byteArrayToShort(byte[] buf, int start) {
        if (start < 0 || start + 1 >= buf.length) {
            throw new IllegalArgumentException();
        }
        int value = (buf[start] & 0xFF) << 8;
        return (short)(value |= buf[start + 1] & 0xFF);
    }

    public static byte[] shortToByteArray(short value) {
        byte[] result = new byte[2];
        result[1] = (byte)(value & 0xFF);
        result[0] = (byte)(value >> 8 & 0xFF);
        return result;
    }

    public static String byteArrayToString(byte[] bytes, int startIndex, int len) {
        StringBuilder ber = new StringBuilder();
        int i = startIndex;
        for (int j = 0; j < len; ++j) {
            byte b = bytes[i];
            ber.append(CHARS[(b & 0xF0) >> 4]);
            ber.append(CHARS[b & 0xF]);
            ++i;
        }
        return ber.toString();
    }

    public static String byteArrayToString(byte[] bytes) {
        return ByteUtils.byteArrayToString(bytes, 0, bytes.length);
    }

    public static byte[] stringToByteArray(String str) {
        if (str == null) {
            return new byte[0];
        }
        if (str.length() % 2 == 1) {
            throw new IllegalArgumentException();
        }
        char[] array = str.toCharArray();
        byte[] bytes = new byte[array.length / 2];
        for (int i = 0; i < array.length; i += 2) {
            int index1 = ByteUtils.indexOf(array[i]);
            int index2 = ByteUtils.indexOf(array[i + 1]);
            int tempval = index1 << 4;
            int byteval = tempval | index2;
            bytes[i / 2] = (byte)byteval;
        }
        return bytes;
    }

    private static int indexOf(char chr) {
        if (chr >= '0' && chr <= '9') {
            return chr - 48;
        }
        if (chr >= 'a' && chr <= 'f') {
            return chr - 97 + 10;
        }
        if (chr >= 'A' && chr <= 'F') {
            return chr - 65 + 10;
        }
        throw new IllegalArgumentException();
    }
}

