/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.supports.jdbc.LocalXAResource;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.transaction.xa.TransactionXid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveredResource
extends LocalXAResource
implements XAResource {
    static final Logger logger = LoggerFactory.getLogger(RecoveredResource.class);
    private DataSource dataSource;

    public void recoverable(Xid xid) throws XAException {
        byte[] globalTransactionId = xid.getGlobalTransactionId();
        byte[] branchQualifier = xid.getBranchQualifier();
        String identifier = this.getIdentifier(globalTransactionId, branchQualifier);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                conn = this.dataSource.getConnection();
                stmt = conn.prepareStatement("select gxid, bxid from bytejta where xid = ?");
                stmt.setString(1, identifier);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new XAException(-4);
                }
                Object var11_8 = null;
            }
            catch (SQLException ex) {
                try {
                    this.isTableExists(conn);
                }
                catch (SQLException sqlEx) {
                    logger.warn("Error occurred while recovering local-xa-resource.", (Throwable)ex);
                    throw new XAException(-7);
                }
                catch (RuntimeException rex) {
                    logger.warn("Error occurred while recovering local-xa-resource.", (Throwable)ex);
                    throw new XAException(-7);
                }
                throw new XAException(-3);
            }
            catch (RuntimeException ex) {
                logger.warn("Error occurred while recovering local-xa-resource.", (Throwable)ex);
                throw new XAException(-3);
            }
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.closeQuietly(rs);
            this.closeQuietly(stmt);
            this.closeQuietly(conn);
            throw throwable;
        }
        this.closeQuietly(rs);
        this.closeQuietly(stmt);
        this.closeQuietly(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Xid[] recover(int flags) throws XAException {
        ArrayList<TransactionXid> xidList;
        block9: {
            xidList = new ArrayList<TransactionXid>();
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    conn = this.dataSource.getConnection();
                    stmt = conn.prepareStatement("select gxid, bxid from bytejta");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String gxid = rs.getString(1);
                        String bxid = rs.getString(2);
                        byte[] globalTransactionId = ByteUtils.stringToByteArray(gxid);
                        byte[] branchQualifier = ByteUtils.stringToByteArray(bxid);
                        TransactionXid xid = null;
                        xid = StringUtils.equals((CharSequence)gxid, (CharSequence)bxid) ? new TransactionXid(1207, globalTransactionId) : new TransactionXid(1207, globalTransactionId, branchQualifier);
                        xidList.add(xid);
                    }
                    Object var12_14 = null;
                }
                catch (Exception ex) {
                    boolean tableExists = false;
                    try {
                        tableExists = this.isTableExists(conn);
                    }
                    catch (Exception sqlEx) {
                        logger.warn("Error occurred while recovering local-xa-resource.", (Throwable)ex);
                        throw new XAException(-7);
                    }
                    if (tableExists) {
                        throw new XAException(-3);
                    }
                    Object var12_15 = null;
                    this.closeQuietly(rs);
                    this.closeQuietly(stmt);
                    this.closeQuietly(conn);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                this.closeQuietly(rs);
                this.closeQuietly(stmt);
                this.closeQuietly(conn);
                throw throwable;
            }
            this.closeQuietly(rs);
            this.closeQuietly(stmt);
            this.closeQuietly(conn);
        }
        Xid[] xidArray = new Xid[xidList.size()];
        xidList.toArray(xidArray);
        return xidArray;
    }

    public void forgetQuietly(Xid xid) {
        try {
            this.forget(xid);
        }
        catch (XAException ex) {
            logger.warn("Error occurred while forgeting local-xa-resource.", (Object)xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void forget(Xid[] xids) throws XAException {
        block19: {
            Boolean autoCommit;
            PreparedStatement stmt;
            Connection conn;
            block18: {
                if (xids == null || xids.length == 0) {
                    return;
                }
                String[] xidArray = new String[xids.length];
                for (int i = 0; i < xids.length; ++i) {
                    Xid xid = xids[i];
                    byte[] globalTransactionId = xid.getGlobalTransactionId();
                    byte[] branchQualifier = xid.getBranchQualifier();
                    xidArray[i] = this.getIdentifier(globalTransactionId, branchQualifier);
                }
                conn = null;
                stmt = null;
                autoCommit = null;
                conn = this.dataSource.getConnection();
                autoCommit = conn.getAutoCommit();
                conn.setAutoCommit(false);
                stmt = conn.prepareStatement("delete from bytejta where xid = ?");
                for (int i = 0; i < xids.length; ++i) {
                    stmt.setString(1, xidArray[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
                conn.commit();
                Object var10_10 = null;
                if (autoCommit == null) break block18;
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (SQLException sqlEx) {
                    logger.error("Error occurred while configuring attribute 'autoCommit'.", (Throwable)sqlEx);
                }
            }
            this.closeQuietly(stmt);
            this.closeQuietly(conn);
            {
                break block19;
                catch (Exception ex) {
                    logger.error("Error occurred while forgetting resources.", (Throwable)ex);
                    try {
                        conn.rollback();
                    }
                    catch (Exception sqlEx) {
                        logger.error("Error occurred while rolling back local resources.", (Throwable)sqlEx);
                    }
                    boolean tableExists = false;
                    try {
                        tableExists = this.isTableExists(conn);
                    }
                    catch (Exception sqlEx) {
                        logger.warn("Error occurred while forgeting local resources.", (Throwable)ex);
                        throw new XAException(-7);
                    }
                    if (tableExists) {
                        throw new XAException(-3);
                    }
                    Object var10_11 = null;
                    if (autoCommit != null) {
                        try {
                            conn.setAutoCommit(autoCommit);
                        }
                        catch (SQLException sqlEx) {
                            logger.error("Error occurred while configuring attribute 'autoCommit'.", (Throwable)sqlEx);
                        }
                    }
                    this.closeQuietly(stmt);
                    this.closeQuietly(conn);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (autoCommit != null) {
                    try {
                        conn.setAutoCommit(autoCommit);
                    }
                    catch (SQLException sqlEx) {
                        logger.error("Error occurred while configuring attribute 'autoCommit'.", (Throwable)sqlEx);
                    }
                }
                this.closeQuietly(stmt);
                this.closeQuietly(conn);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void forget(Xid xid) throws XAException {
        if (xid == null) {
            logger.warn("Error occurred while forgeting local-xa-resource: invalid xid.");
            return;
        }
        byte[] globalTransactionId = xid.getGlobalTransactionId();
        byte[] branchQualifier = xid.getBranchQualifier();
        String identifier = this.getIdentifier(globalTransactionId, branchQualifier);
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = this.dataSource.getConnection();
                stmt = conn.prepareStatement("delete from bytejta where xid = ?");
                stmt.setString(1, identifier);
                stmt.executeUpdate();
            }
            catch (Exception ex) {
                boolean tableExists = false;
                try {
                    tableExists = this.isTableExists(conn);
                }
                catch (Exception sqlEx) {
                    logger.warn("Error occurred while forgeting local-xa-resource.", (Throwable)ex);
                    throw new XAException(-7);
                }
                if (tableExists) {
                    throw new XAException(-3);
                }
                Object var11_8 = null;
                this.closeQuietly(stmt);
                this.closeQuietly(conn);
                return;
            }
            Object var11_7 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.closeQuietly(stmt);
            this.closeQuietly(conn);
            throw throwable;
        }
        this.closeQuietly(stmt);
        this.closeQuietly(conn);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

