/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.strategy;

import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.bytesoft.bytejta.TransactionStrategy;
import org.bytesoft.transaction.CommitRequiredException;
import org.bytesoft.transaction.RollbackRequiredException;
import org.bytesoft.transaction.resource.XATerminator;

public class CommonTransactionStrategy
implements TransactionStrategy {
    private final XATerminator nativeTerminator;
    private final XATerminator remoteTerminator;

    public CommonTransactionStrategy(XATerminator nativeTerminator, XATerminator remoteTerminator) {
        if (nativeTerminator == null || nativeTerminator.getResourceArchives().isEmpty()) {
            throw new IllegalStateException();
        }
        if (remoteTerminator == null || remoteTerminator.getResourceArchives().isEmpty()) {
            throw new IllegalStateException();
        }
        this.nativeTerminator = nativeTerminator;
        this.remoteTerminator = remoteTerminator;
    }

    public int prepare(Xid xid) throws RollbackRequiredException, CommitRequiredException {
        int nativeVote = 3;
        try {
            nativeVote = this.nativeTerminator.prepare(xid);
        }
        catch (Exception ex) {
            throw new RollbackRequiredException();
        }
        int remoteVote = 3;
        try {
            remoteVote = this.remoteTerminator.prepare(xid);
        }
        catch (Exception ex) {
            throw new RollbackRequiredException();
        }
        if (0 == nativeVote || 0 == remoteVote) {
            return 0;
        }
        return 3;
    }

    public void commit(Xid xid) throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, SystemException {
        boolean committedExists = false;
        boolean rolledbackExists = false;
        boolean unFinishExists = false;
        boolean errorExists = false;
        try {
            this.nativeTerminator.commit(xid, false);
            committedExists = true;
        }
        catch (XAException ex) {
            switch (ex.errorCode) {
                case 7: {
                    committedExists = true;
                    break;
                }
                case 6: {
                    rolledbackExists = true;
                    break;
                }
                case 5: {
                    committedExists = true;
                    rolledbackExists = true;
                    break;
                }
                case 8: {
                    unFinishExists = true;
                    break;
                }
                case 3: {
                    break;
                }
                case -3: {
                    errorExists = true;
                    break;
                }
                default: {
                    errorExists = true;
                    break;
                }
            }
        }
        catch (RuntimeException ex) {
            unFinishExists = true;
        }
        try {
            this.remoteTerminator.commit(xid, false);
            committedExists = true;
        }
        catch (XAException ex) {
            switch (ex.errorCode) {
                case 7: {
                    committedExists = true;
                    break;
                }
                case 6: {
                    rolledbackExists = true;
                    break;
                }
                case 5: {
                    committedExists = true;
                    rolledbackExists = true;
                    break;
                }
                case 8: {
                    unFinishExists = true;
                    break;
                }
                case 3: {
                    break;
                }
                case -3: {
                    errorExists = true;
                    break;
                }
                default: {
                    errorExists = true;
                    break;
                }
            }
        }
        catch (RuntimeException ex) {
            unFinishExists = true;
        }
        if (committedExists && rolledbackExists) {
            throw new HeuristicMixedException();
        }
        if (unFinishExists) {
            throw new SystemException();
        }
        if (errorExists) {
            throw new SystemException();
        }
        if (rolledbackExists) {
            throw new HeuristicRollbackException();
        }
    }

    public void rollback(Xid xid) throws HeuristicMixedException, HeuristicCommitException, IllegalStateException, SystemException {
        boolean committedExists = false;
        boolean rolledbackExists = false;
        boolean unFinishExists = false;
        boolean errorExists = false;
        try {
            this.nativeTerminator.rollback(xid);
            rolledbackExists = true;
        }
        catch (XAException ex) {
            switch (ex.errorCode) {
                case 7: {
                    committedExists = true;
                    break;
                }
                case 6: {
                    rolledbackExists = true;
                    break;
                }
                case 5: {
                    committedExists = true;
                    rolledbackExists = true;
                    break;
                }
                case 8: {
                    unFinishExists = true;
                    break;
                }
                case 3: {
                    break;
                }
                case -3: {
                    errorExists = true;
                    break;
                }
                default: {
                    errorExists = true;
                    break;
                }
            }
        }
        catch (RuntimeException ex) {
            unFinishExists = true;
        }
        try {
            this.remoteTerminator.rollback(xid);
            rolledbackExists = true;
        }
        catch (XAException ex) {
            switch (ex.errorCode) {
                case 7: {
                    committedExists = true;
                    break;
                }
                case 6: {
                    rolledbackExists = true;
                    break;
                }
                case 5: {
                    committedExists = true;
                    rolledbackExists = true;
                    break;
                }
                case 8: {
                    unFinishExists = true;
                    break;
                }
                case 3: {
                    break;
                }
                case -3: {
                    errorExists = true;
                    break;
                }
                default: {
                    errorExists = true;
                    break;
                }
            }
        }
        catch (RuntimeException ex) {
            unFinishExists = true;
        }
        if (committedExists && rolledbackExists) {
            throw new HeuristicMixedException();
        }
        if (unFinishExists) {
            throw new SystemException();
        }
        if (errorExists) {
            throw new SystemException();
        }
        if (committedExists) {
            throw new HeuristicCommitException();
        }
    }
}

