/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.resource;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.archive.XAResourceArchive;
import org.bytesoft.transaction.logging.TransactionLogger;
import org.bytesoft.transaction.resource.XATerminator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XATerminatorOptd
implements XATerminator {
    static final Logger logger = LoggerFactory.getLogger(XATerminatorOptd.class);
    private TransactionBeanFactory beanFactory;
    private XAResourceArchive archive;

    @Override
    public synchronized int prepare(Xid xid) throws XAException {
        if (this.archive == null) {
            return 3;
        }
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        boolean prepared = this.archive.getVote() != -1;
        int globalVote = 3;
        if (prepared) {
            globalVote = this.archive.getVote();
        } else {
            globalVote = this.archive.prepare(this.archive.getXid());
            this.archive.setVote(globalVote);
            if (globalVote == 3) {
                this.archive.setReadonly(true);
                this.archive.setCompleted(true);
            } else {
                globalVote = 0;
            }
            transactionLogger.updateResource(this.archive);
        }
        logger.info("[{}] prepare: xares= {}, branch= {}, vote= {}", new Object[]{ByteUtils.byteArrayToString(this.archive.getXid().getGlobalTransactionId()), this.archive, ByteUtils.byteArrayToString(this.archive.getXid().getBranchQualifier()), globalVote});
        return globalVote;
    }

    @Override
    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        if (onePhase) {
            this.fireOnePhaseCommit(xid);
        } else {
            this.fireTwoPhaseCommit(xid);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fireOnePhaseCommit(Xid xid) throws XAException {
        if (this.archive.isCommitted() && this.archive.isRolledback()) {
            throw new XAException(5);
        }
        if (this.archive.isCommitted()) {
            return;
        }
        if (this.archive.isReadonly()) {
            throw new XAException(3);
        }
        if (this.archive.isRolledback()) {
            throw new XAException(6);
        }
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        boolean updateRequired = true;
        try {
            this.archive.commit(this.archive.getXid(), true);
            this.archive.setCommitted(true);
            this.archive.setCompleted(true);
            logger.info("[{}] commit: xares= {}, branch= {}, opc= {}", new Object[]{ByteUtils.byteArrayToString(this.archive.getXid().getGlobalTransactionId()), this.archive, ByteUtils.byteArrayToString(this.archive.getXid().getBranchQualifier()), false});
            return;
        }
        catch (XAException xaex) {
            switch (xaex.errorCode) {
                case 7: {
                    this.archive.setHeuristic(true);
                    this.archive.setCommitted(true);
                    this.archive.setCompleted(true);
                    return;
                }
                case 5: {
                    this.archive.setHeuristic(true);
                    this.archive.setCommitted(true);
                    this.archive.setRolledback(true);
                    this.archive.setCompleted(true);
                    throw xaex;
                }
                case 6: {
                    this.archive.setHeuristic(true);
                    this.archive.setRolledback(true);
                    this.archive.setCompleted(true);
                    throw xaex;
                }
                case 8: {
                    this.archive.setHeuristic(true);
                    throw xaex;
                }
                case -7: {
                    logger.warn("An error occurred in one phase commit: {}", (Object)ByteUtils.byteArrayToString(this.archive.getXid().getGlobalTransactionId()));
                    updateRequired = false;
                    throw new XAException(8);
                }
                case -6: 
                case -5: 
                case -4: {
                    logger.warn("An error occurred in one phase commit: {}", (Object)ByteUtils.byteArrayToString(this.archive.getXid().getGlobalTransactionId()));
                    updateRequired = false;
                    throw new XAException(-3);
                }
                default: {
                    logger.warn("An error occurred in one phase commit: {}, transaction has been rolled back!", (Object)ByteUtils.byteArrayToString(this.archive.getXid().getGlobalTransactionId()));
                    this.archive.setRolledback(true);
                    this.archive.setCompleted(true);
                    throw new XAException(6);
                }
            }
        }
        catch (RuntimeException rex) {
            logger.error("[{}] Error occurred while committing xa-resource: xares= {}, branch= {}", new Object[]{ByteUtils.byteArrayToString(this.archive.getXid().getGlobalTransactionId()), this.archive, ByteUtils.byteArrayToString(this.archive.getXid().getBranchQualifier()), rex});
            updateRequired = false;
            throw new XAException(8);
        }
        finally {
            if (updateRequired) {
                transactionLogger.updateResource(this.archive);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fireTwoPhaseCommit(Xid xid) throws XAException {
        if (this.archive.isCommitted() && this.archive.isRolledback()) {
            throw new XAException(5);
        }
        if (this.archive.isCommitted()) {
            return;
        }
        if (this.archive.isReadonly()) {
            throw new XAException(3);
        }
        if (this.archive.isRolledback()) {
            throw new XAException(6);
        }
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        boolean updateRequired = true;
        try {
            this.archive.commit(this.archive.getXid(), false);
            this.archive.setCommitted(true);
            this.archive.setCompleted(true);
            logger.info("[{}] commit: xares= {}, branch= {}, opc= {}", new Object[]{ByteUtils.byteArrayToString(this.archive.getXid().getGlobalTransactionId()), this.archive, ByteUtils.byteArrayToString(this.archive.getXid().getBranchQualifier()), false});
            return;
        }
        catch (XAException xaex) {
            switch (xaex.errorCode) {
                case 8: {
                    this.archive.setHeuristic(true);
                    throw xaex;
                }
                case 5: {
                    this.archive.setHeuristic(true);
                    this.archive.setCommitted(true);
                    this.archive.setRolledback(true);
                    this.archive.setCompleted(true);
                    throw xaex;
                }
                case 7: {
                    this.archive.setHeuristic(true);
                    this.archive.setCommitted(true);
                    this.archive.setCompleted(true);
                    return;
                }
                case 6: {
                    this.archive.setHeuristic(true);
                    this.archive.setRolledback(true);
                    this.archive.setCompleted(true);
                    throw xaex;
                }
                case -4: {
                    this.archive.setReadonly(true);
                    throw new XAException(3);
                }
                case -7: {
                    updateRequired = false;
                    XAException xahaz = new XAException(8);
                    xahaz.initCause(xaex);
                    throw xahaz;
                }
                case -6: 
                case -5: {
                    updateRequired = false;
                    XAException error = new XAException(-3);
                    error.initCause(xaex);
                    throw error;
                }
                default: {
                    this.archive.setRolledback(true);
                    this.archive.setCompleted(true);
                    XAException xarb = new XAException(6);
                    xarb.initCause(xaex);
                    throw xarb;
                }
            }
        }
        catch (RuntimeException rex) {
            logger.error("[{}] Error occurred while committing xa-resource: xares= {}, branch= {}", new Object[]{ByteUtils.byteArrayToString(this.archive.getXid().getGlobalTransactionId()), this.archive, ByteUtils.byteArrayToString(this.archive.getXid().getBranchQualifier()), rex});
            updateRequired = false;
            throw new XAException(8);
        }
        finally {
            if (updateRequired) {
                transactionLogger.updateResource(this.archive);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void rollback(Xid xid) throws XAException {
        if (this.archive.isCommitted() && this.archive.isRolledback()) {
            throw new XAException(5);
        }
        if (this.archive.isRolledback()) {
            return;
        }
        if (this.archive.isReadonly()) {
            throw new XAException(3);
        }
        if (this.archive.isCommitted()) {
            throw new XAException(7);
        }
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        boolean updateRequired = true;
        try {
            this.archive.rollback(this.archive.getXid());
            this.archive.setRolledback(true);
            this.archive.setCompleted(true);
            logger.info("[{}] rollback: xares= {}, branch= {}", new Object[]{ByteUtils.byteArrayToString(this.archive.getXid().getGlobalTransactionId()), this.archive, ByteUtils.byteArrayToString(this.archive.getXid().getBranchQualifier())});
            return;
        }
        catch (XAException xaex) {
            logger.error("[{}] Error occurred while rolling back xa-resource: xares= {}, branch= {}, code= {}", new Object[]{ByteUtils.byteArrayToString(this.archive.getXid().getGlobalTransactionId()), this.archive, ByteUtils.byteArrayToString(this.archive.getXid().getBranchQualifier()), xaex.errorCode, xaex});
            switch (xaex.errorCode) {
                case 8: {
                    this.archive.setHeuristic(true);
                    throw xaex;
                }
                case 5: {
                    this.archive.setHeuristic(true);
                    this.archive.setCommitted(true);
                    this.archive.setRolledback(true);
                    this.archive.setCompleted(true);
                    throw xaex;
                }
                case 7: {
                    this.archive.setHeuristic(true);
                    this.archive.setCommitted(true);
                    this.archive.setCompleted(true);
                    throw xaex;
                }
                case 6: {
                    this.archive.setHeuristic(true);
                    this.archive.setRolledback(true);
                    this.archive.setCompleted(true);
                    return;
                }
                case -7: {
                    updateRequired = false;
                    throw new XAException(8);
                }
                case -4: {
                    if (this.archive.isReadonly()) {
                        this.archive.setReadonly(true);
                        this.archive.setCompleted(true);
                        throw new XAException(3);
                    }
                    if (this.archive.getVote() == -1) {
                        this.archive.setRolledback(true);
                        this.archive.setCompleted(true);
                        return;
                    }
                    if (this.archive.getVote() == 3) {
                        this.archive.setReadonly(true);
                        this.archive.setCompleted(true);
                        throw new XAException(3);
                    }
                    if (this.archive.getVote() == 0) {
                        updateRequired = false;
                        throw new XAException(-3);
                    }
                    updateRequired = false;
                    throw new XAException(-3);
                }
                case -6: 
                case -5: {
                    updateRequired = false;
                    throw new XAException(-3);
                }
                default: {
                    this.archive.setRolledback(true);
                    this.archive.setCompleted(true);
                    return;
                }
            }
        }
        catch (RuntimeException rex) {
            logger.error("[{}] Error occurred while rolling back xa-resource: xares= {}, branch= {}", new Object[]{ByteUtils.byteArrayToString(this.archive.getXid().getGlobalTransactionId()), this.archive, ByteUtils.byteArrayToString(this.archive.getXid().getBranchQualifier()), rex});
            updateRequired = false;
            throw new XAException(8);
        }
        finally {
            if (updateRequired) {
                transactionLogger.updateResource(this.archive);
            }
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        throw new XAException(-7);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        throw new XAException(-7);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        throw new XAException(-7);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        throw new XAException(-7);
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        throw new XAException(-7);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        throw new XAException(-7);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (this.archive == null) {
            return;
        }
        Xid currentXid = this.archive.getXid();
        if (this.archive.isHeuristic()) {
            try {
                Xid branchXid = this.archive.getXid();
                this.archive.forget(branchXid);
            }
            catch (XAException xae) {
                switch (xae.errorCode) {
                    case -3: {
                        logger.error("[{}] forget: xares= {}, branch={}, error= {}", new Object[]{ByteUtils.byteArrayToString(currentXid.getGlobalTransactionId()), this.archive, ByteUtils.byteArrayToString(currentXid.getBranchQualifier()), xae.errorCode});
                        break;
                    }
                    case -7: {
                        logger.error("[{}] forget: xares= {}, branch={}, error= {}", new Object[]{ByteUtils.byteArrayToString(currentXid.getGlobalTransactionId()), this.archive, ByteUtils.byteArrayToString(currentXid.getBranchQualifier()), xae.errorCode});
                        break;
                    }
                    case -6: 
                    case -5: 
                    case -4: {
                        break;
                    }
                    default: {
                        logger.error("[{}] forget: xares= {}, branch={}, error= {}", new Object[]{ByteUtils.byteArrayToString(currentXid.getGlobalTransactionId()), this.archive, ByteUtils.byteArrayToString(currentXid.getBranchQualifier()), xae.errorCode});
                    }
                }
            }
        }
    }

    @Override
    public List<XAResourceArchive> getResourceArchives() {
        return new List<XAResourceArchive>(){

            @Override
            public int size() {
                return XATerminatorOptd.this.archive == null ? 0 : 1;
            }

            @Override
            public boolean isEmpty() {
                return XATerminatorOptd.this.archive == null;
            }

            @Override
            public boolean contains(Object o) {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public Iterator<XAResourceArchive> iterator() {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public Object[] toArray() {
                Object[] objectArray;
                if (XATerminatorOptd.this.archive == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = XATerminatorOptd.this.archive;
                }
                return objectArray;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public boolean add(XAResourceArchive e) {
                if (XATerminatorOptd.this.archive != null && e != null) {
                    throw new IllegalStateException("Not supported yet!");
                }
                if (e != null) {
                    XATerminatorOptd.this.archive = e;
                    return true;
                }
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public boolean remove(Object o) {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public boolean addAll(Collection<? extends XAResourceArchive> c) {
                if (c == null || c.size() > 1) {
                    throw new IllegalStateException("Not supported yet!");
                }
                if (XATerminatorOptd.this.archive != null && !c.isEmpty()) {
                    throw new IllegalStateException("Not supported yet!");
                }
                if (!c.isEmpty()) {
                    Object[] array = c.toArray();
                    XATerminatorOptd.this.archive = (XAResourceArchive)array[0];
                }
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends XAResourceArchive> c) {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public void clear() {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public XAResourceArchive get(int index) {
                if (index > 0 || index < 0) {
                    throw new IndexOutOfBoundsException(String.format("index: %s, size: %s", index, this.size()));
                }
                if (XATerminatorOptd.this.archive == null) {
                    throw new IndexOutOfBoundsException(String.format("index: %s, size: 0", index));
                }
                return XATerminatorOptd.this.archive;
            }

            @Override
            public XAResourceArchive set(int index, XAResourceArchive element) {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public void add(int index, XAResourceArchive element) {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public XAResourceArchive remove(int index) {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public int indexOf(Object o) {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public int lastIndexOf(Object o) {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public ListIterator<XAResourceArchive> listIterator() {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public ListIterator<XAResourceArchive> listIterator(int index) {
                throw new IllegalStateException("Not supported yet!");
            }

            @Override
            public List<XAResourceArchive> subList(int fromIndex, int toIndex) {
                throw new IllegalStateException("Not supported yet!");
            }
        };
    }

    public TransactionBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(TransactionBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

