/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.logging.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.bytesoft.transaction.logging.store.VirtualLoggingTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualLoggingFile {
    static final Logger logger = LoggerFactory.getLogger(VirtualLoggingFile.class);
    static final long DEFAULT_SIZE = 0x100000L;
    static final long INCREASE_SIZE = 524288L;
    static final int DEFAULT_MAJOR_VERSION = 0;
    static final int DEFAULT_MINOR_VERSION = 2;
    private MappedByteBuffer readable;
    private MappedByteBuffer writable;
    private RandomAccessFile raf;
    private byte[] identifier;
    private boolean initialized;
    private int startIdx;
    private int endIndex;
    private boolean marked;
    private boolean master;
    private int majorVersion = 0;
    private int minorVersion = 2;
    private VirtualLoggingTrigger trigger;

    public VirtualLoggingFile(File file) throws IOException {
        this(file, 0, 2);
    }

    public VirtualLoggingFile(File file, int major, int minor) throws IOException {
        this.majorVersion = major;
        this.minorVersion = minor;
        this.initialized = file.exists();
        this.raf = new RandomAccessFile(file, "rw");
        if (!this.initialized) {
            this.configMappedByteBuffer(0x100000L);
        } else {
            this.configMappedByteBuffer(this.raf.length());
        }
    }

    public void clearMarkedFlag() {
        int pos = this.writable.position();
        this.writable.position(this.identifier.length + 2 + 8 + 4);
        this.writable.put((byte)0);
        this.marked = false;
        this.writable.position(pos);
    }

    public void fixSwitchError() {
        int pos = this.writable.position();
        this.writable.position(this.identifier.length + 2 + 8 + 4 + 1);
        this.writable.put((byte)1);
        this.writable.position(this.identifier.length + 2 + 8 + 4);
        this.writable.put((byte)0);
        this.marked = false;
        this.master = true;
        this.writable.position(pos);
    }

    public void initialize(boolean master) {
        this.checkLoggingIdentifier();
        this.checkLoggingVersion();
        this.checkCreatedTime();
        this.checkStartIndex();
        this.checkMasterFlag(master);
        this.checkModifiedTime();
        this.checkEndIndex();
        this.initialized = true;
    }

    private void checkLoggingIdentifier() {
        byte[] array = new byte[this.identifier.length];
        this.writable.position(0);
        this.writable.get(array);
        if (!Arrays.equals(this.identifier, array)) {
            if (!this.initialized) {
                this.writable.position(0);
                this.writable.put(this.identifier);
            } else {
                throw new IllegalStateException("Illegal file format!");
            }
        }
    }

    private void checkLoggingVersion() {
        this.writable.position(this.identifier.length);
        byte major = this.writable.get();
        byte minor = this.writable.get();
        if (major != this.majorVersion || minor != this.minorVersion) {
            if (!this.initialized) {
                this.writable.position(this.identifier.length);
                this.writable.put((byte)this.majorVersion);
                this.writable.put((byte)this.minorVersion);
            } else {
                throw new IllegalStateException("Incompatible version!");
            }
        }
    }

    private void checkCreatedTime() {
        if (!this.initialized) {
            this.writable.position(this.identifier.length + 2);
            this.writable.putLong(System.currentTimeMillis());
        }
    }

    private void checkStartIndex() {
        this.writable.position(this.identifier.length + 2 + 8);
        int start = this.writable.getInt();
        if (start == this.identifier.length + 2 + 8 + 4 + 2 + 8 + 4) {
            this.startIdx = start;
        } else if (!this.initialized) {
            this.startIdx = this.identifier.length + 2 + 8 + 4 + 2 + 8 + 4;
            this.writable.position(this.identifier.length + 2 + 8);
            this.writable.putInt(this.identifier.length + 2 + 8 + 4 + 2 + 8 + 4);
        } else {
            throw new IllegalStateException();
        }
    }

    private void checkMasterFlag(boolean master) {
        if (!this.initialized) {
            this.master = master;
            this.marked = false;
            this.writable.position(this.identifier.length + 2 + 8 + 4);
            this.writable.put((byte)0);
            this.writable.put(master ? (byte)1 : 0);
        } else {
            this.writable.position(this.identifier.length + 2 + 8 + 4);
            this.marked = this.writable.get() == 1;
            this.master = this.writable.get() == 1;
        }
    }

    private void checkModifiedTime() {
        if (!this.initialized) {
            this.writable.position(this.identifier.length + 2 + 8 + 4 + 2);
            this.writable.putLong(System.currentTimeMillis());
        }
    }

    private void checkEndIndex() {
        if (!this.initialized) {
            this.endIndex = this.identifier.length + 2 + 8 + 4 + 2 + 8 + 4;
            this.writable.position(this.identifier.length + 2 + 8 + 4 + 2 + 8);
            this.writable.putInt(this.identifier.length + 2 + 8 + 4 + 2 + 8 + 4);
        } else {
            this.writable.position(this.identifier.length + 2 + 8 + 4 + 2 + 8);
            this.endIndex = this.writable.getInt();
        }
    }

    public void markAsMaster() {
        this.writable.position(this.identifier.length + 2 + 8 + 4);
        this.writable.put((byte)1);
    }

    public void switchToMaster() {
        this.writable.position(this.identifier.length + 2 + 8 + 4 + 1);
        this.writable.put((byte)1);
        this.writable.position(this.identifier.length + 2 + 8 + 4);
        this.writable.put((byte)0);
        this.master = true;
        this.marked = false;
        this.readable.position(this.startIdx);
    }

    public void switchToSlaver() {
        this.writable.position(this.identifier.length + 2 + 8 + 4);
        this.writable.put((byte)0);
        this.writable.put((byte)0);
        this.master = false;
        this.marked = false;
        this.writable.position(this.identifier.length + 2 + 8 + 4 + 2);
        this.writable.putLong(System.currentTimeMillis());
        this.endIndex = this.startIdx;
        this.writable.putInt(this.endIndex);
    }

    public void prepareForReading() {
        this.readable.position(this.startIdx);
    }

    public byte[] read() {
        if (this.readable.position() < this.endIndex) {
            int pos = this.readable.position();
            this.readable.position(pos + 20 + 1);
            int size = this.readable.getInt();
            byte[] byteArray = new byte[25 + size];
            this.readable.position(pos);
            this.readable.get(byteArray);
            return byteArray;
        }
        return new byte[0];
    }

    public void write(byte[] byteArray) {
        if (this.writable.capacity() < this.endIndex + byteArray.length) {
            this.resizeMappedByteBuffer((long)this.endIndex + 524288L);
        }
        this.writable.position(this.endIndex);
        this.writable.put(byteArray);
        this.writable.position(this.identifier.length + 2 + 8 + 4 + 2);
        this.writable.putLong(System.currentTimeMillis());
        this.endIndex += byteArray.length;
        this.writable.putInt(this.endIndex);
        int threshold = this.writable.capacity() * 2 / 3;
        if (this.endIndex > threshold) {
            this.trigger.fireSwapImmediately();
        }
    }

    private void resizeMappedByteBuffer(long size) {
        try {
            this.raf.setLength((long)this.endIndex + 524288L);
            this.readable = this.raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, size);
            this.writable = this.raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, size);
        }
        catch (IOException ex) {
            logger.error("Error occurred while resizing the logging file!", (Throwable)ex);
        }
    }

    private void configMappedByteBuffer(long size) throws IOException {
        this.readable = this.raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, size);
        this.writable = this.raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, size);
    }

    public void flushImmediately() {
        if (this.writable != null) {
            this.writable.force();
        }
    }

    public void closeQuietly() {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (Exception ex) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public byte[] getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(byte[] identifier) {
        this.identifier = identifier;
    }

    public VirtualLoggingTrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(VirtualLoggingTrigger trigger) {
        this.trigger = trigger;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }
}

