/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.logging.deserializer;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.transaction.archive.TransactionArchive;
import org.bytesoft.transaction.archive.XAResourceArchive;
import org.bytesoft.transaction.logging.ArchiveDeserializer;
import org.bytesoft.transaction.xa.TransactionXid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionArchiveDeserializer
implements ArchiveDeserializer {
    static final Logger logger = LoggerFactory.getLogger(TransactionArchiveDeserializer.class);
    private ArchiveDeserializer resourceArchiveDeserializer;

    public byte[] serialize(TransactionXid xid, Object obj) {
        byte[] elementByteArray;
        int i;
        TransactionArchive archive = (TransactionArchive)obj;
        String propagatedBy = String.valueOf(archive.getPropagatedBy());
        String[] address = propagatedBy.split("\\s*\\:\\s*");
        byte[] hostByteArray = new byte[4];
        byte[] nameByteArray = new byte[]{};
        byte[] portByteArray = new byte[2];
        if (address.length == 3) {
            String hostStr = address[0];
            String nameStr = address[1];
            String portStr = address[2];
            String[] hostArray = hostStr.split("\\s*\\.\\s*");
            for (int i2 = 0; hostArray.length == 4 && i2 < hostArray.length; ++i2) {
                try {
                    int value = Integer.valueOf(hostArray[i2]);
                    hostByteArray[i2] = (byte)(value - 128);
                    continue;
                }
                catch (RuntimeException rex) {
                    logger.debug(rex.getMessage(), (Throwable)rex);
                }
            }
            nameByteArray = StringUtils.isBlank((CharSequence)nameStr) ? new byte[]{} : nameStr.getBytes();
            try {
                short port = (short)(Integer.valueOf(portStr) - 32768);
                byte[] byteArray = ByteUtils.shortToByteArray(port);
                System.arraycopy(byteArray, 0, portByteArray, 0, 2);
            }
            catch (RuntimeException rex) {
                logger.debug(rex.getMessage(), (Throwable)rex);
            }
        }
        XAResourceArchive optimizedArchive = archive.getOptimizedResource();
        List<XAResourceArchive> nativeArchiveList = archive.getNativeResources();
        List<XAResourceArchive> remoteArchiveList = archive.getRemoteResources();
        int optimizedArchiveNumber = optimizedArchive == null ? 0 : 1;
        int nativeArchiveNumber = nativeArchiveList.size();
        int remoteArchiveNumber = remoteArchiveList.size();
        int transactionStrategy = archive.getTransactionStrategyType();
        int length = 12 + nameByteArray.length + 2;
        byte[][] nativeByteArray = new byte[nativeArchiveNumber][];
        for (int i3 = 0; i3 < nativeArchiveNumber; ++i3) {
            XAResourceArchive resourceArchive = nativeArchiveList.get(i3);
            byte[] resourceByteArray = this.resourceArchiveDeserializer.serialize(xid, resourceArchive);
            byte[] lengthByteArray = ByteUtils.shortToByteArray((short)resourceByteArray.length);
            byte[] elementByteArray2 = new byte[resourceByteArray.length + 2];
            System.arraycopy(lengthByteArray, 0, elementByteArray2, 0, lengthByteArray.length);
            System.arraycopy(resourceByteArray, 0, elementByteArray2, 2, resourceByteArray.length);
            nativeByteArray[i3] = elementByteArray2;
            length += elementByteArray2.length;
        }
        byte[] optimizedByteArray = new byte[]{};
        if (optimizedArchiveNumber > 0) {
            byte[] resourceByteArray = this.resourceArchiveDeserializer.serialize(xid, optimizedArchive);
            byte[] lengthByteArray = ByteUtils.shortToByteArray((short)resourceByteArray.length);
            byte[] elementByteArray3 = new byte[resourceByteArray.length + 2];
            System.arraycopy(lengthByteArray, 0, elementByteArray3, 0, lengthByteArray.length);
            System.arraycopy(resourceByteArray, 0, elementByteArray3, 2, resourceByteArray.length);
            optimizedByteArray = elementByteArray3;
            length += elementByteArray3.length;
        }
        byte[][] remoteByteArray = new byte[remoteArchiveNumber][];
        for (int i4 = 0; i4 < remoteArchiveNumber; ++i4) {
            XAResourceArchive resourceArchive = remoteArchiveList.get(i4);
            byte[] resourceByteArray = this.resourceArchiveDeserializer.serialize(xid, resourceArchive);
            byte[] lengthByteArray = ByteUtils.shortToByteArray((short)resourceByteArray.length);
            byte[] elementByteArray4 = new byte[resourceByteArray.length + 2];
            System.arraycopy(lengthByteArray, 0, elementByteArray4, 0, lengthByteArray.length);
            System.arraycopy(resourceByteArray, 0, elementByteArray4, 2, resourceByteArray.length);
            remoteByteArray[i4] = elementByteArray4;
            length += elementByteArray4.length;
        }
        int position = 0;
        byte[] byteArray = new byte[length];
        byteArray[position++] = (byte)archive.getStatus();
        byteArray[position++] = (byte)archive.getVote();
        byteArray[position++] = archive.isCoordinator() ? (byte)1 : 0;
        byteArray[position++] = (byte)nativeArchiveNumber;
        byteArray[position++] = (byte)optimizedArchiveNumber;
        byteArray[position++] = (byte)remoteArchiveNumber;
        byteArray[position++] = (byte)transactionStrategy;
        System.arraycopy(hostByteArray, 0, byteArray, position, 4);
        position += 4;
        byteArray[position++] = (byte)(nameByteArray.length - 128);
        System.arraycopy(nameByteArray, 0, byteArray, position, nameByteArray.length);
        System.arraycopy(portByteArray, 0, byteArray, position += nameByteArray.length, 2);
        position += 2;
        for (i = 0; i < nativeArchiveNumber; ++i) {
            elementByteArray = nativeByteArray[i];
            System.arraycopy(elementByteArray, 0, byteArray, position, elementByteArray.length);
            position += elementByteArray.length;
        }
        if (optimizedArchiveNumber > 0) {
            System.arraycopy(optimizedByteArray, 0, byteArray, position, optimizedByteArray.length);
            position += optimizedByteArray.length;
        }
        for (i = 0; i < remoteArchiveNumber; ++i) {
            elementByteArray = remoteByteArray[i];
            System.arraycopy(elementByteArray, 0, byteArray, position, elementByteArray.length);
            position += elementByteArray.length;
        }
        return byteArray;
    }

    public Object deserialize(TransactionXid xid, byte[] array) {
        XAResourceArchive resourceArchive;
        byte[] resourceByteArray;
        int i;
        ByteBuffer buffer = ByteBuffer.wrap(array);
        TransactionArchive archive = new TransactionArchive();
        archive.setXid(xid);
        byte status = buffer.get();
        byte vote = buffer.get();
        byte coordinatorValue = buffer.get();
        archive.setStatus(status);
        archive.setVote(vote);
        archive.setCoordinator(coordinatorValue != 0);
        int nativeArchiveNumber = buffer.get();
        byte optimizedArchiveNumber = buffer.get();
        byte remoteArchiveNumber = buffer.get();
        byte transactionStrategyType = buffer.get();
        archive.setTransactionStrategyType(transactionStrategyType);
        byte[] hostByteArray = new byte[4];
        buffer.get(hostByteArray);
        StringBuilder ber = new StringBuilder();
        for (int i2 = 0; i2 < hostByteArray.length; ++i2) {
            int value = hostByteArray[i2] + 128;
            if (i2 == 0) {
                ber.append(value);
                continue;
            }
            ber.append(".");
            ber.append(value);
        }
        String host = ber.toString();
        int sizeOfName = 128 + buffer.get();
        byte[] nameByteArray = new byte[sizeOfName];
        buffer.get(nameByteArray);
        String name = new String(nameByteArray);
        int port = 32768 + buffer.getShort();
        archive.setPropagatedBy(String.format("%s:%s:%s", host, name, port));
        for (i = 0; i < nativeArchiveNumber; ++i) {
            short length = buffer.getShort();
            resourceByteArray = new byte[length];
            buffer.get(resourceByteArray);
            resourceArchive = (XAResourceArchive)this.resourceArchiveDeserializer.deserialize(xid, resourceByteArray);
            archive.getNativeResources().add(resourceArchive);
        }
        if (optimizedArchiveNumber > 0) {
            short length = buffer.getShort();
            byte[] resourceByteArray2 = new byte[length];
            buffer.get(resourceByteArray2);
            XAResourceArchive resourceArchive2 = (XAResourceArchive)this.resourceArchiveDeserializer.deserialize(xid, resourceByteArray2);
            archive.setOptimizedResource(resourceArchive2);
        }
        for (i = 0; i < remoteArchiveNumber; ++i) {
            short length = buffer.getShort();
            resourceByteArray = new byte[length];
            buffer.get(resourceByteArray);
            resourceArchive = (XAResourceArchive)this.resourceArchiveDeserializer.deserialize(xid, resourceByteArray);
            archive.getRemoteResources().add(resourceArchive);
        }
        return archive;
    }

    public ArchiveDeserializer getResourceArchiveDeserializer() {
        return this.resourceArchiveDeserializer;
    }

    public void setResourceArchiveDeserializer(ArchiveDeserializer resourceArchiveDeserializer) {
        this.resourceArchiveDeserializer = resourceArchiveDeserializer;
    }
}

