/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.logging;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.transaction.xa.Xid;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.logging.store.VirtualLoggingSystemImpl;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.archive.TransactionArchive;
import org.bytesoft.transaction.archive.XAResourceArchive;
import org.bytesoft.transaction.aware.TransactionBeanFactoryAware;
import org.bytesoft.transaction.aware.TransactionEndpointAware;
import org.bytesoft.transaction.logging.ArchiveDeserializer;
import org.bytesoft.transaction.logging.LoggingFlushable;
import org.bytesoft.transaction.logging.TransactionLogger;
import org.bytesoft.transaction.logging.store.VirtualLoggingListener;
import org.bytesoft.transaction.logging.store.VirtualLoggingRecord;
import org.bytesoft.transaction.recovery.TransactionRecoveryCallback;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleTransactionLogger
extends VirtualLoggingSystemImpl
implements TransactionLogger,
LoggingFlushable,
TransactionBeanFactoryAware,
TransactionEndpointAware {
    static final Logger logger = LoggerFactory.getLogger(SampleTransactionLogger.class);
    @Inject
    private TransactionBeanFactory beanFactory;
    private String endpoint;

    @Override
    public void createTransaction(TransactionArchive archive) {
        ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        try {
            byte[] byteArray = deserializer.serialize((TransactionXid)archive.getXid(), archive);
            this.create(archive.getXid(), byteArray);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while creating transaction-archive.", (Throwable)rex);
        }
    }

    @Override
    public void updateTransaction(TransactionArchive archive) {
        ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        try {
            byte[] byteArray = deserializer.serialize((TransactionXid)archive.getXid(), archive);
            this.modify(archive.getXid(), byteArray);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while modifying transaction-archive.", (Throwable)rex);
        }
    }

    @Override
    public void deleteTransaction(TransactionArchive archive) {
        try {
            this.delete(archive.getXid());
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while deleting transaction-archive.", (Throwable)rex);
        }
    }

    @Override
    public void updateResource(XAResourceArchive archive) {
        ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        try {
            byte[] byteArray = deserializer.serialize((TransactionXid)archive.getXid(), archive);
            this.modify(archive.getXid(), byteArray);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while modifying resource-archive.", (Throwable)rex);
        }
    }

    @Override
    public List<VirtualLoggingRecord> compressIfNecessary(List<VirtualLoggingRecord> recordList) {
        ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        XidFactory xidFactory = this.beanFactory.getXidFactory();
        ArrayList<VirtualLoggingRecord> resultList = new ArrayList<VirtualLoggingRecord>();
        HashMap<TransactionXid, TransactionArchive> xidMap = new HashMap<TransactionXid, TransactionArchive>();
        for (int index = 0; recordList != null && index < recordList.size(); ++index) {
            VirtualLoggingRecord record = recordList.get(index);
            byte[] byteArray = record.getContent();
            byte[] keyByteArray = new byte[20];
            System.arraycopy(byteArray, 0, keyByteArray, 0, keyByteArray.length);
            byte[] valueByteArray = new byte[byteArray.length - 20 - 1 - 4];
            System.arraycopy(byteArray, 25, valueByteArray, 0, valueByteArray.length);
            TransactionXid xid = xidFactory.createGlobalXid(keyByteArray);
            Object obj = deserializer.deserialize(xid, valueByteArray);
            if (TransactionArchive.class.isInstance(obj)) {
                xidMap.put(xid, (TransactionArchive)obj);
                continue;
            }
            if (XAResourceArchive.class.isInstance(obj)) {
                TransactionArchive archive = (TransactionArchive)xidMap.get(xid);
                if (archive == null) {
                    logger.error("Error occurred while compressing resource archive: {}", obj);
                    continue;
                }
                XAResourceArchive resourceArchive = (XAResourceArchive)obj;
                boolean matched = false;
                List<XAResourceArchive> nativeResources = archive.getNativeResources();
                for (int i = 0; !matched && nativeResources != null && i < nativeResources.size(); ++i) {
                    XAResourceArchive element = nativeResources.get(i);
                    if (!resourceArchive.getXid().equals(element.getXid())) continue;
                    matched = true;
                    nativeResources.set(i, resourceArchive);
                }
                XAResourceArchive optimizedResource = archive.getOptimizedResource();
                if (!matched && optimizedResource != null && resourceArchive.getXid().equals(optimizedResource.getXid())) {
                    matched = true;
                    archive.setOptimizedResource(resourceArchive);
                }
                List<XAResourceArchive> remoteResources = archive.getRemoteResources();
                for (int i = 0; !matched && remoteResources != null && i < remoteResources.size(); ++i) {
                    XAResourceArchive element = remoteResources.get(i);
                    if (!resourceArchive.getXid().equals(element.getXid())) continue;
                    matched = true;
                    remoteResources.set(i, resourceArchive);
                }
                if (matched) continue;
                logger.error("Error occurred while compressing resource archive: {}, invalid resoure!", obj);
                continue;
            }
            logger.error("unkown resource: {}!", obj);
        }
        for (Map.Entry entry : xidMap.entrySet()) {
            TransactionXid xid = (TransactionXid)entry.getKey();
            TransactionArchive value = (TransactionArchive)entry.getValue();
            byte[] globalByteArray = xid.getGlobalTransactionId();
            byte[] keyByteArray = new byte[20];
            byte[] valueByteArray = deserializer.serialize(xid, value);
            byte[] sizeByteArray = ByteUtils.intToByteArray(valueByteArray.length);
            System.arraycopy(globalByteArray, 0, keyByteArray, 0, 20);
            byte[] byteArray = new byte[25 + valueByteArray.length];
            System.arraycopy(keyByteArray, 0, byteArray, 0, keyByteArray.length);
            byteArray[keyByteArray.length] = 1;
            System.arraycopy(sizeByteArray, 0, byteArray, 21, sizeByteArray.length);
            System.arraycopy(valueByteArray, 0, byteArray, 25, valueByteArray.length);
            VirtualLoggingRecord record = new VirtualLoggingRecord();
            record.setIdentifier(xid);
            record.setOperator(1);
            record.setValue(valueByteArray);
            record.setContent(byteArray);
            resultList.add(record);
        }
        return resultList;
    }

    @Override
    public void recover(TransactionRecoveryCallback callback) {
        final HashMap xidMap = new HashMap();
        final ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        final XidFactory xidFactory = this.beanFactory.getXidFactory();
        this.traversal(new VirtualLoggingListener(){

            public void recvOperation(VirtualLoggingRecord action) {
                Xid xid = action.getIdentifier();
                int operator = action.getOperator();
                if (3 == operator) {
                    xidMap.remove(xid);
                } else if (!xidMap.containsKey(xid)) {
                    xidMap.put(xid, null);
                }
            }
        });
        this.traversal(new VirtualLoggingListener(){

            public void recvOperation(VirtualLoggingRecord action) {
                Xid xid = action.getIdentifier();
                if (xidMap.containsKey(xid)) {
                    this.execOperation(action);
                }
            }

            public void execOperation(VirtualLoggingRecord action) {
                Xid identifier = action.getIdentifier();
                TransactionXid xid = xidFactory.createGlobalXid(identifier.getGlobalTransactionId());
                Object obj = deserializer.deserialize(xid, action.getValue());
                if (TransactionArchive.class.isInstance(obj)) {
                    TransactionArchive archive = (TransactionArchive)obj;
                    xidMap.put(identifier, archive);
                } else if (XAResourceArchive.class.isInstance(obj)) {
                    TransactionArchive archive = (TransactionArchive)xidMap.get(identifier);
                    if (archive == null) {
                        logger.error("Error occurred while recovering resource archive: {}", obj);
                        return;
                    }
                    XAResourceArchive resourceArchive = (XAResourceArchive)obj;
                    boolean matched = false;
                    List<XAResourceArchive> nativeResources = archive.getNativeResources();
                    for (int i = 0; !matched && nativeResources != null && i < nativeResources.size(); ++i) {
                        XAResourceArchive element = nativeResources.get(i);
                        if (!resourceArchive.getXid().equals(element.getXid())) continue;
                        matched = true;
                        nativeResources.set(i, resourceArchive);
                    }
                    XAResourceArchive optimizedResource = archive.getOptimizedResource();
                    if (!matched && optimizedResource != null && resourceArchive.getXid().equals(optimizedResource.getXid())) {
                        matched = true;
                        archive.setOptimizedResource(resourceArchive);
                    }
                    List<XAResourceArchive> remoteResources = archive.getRemoteResources();
                    for (int i = 0; !matched && remoteResources != null && i < remoteResources.size(); ++i) {
                        XAResourceArchive element = remoteResources.get(i);
                        if (!resourceArchive.getXid().equals(element.getXid())) continue;
                        matched = true;
                        remoteResources.set(i, resourceArchive);
                    }
                    if (!matched) {
                        logger.error("Error occurred while recovering resource archive: {}, invalid resoure!", obj);
                    }
                }
            }
        });
        for (Map.Entry entry : xidMap.entrySet()) {
            TransactionArchive archive = (TransactionArchive)entry.getValue();
            if (archive == null) continue;
            try {
                callback.recover(archive);
            }
            catch (RuntimeException rex) {
                logger.error("Error occurred while recovering transaction(xid= {}).", (Object)archive.getXid(), (Object)rex);
            }
        }
    }

    @Override
    public File getDefaultDirectory() {
        String address = StringUtils.trimToEmpty((String)this.endpoint);
        File directory = new File(String.format("bytejta/%s", address.replaceAll("[^a-zA-Z_0-9]", "_")));
        if (!directory.exists()) {
            try {
                boolean created = directory.mkdirs();
                if (!created) {
                    logger.error("Failed to create directory {}!", (Object)directory.getAbsolutePath());
                }
            }
            catch (SecurityException ex) {
                logger.error("Error occurred while creating directory {}!", (Object)directory.getAbsolutePath(), (Object)ex);
            }
        }
        return directory;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 4;
    }

    @Override
    public String getLoggingFilePrefix() {
        return "bytejta-";
    }

    @Override
    public String getLoggingIdentifier() {
        return "org.bytesoft.bytejta.logging.sample";
    }

    @Override
    public void setEndpoint(String identifier) {
        this.endpoint = identifier;
    }

    public TransactionBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    public void setBeanFactory(TransactionBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

