/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.logging;

import org.bytesoft.transaction.archive.TransactionArchive;
import org.bytesoft.transaction.archive.XAResourceArchive;
import org.bytesoft.transaction.logging.ArchiveDeserializer;
import org.bytesoft.transaction.xa.TransactionXid;

public class ArchiveDeserializerImpl
implements ArchiveDeserializer {
    static final byte TYPE_TRANSACTION = 0;
    static final byte TYPE_XA_RESOURCE = 1;
    private ArchiveDeserializer xaResourceArchiveDeserializer;
    private ArchiveDeserializer transactionArchiveDeserializer;

    public byte[] serialize(TransactionXid xid, Object archive) {
        if (TransactionArchive.class.isInstance(archive)) {
            byte[] array = this.transactionArchiveDeserializer.serialize(xid, archive);
            byte[] byteArray = new byte[array.length + 1];
            byteArray[0] = 0;
            System.arraycopy(array, 0, byteArray, 1, array.length);
            return byteArray;
        }
        if (XAResourceArchive.class.isInstance(archive)) {
            byte[] array = this.xaResourceArchiveDeserializer.serialize(xid, archive);
            byte[] byteArray = new byte[array.length + 1];
            byteArray[0] = 1;
            System.arraycopy(array, 0, byteArray, 1, array.length);
            return byteArray;
        }
        throw new IllegalArgumentException();
    }

    public Object deserialize(TransactionXid xid, byte[] array) {
        if (array == null || array.length <= 1) {
            throw new IllegalArgumentException();
        }
        byte type = array[0];
        if (type == 0) {
            byte[] byteArray = new byte[array.length - 1];
            System.arraycopy(array, 1, byteArray, 0, byteArray.length);
            return this.transactionArchiveDeserializer.deserialize(xid, byteArray);
        }
        if (type == 1) {
            byte[] byteArray = new byte[array.length - 1];
            System.arraycopy(array, 1, byteArray, 0, byteArray.length);
            return this.xaResourceArchiveDeserializer.deserialize(xid, byteArray);
        }
        throw new IllegalArgumentException();
    }

    public ArchiveDeserializer getXaResourceArchiveDeserializer() {
        return this.xaResourceArchiveDeserializer;
    }

    public void setXaResourceArchiveDeserializer(ArchiveDeserializer xaResourceArchiveDeserializer) {
        this.xaResourceArchiveDeserializer = xaResourceArchiveDeserializer;
    }

    public ArchiveDeserializer getTransactionArchiveDeserializer() {
        return this.transactionArchiveDeserializer;
    }

    public void setTransactionArchiveDeserializer(ArchiveDeserializer transactionArchiveDeserializer) {
        this.transactionArchiveDeserializer = transactionArchiveDeserializer;
    }
}

