/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bytesoft.transaction.Transaction;
import org.bytesoft.transaction.TransactionRepository;
import org.bytesoft.transaction.xa.TransactionXid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionRepositoryImpl
implements TransactionRepository {
    private final Map<TransactionXid, Transaction> xidToTxMap = new ConcurrentHashMap<TransactionXid, Transaction>();
    private final Map<TransactionXid, Transaction> xidToErrTxMap = new ConcurrentHashMap<TransactionXid, Transaction>();

    @Override
    public void putTransaction(TransactionXid globalXid, Transaction transaction) {
        this.xidToTxMap.put(globalXid, transaction);
    }

    @Override
    public Transaction getTransaction(TransactionXid globalXid) {
        return this.xidToTxMap.get(globalXid);
    }

    @Override
    public Transaction removeTransaction(TransactionXid globalXid) {
        return this.xidToTxMap.remove(globalXid);
    }

    @Override
    public void putErrorTransaction(TransactionXid globalXid, Transaction transaction) {
        this.xidToErrTxMap.put(globalXid, transaction);
    }

    @Override
    public Transaction getErrorTransaction(TransactionXid globalXid) {
        return this.xidToErrTxMap.get(globalXid);
    }

    @Override
    public Transaction removeErrorTransaction(TransactionXid globalXid) {
        return this.xidToErrTxMap.remove(globalXid);
    }

    @Override
    public List<Transaction> getErrorTransactionList() {
        return new ArrayList<Transaction>(this.xidToErrTxMap.values());
    }

    @Override
    public List<Transaction> getActiveTransactionList() {
        return new ArrayList<Transaction>(this.xidToTxMap.values());
    }
}

