/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.transaction.SystemException;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.TransactionCoordinator;
import org.bytesoft.bytejta.TransactionImpl;
import org.bytesoft.bytejta.supports.resource.RemoteResourceDescriptor;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.transaction.CommitRequiredException;
import org.bytesoft.transaction.RollbackRequiredException;
import org.bytesoft.transaction.Transaction;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.TransactionContext;
import org.bytesoft.transaction.TransactionRecovery;
import org.bytesoft.transaction.TransactionRepository;
import org.bytesoft.transaction.archive.TransactionArchive;
import org.bytesoft.transaction.archive.XAResourceArchive;
import org.bytesoft.transaction.aware.TransactionBeanFactoryAware;
import org.bytesoft.transaction.logging.TransactionLogger;
import org.bytesoft.transaction.recovery.TransactionRecoveryCallback;
import org.bytesoft.transaction.recovery.TransactionRecoveryListener;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionRecoveryImpl
implements TransactionRecovery,
TransactionBeanFactoryAware {
    static final Logger logger = LoggerFactory.getLogger(TransactionRecoveryImpl.class);
    private TransactionRecoveryListener listener;
    @Inject
    private TransactionBeanFactory beanFactory;

    public synchronized void timingRecover() {
        TransactionRepository transactionRepository = this.beanFactory.getTransactionRepository();
        List<Transaction> transactions = transactionRepository.getErrorTransactionList();
        int total = transactions == null ? 0 : transactions.size();
        int value = 0;
        for (int i = 0; transactions != null && i < transactions.size(); ++i) {
            Transaction transaction = transactions.get(i);
            TransactionContext transactionContext = transaction.getTransactionContext();
            TransactionXid xid = transactionContext.getXid();
            try {
                this.recoverTransaction(transaction);
                ++value;
                continue;
            }
            catch (CommitRequiredException ex) {
                logger.debug("[{}] recover: branch={}, message= commit-required", new Object[]{ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), ByteUtils.byteArrayToString(xid.getBranchQualifier()), ex});
                continue;
            }
            catch (RollbackRequiredException ex) {
                logger.debug("[{}] recover: branch={}, message= rollback-required", new Object[]{ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), ByteUtils.byteArrayToString(xid.getBranchQualifier()), ex});
                continue;
            }
            catch (SystemException ex) {
                logger.debug("[{}] recover: branch={}, message= {}", new Object[]{ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), ByteUtils.byteArrayToString(xid.getBranchQualifier()), ex.getMessage(), ex});
                continue;
            }
            catch (RuntimeException ex) {
                logger.debug("[{}] recover: branch={}, message= {}", new Object[]{ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), ByteUtils.byteArrayToString(xid.getBranchQualifier()), ex.getMessage(), ex});
            }
        }
        logger.debug("[transaction-recovery] total= {}, success= {}", (Object)total, (Object)value);
    }

    public void recoverTransaction(Transaction transaction) throws CommitRequiredException, RollbackRequiredException, SystemException {
        TransactionContext transactionContext = transaction.getTransactionContext();
        boolean coordinator = transactionContext.isCoordinator();
        if (coordinator) {
            transaction.recover();
            this.recoverCoordinator(transaction);
        } else {
            transaction.recover();
            this.recoverParticipant(transaction);
        }
    }

    private void recoverCoordinator(Transaction transaction) throws CommitRequiredException, RollbackRequiredException, SystemException {
        switch (transaction.getTransactionStatus()) {
            case 0: 
            case 1: 
            case 5: 
            case 7: 
            case 9: {
                transaction.recoveryRollback();
                transaction.forgetQuietly();
                break;
            }
            case 2: 
            case 8: {
                transaction.recoveryCommit();
                transaction.forgetQuietly();
                break;
            }
            case 3: 
            case 4: {
                transaction.forgetQuietly();
                break;
            }
            default: {
                logger.debug("Current transaction has already been completed.");
            }
        }
    }

    private void recoverParticipant(Transaction transaction) throws CommitRequiredException, RollbackRequiredException, SystemException {
        TransactionImpl transactionImpl = (TransactionImpl)transaction;
        switch (transaction.getTransactionStatus()) {
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                transactionImpl.recoveryRollback();
                transactionImpl.forgetQuietly();
            }
        }
    }

    public synchronized void startRecovery() {
        final TransactionRepository transactionRepository = this.beanFactory.getTransactionRepository();
        final TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        transactionLogger.recover(new TransactionRecoveryCallback(){

            public void recover(TransactionArchive archive) {
                try {
                    TransactionImpl transaction = TransactionRecoveryImpl.this.reconstructTransaction(archive);
                    if (TransactionRecoveryImpl.this.listener != null) {
                        TransactionRecoveryImpl.this.listener.onRecovery(transaction);
                    }
                    TransactionContext transactionContext = transaction.getTransactionContext();
                    TransactionXid globalXid = transactionContext.getXid();
                    transactionRepository.putTransaction(globalXid, transaction);
                    transactionRepository.putErrorTransaction(globalXid, transaction);
                }
                catch (IllegalStateException ex) {
                    transactionLogger.deleteTransaction(archive);
                }
            }
        });
        TransactionCoordinator transactionCoordinator = (TransactionCoordinator)this.beanFactory.getTransactionCoordinator();
        transactionCoordinator.markParticipantReady();
    }

    private TransactionImpl reconstructTransaction(TransactionArchive archive) throws IllegalStateException {
        XidFactory xidFactory = this.beanFactory.getXidFactory();
        TransactionContext transactionContext = new TransactionContext();
        TransactionXid xid = (TransactionXid)archive.getXid();
        transactionContext.setXid(xidFactory.createGlobalXid(xid.getGlobalTransactionId()));
        transactionContext.setRecoveried(true);
        transactionContext.setCoordinator(archive.isCoordinator());
        transactionContext.setPropagatedBy(archive.getPropagatedBy());
        TransactionImpl transaction = new TransactionImpl(transactionContext);
        transaction.setBeanFactory(this.beanFactory);
        transaction.setTransactionStatus(archive.getStatus());
        List<XAResourceArchive> nativeResources = archive.getNativeResources();
        transaction.getNativeParticipantList().addAll(nativeResources);
        transaction.setParticipant(archive.getOptimizedResource());
        List<XAResourceArchive> remoteResources = archive.getRemoteResources();
        transaction.getRemoteParticipantList().addAll(remoteResources);
        List<XAResourceArchive> participants = transaction.getParticipantList();
        Map<String, XAResourceArchive> applicationMap = transaction.getApplicationMap();
        Map<String, XAResourceArchive> participantMap = transaction.getParticipantMap();
        if (archive.getOptimizedResource() != null) {
            participants.add(archive.getOptimizedResource());
        }
        participants.addAll(nativeResources);
        participants.addAll(remoteResources);
        for (int i = 0; i < participants.size(); ++i) {
            XAResourceArchive element = participants.get(i);
            XAResourceDescriptor descriptor = element.getDescriptor();
            String identifier = StringUtils.trimToEmpty((String)descriptor.getIdentifier());
            if (RemoteResourceDescriptor.class.isInstance(descriptor)) {
                RemoteResourceDescriptor resourceDescriptor = (RemoteResourceDescriptor)descriptor;
                RemoteCoordinator remoteCoordinator = resourceDescriptor.getDelegate();
                applicationMap.put(remoteCoordinator.getApplication(), element);
            }
            participantMap.put(identifier, element);
        }
        transaction.recoverTransactionStrategy(archive.getTransactionStrategyType());
        if (archive.getVote() == 3) {
            throw new IllegalStateException("Transaction has already been completed!");
        }
        return transaction;
    }

    public void setBeanFactory(TransactionBeanFactory tbf) {
        this.beanFactory = tbf;
    }

    public TransactionRecoveryListener getListener() {
        return this.listener;
    }

    public void setListener(TransactionRecoveryListener listener) {
        this.listener = listener;
    }
}

