/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.AlertLevel;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateEntry;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerName;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.TrustedAuthority;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedDecryptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class JsseUtils {
    private static final boolean provTlsAllowLegacyMasterSecret = PropertyUtils.getBooleanSystemProperty("jdk.tls.allowLegacyMasterSecret", true);
    private static final boolean provTlsAllowLegacyResumption = PropertyUtils.getBooleanSystemProperty("jdk.tls.allowLegacyResumption", false);
    private static final boolean provTlsUseExtendedMasterSecret = PropertyUtils.getBooleanSystemProperty("jdk.tls.useExtendedMasterSecret", true);
    static final Set<BCCryptoPrimitive> KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC = Collections.unmodifiableSet(EnumSet.of(BCCryptoPrimitive.KEY_AGREEMENT));
    static final Set<BCCryptoPrimitive> KEY_ENCAPSULATION_CRYPTO_PRIMITIVES_BC = Collections.unmodifiableSet(EnumSet.of(BCCryptoPrimitive.KEY_ENCAPSULATION));
    static final Set<BCCryptoPrimitive> SIGNATURE_CRYPTO_PRIMITIVES_BC = Collections.unmodifiableSet(EnumSet.of(BCCryptoPrimitive.SIGNATURE));
    protected static X509Certificate[] EMPTY_CHAIN = new X509Certificate[0];

    JsseUtils() {
    }

    static boolean allowLegacyMasterSecret() {
        return provTlsAllowLegacyMasterSecret;
    }

    static boolean allowLegacyResumption() {
        return provTlsAllowLegacyResumption;
    }

    static <T> T[] clone(T[] TArray) {
        return null == TArray ? null : (Object[])TArray.clone();
    }

    static boolean contains(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    static <T> boolean containsNull(T[] TArray) {
        for (int i = 0; i < TArray.length; ++i) {
            if (null != TArray[i]) continue;
            return true;
        }
        return false;
    }

    static String[] copyOf(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, Math.min(stringArray.length, n));
        return stringArray2;
    }

    static TlsCredentialedDecryptor createCredentialedDecryptor(JcaTlsCrypto jcaTlsCrypto, BCX509Key bCX509Key) {
        PrivateKey privateKey = bCX509Key.getPrivateKey();
        Certificate certificate = JsseUtils.getCertificateMessage(jcaTlsCrypto, bCX509Key.getCertificateChain());
        return new JceDefaultTlsCredentialedDecryptor(jcaTlsCrypto, certificate, privateKey);
    }

    static TlsCredentialedSigner createCredentialedSigner(TlsContext tlsContext, JcaTlsCrypto jcaTlsCrypto, BCX509Key bCX509Key, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        TlsCryptoParameters tlsCryptoParameters = new TlsCryptoParameters(tlsContext);
        PrivateKey privateKey = bCX509Key.getPrivateKey();
        Certificate certificate = JsseUtils.getCertificateMessage(jcaTlsCrypto, bCX509Key.getCertificateChain());
        return new JcaDefaultTlsCredentialedSigner(tlsCryptoParameters, jcaTlsCrypto, privateKey, certificate, signatureAndHashAlgorithm);
    }

    static TlsCredentialedSigner createCredentialedSigner13(TlsContext tlsContext, JcaTlsCrypto jcaTlsCrypto, BCX509Key bCX509Key, SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) {
        TlsCryptoParameters tlsCryptoParameters = new TlsCryptoParameters(tlsContext);
        PrivateKey privateKey = bCX509Key.getPrivateKey();
        Certificate certificate = JsseUtils.getCertificateMessage13(jcaTlsCrypto, bCX509Key.getCertificateChain(), byArray);
        return new JcaDefaultTlsCredentialedSigner(tlsCryptoParameters, jcaTlsCrypto, privateKey, certificate, signatureAndHashAlgorithm);
    }

    static String[] resize(String[] stringArray, int n) {
        if (n < stringArray.length) {
            stringArray = JsseUtils.copyOf(stringArray, n);
        }
        return stringArray;
    }

    static String getApplicationProtocol(SecurityParameters securityParameters) {
        if (null == securityParameters || !securityParameters.isApplicationProtocolSet()) {
            return null;
        }
        ProtocolName protocolName = securityParameters.getApplicationProtocol();
        if (null == protocolName) {
            return "";
        }
        return protocolName.getUtf8Decoding();
    }

    static String getAuthTypeClient(short s) {
        switch (s) {
            case 1: {
                return "RSA";
            }
            case 2: {
                return "DSA";
            }
            case 3: {
                return "EC";
            }
            case 7: {
                return "Ed25519";
            }
            case 8: {
                return "Ed448";
            }
            case 4: 
            case 5: 
            case 6: {
                return "RSA";
            }
            case 9: 
            case 10: 
            case 11: {
                return "RSASSA-PSS";
            }
        }
        throw new IllegalArgumentException();
    }

    static String getAuthTypeServer(int n) {
        switch (n) {
            case 7: {
                return "DH_DSS";
            }
            case 9: {
                return "DH_RSA";
            }
            case 3: {
                return "DHE_DSS";
            }
            case 5: {
                return "DHE_RSA";
            }
            case 16: {
                return "ECDH_ECDSA";
            }
            case 18: {
                return "ECDH_RSA";
            }
            case 17: {
                return "ECDHE_ECDSA";
            }
            case 19: {
                return "ECDHE_RSA";
            }
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "KE:RSA";
            }
            case 22: {
                return "SRP_DSS";
            }
            case 23: {
                return "SRP_RSA";
            }
        }
        throw new IllegalArgumentException();
    }

    static Vector<X500Name> getCertificateAuthorities(BCX509ExtendedTrustManager bCX509ExtendedTrustManager) {
        HashSet<X500Principal> hashSet = new HashSet<X500Principal>();
        for (X509Certificate x509Certificate : bCX509ExtendedTrustManager.getAcceptedIssuers()) {
            if (x509Certificate.getBasicConstraints() < 0) continue;
            hashSet.add(x509Certificate.getSubjectX500Principal());
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        Vector vector = new Vector(hashSet.size());
        for (X500Principal x500Principal : hashSet) {
            vector.add(X500Name.getInstance((Object)x500Principal.getEncoded()));
        }
        return vector;
    }

    static Certificate getCertificateMessage(JcaTlsCrypto jcaTlsCrypto, X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            throw new IllegalArgumentException();
        }
        TlsCertificate[] tlsCertificateArray = new TlsCertificate[x509CertificateArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            tlsCertificateArray[i] = new JcaTlsCertificate(jcaTlsCrypto, x509CertificateArray[i]);
        }
        return new Certificate(tlsCertificateArray);
    }

    static Certificate getCertificateMessage13(JcaTlsCrypto jcaTlsCrypto, X509Certificate[] x509CertificateArray, byte[] byArray) {
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            throw new IllegalArgumentException();
        }
        CertificateEntry[] certificateEntryArray = new CertificateEntry[x509CertificateArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            JcaTlsCertificate jcaTlsCertificate = new JcaTlsCertificate(jcaTlsCrypto, x509CertificateArray[i]);
            Hashtable hashtable = null;
            certificateEntryArray[i] = new CertificateEntry(jcaTlsCertificate, hashtable);
        }
        return new Certificate(byArray, certificateEntryArray);
    }

    static X509Certificate getEndEntity(JcaTlsCrypto jcaTlsCrypto, Certificate certificate) throws IOException {
        if (certificate == null || certificate.isEmpty()) {
            return null;
        }
        return JsseUtils.getX509Certificate(jcaTlsCrypto, certificate.getCertificateAt(0));
    }

    static String getJcaSignatureAlgorithmBC(String string, String string2) {
        if (!string.endsWith("withRSAandMGF1")) {
            return string;
        }
        return string + ":" + string2;
    }

    static String getKeyType(SignatureSchemeInfo signatureSchemeInfo) {
        return signatureSchemeInfo.getKeyAlgorithm();
    }

    static String getKeyTypeLegacyClient(short s) {
        switch (s) {
            case 2: {
                return "DSA";
            }
            case 64: {
                return "EC";
            }
            case 1: {
                return "RSA";
            }
        }
        throw new IllegalArgumentException();
    }

    static String getKeyTypeLegacyServer(int n) {
        return JsseUtils.getAuthTypeServer(n);
    }

    static Vector<ProtocolName> getProtocolNames(String[] stringArray) {
        if (null == stringArray || stringArray.length < 1) {
            return null;
        }
        Vector<ProtocolName> vector = new Vector<ProtocolName>(stringArray.length);
        for (String string : stringArray) {
            vector.add(ProtocolName.asUtf8Encoding(string));
        }
        return vector;
    }

    static List<String> getProtocolNames(Vector<ProtocolName> vector) {
        if (null == vector || vector.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(vector.size());
        for (ProtocolName protocolName : vector) {
            arrayList.add(protocolName.getUtf8Decoding());
        }
        return arrayList;
    }

    static byte[] getStatusResponse(OCSPResponse oCSPResponse) throws IOException {
        return null == oCSPResponse ? TlsUtils.EMPTY_BYTES : oCSPResponse.getEncoded("DER");
    }

    static List<byte[]> getStatusResponses(CertificateStatus certificateStatus) throws IOException {
        if (null != certificateStatus) {
            switch (certificateStatus.getStatusType()) {
                case 1: {
                    OCSPResponse oCSPResponse = certificateStatus.getOCSPResponse();
                    return Collections.singletonList(JsseUtils.getStatusResponse(oCSPResponse));
                }
                case 2: {
                    Vector vector = certificateStatus.getOCSPResponseList();
                    int n = vector.size();
                    ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n);
                    for (int i = 0; i < n; ++i) {
                        OCSPResponse oCSPResponse = (OCSPResponse)vector.elementAt(i);
                        arrayList.add(JsseUtils.getStatusResponse(oCSPResponse));
                    }
                    return Collections.unmodifiableList(arrayList);
                }
            }
        }
        return null;
    }

    static X500Principal[] getTrustedIssuers(Vector<TrustedAuthority> vector) throws IOException {
        if (null == vector || vector.isEmpty()) {
            return null;
        }
        int n = vector.size();
        X500Principal[] x500PrincipalArray = new X500Principal[n];
        for (int i = 0; i < n; ++i) {
            TrustedAuthority trustedAuthority = vector.get(i);
            if (2 != trustedAuthority.getIdentifierType()) {
                return null;
            }
            x500PrincipalArray[i] = JsseUtils.toX500Principal(trustedAuthority.getX509Name());
        }
        return x500PrincipalArray;
    }

    static X509Certificate getX509Certificate(JcaTlsCrypto jcaTlsCrypto, TlsCertificate tlsCertificate) throws IOException {
        return JcaTlsCertificate.convert(jcaTlsCrypto, tlsCertificate).getX509Certificate();
    }

    static X509Certificate[] getX509CertificateChain(JcaTlsCrypto jcaTlsCrypto, Certificate certificate) {
        if (certificate == null || certificate.isEmpty()) {
            return EMPTY_CHAIN;
        }
        try {
            X509Certificate[] x509CertificateArray = new X509Certificate[certificate.getLength()];
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                x509CertificateArray[i] = JcaTlsCertificate.convert(jcaTlsCrypto, certificate.getCertificateAt(i)).getX509Certificate();
            }
            return x509CertificateArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static X509Certificate[] getX509CertificateChain(java.security.cert.Certificate[] certificateArray) {
        if (certificateArray == null) {
            return null;
        }
        if (certificateArray instanceof X509Certificate[]) {
            return JsseUtils.containsNull(certificateArray) ? null : (X509Certificate[])certificateArray;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            java.security.cert.Certificate certificate = certificateArray[i];
            if (!(certificate instanceof X509Certificate)) {
                return null;
            }
            x509CertificateArray[i] = (X509Certificate)certificate;
        }
        return x509CertificateArray;
    }

    static X500Principal getSubject(JcaTlsCrypto jcaTlsCrypto, Certificate certificate) {
        if (certificate == null || certificate.isEmpty()) {
            return null;
        }
        try {
            return JsseUtils.getX509Certificate(jcaTlsCrypto, certificate.getCertificateAt(0)).getSubjectX500Principal();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static String getAlertLogMessage(String string, short s, short s2) {
        return string + " " + AlertLevel.getText(s) + " " + AlertDescription.getText(s2) + " alert";
    }

    static String getKeyAlgorithm(Key key) {
        if (key instanceof PrivateKey) {
            return JsseUtils.getPrivateKeyAlgorithm((PrivateKey)key);
        }
        if (key instanceof PublicKey) {
            return JsseUtils.getPublicKeyAlgorithm((PublicKey)key);
        }
        return key.getAlgorithm();
    }

    static String getPrivateKeyAlgorithm(PrivateKey privateKey) {
        PrivateKeyInfo privateKeyInfo;
        String string = privateKey.getAlgorithm();
        if ("RSA".equalsIgnoreCase(string) && PKCSObjectIdentifiers.id_RSASSA_PSS.equals((ASN1Primitive)(privateKeyInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded())).getPrivateKeyAlgorithm().getAlgorithm())) {
            return "RSASSA-PSS";
        }
        return string;
    }

    static String getPublicKeyAlgorithm(PublicKey publicKey) {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        String string = publicKey.getAlgorithm();
        if ("RSA".equalsIgnoreCase(string) && PKCSObjectIdentifiers.id_RSASSA_PSS.equals((ASN1Primitive)(subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded())).getAlgorithm().getAlgorithm())) {
            return "RSASSA-PSS";
        }
        return string;
    }

    static boolean isNameSpecified(String string) {
        return null != string && string.length() > 0;
    }

    static boolean isTLSv12(String string) {
        ProtocolVersion protocolVersion = ProvSSLContextSpi.getProtocolVersion(string);
        return null != protocolVersion && TlsUtils.isTLSv12(protocolVersion);
    }

    static boolean isUsableKeyForServer(short s, PrivateKey privateKey) {
        String string = JsseUtils.getPrivateKeyAlgorithm(privateKey);
        switch (s) {
            case 2: {
                return privateKey instanceof DSAPrivateKey || "DSA".equalsIgnoreCase(string);
            }
            case 3: {
                return privateKey instanceof ECPrivateKey || "EC".equalsIgnoreCase(string);
            }
            case 7: {
                return "Ed25519".equalsIgnoreCase(string);
            }
            case 8: {
                return "Ed448".equalsIgnoreCase(string);
            }
            case 1: {
                return "RSA".equalsIgnoreCase(string);
            }
            case 4: 
            case 5: 
            case 6: {
                return "RSA".equalsIgnoreCase(string);
            }
            case 9: 
            case 10: 
            case 11: {
                return "RSASSA-PSS".equalsIgnoreCase(string);
            }
        }
        return false;
    }

    static boolean isUsableKeyForServerLegacy(int n, PrivateKey privateKey) {
        switch (n) {
            case 3: 
            case 5: 
            case 17: 
            case 19: {
                return JsseUtils.isUsableKeyForServer(TlsUtils.getLegacySignatureAlgorithmServer(n), privateKey);
            }
            case 1: {
                return "RSA".equalsIgnoreCase(JsseUtils.getPrivateKeyAlgorithm(privateKey));
            }
        }
        return false;
    }

    static X500Principal toX500Principal(X500Name x500Name) throws IOException {
        return null == x500Name ? null : new X500Principal(x500Name.getEncoded("DER"));
    }

    static X500Principal[] toX500Principals(Vector<X500Name> vector) throws IOException {
        if (null == vector) {
            return null;
        }
        LinkedHashSet<X500Principal> linkedHashSet = new LinkedHashSet<X500Principal>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            X500Principal x500Principal = JsseUtils.toX500Principal(vector.get(i));
            if (null == x500Principal) continue;
            linkedHashSet.add(x500Principal);
        }
        return linkedHashSet.toArray(new X500Principal[0]);
    }

    static BCSNIServerName convertSNIServerName(ServerName serverName) {
        short s = serverName.getNameType();
        byte[] byArray = serverName.getNameData();
        switch (s) {
            case 0: {
                return new BCSNIHostName(byArray);
            }
        }
        return new BCUnknownServerName(s, byArray);
    }

    static List<BCSNIServerName> convertSNIServerNames(Vector<ServerName> vector) {
        if (null == vector || vector.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BCSNIServerName> arrayList = new ArrayList<BCSNIServerName>(vector.size());
        Enumeration<ServerName> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add(JsseUtils.convertSNIServerName(enumeration.nextElement()));
        }
        return Collections.unmodifiableList(arrayList);
    }

    static BCSNIServerName findMatchingSNIServerName(Vector<ServerName> vector, Collection<BCSNIMatcher> collection) {
        if (!vector.isEmpty()) {
            List<BCSNIServerName> list = JsseUtils.convertSNIServerNames(vector);
            block0: for (BCSNIMatcher bCSNIMatcher : collection) {
                if (null == bCSNIMatcher) continue;
                int n = bCSNIMatcher.getType();
                for (BCSNIServerName bCSNIServerName : list) {
                    if (null == bCSNIServerName || bCSNIServerName.getType() != n) continue;
                    if (!bCSNIMatcher.matches(bCSNIServerName)) continue block0;
                    return bCSNIServerName;
                }
            }
        }
        return null;
    }

    static BCSNIHostName getSNIHostName(List<BCSNIServerName> list) {
        if (null != list) {
            for (BCSNIServerName bCSNIServerName : list) {
                if (null == bCSNIServerName || 0 != bCSNIServerName.getType()) continue;
                if (bCSNIServerName instanceof BCSNIHostName) {
                    return (BCSNIHostName)bCSNIServerName;
                }
                try {
                    return new BCSNIHostName(bCSNIServerName.getEncoded());
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }
        }
        return null;
    }

    static String stripDoubleQuotes(String string) {
        return JsseUtils.stripOuterChars(string, '\"', '\"');
    }

    static String stripSquareBrackets(String string) {
        return JsseUtils.stripOuterChars(string, '[', ']');
    }

    private static String stripOuterChars(String string, char c, char c2) {
        int n;
        if (string != null && (n = string.length() - 1) > 0 && string.charAt(0) == c && string.charAt(n) == c2) {
            return string.substring(1, n);
        }
        return string;
    }

    static boolean useExtendedMasterSecret() {
        return provTlsUseExtendedMasterSecret;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class BCUnknownServerName
    extends BCSNIServerName {
        BCUnknownServerName(int n, byte[] byArray) {
            super(n, byArray);
        }
    }
}

