/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.util.Arrays;

public class DataGroup {
    private List dataObjects;
    private byte[] groupHash;
    private TreeSet hashes;

    public DataGroup(List list) {
        this.dataObjects = list;
    }

    public DataGroup(byte[] byArray) {
        this.dataObjects = new ArrayList();
        this.dataObjects.add(byArray);
    }

    public TreeSet getHashes(DigestCalculator digestCalculator) {
        return this.getHashes(digestCalculator, null);
    }

    private TreeSet getHashes(DigestCalculator digestCalculator, byte[] byArray) {
        if (this.hashes == null) {
            this.hashes = new TreeSet(new ByteArrayComparator());
            for (int i = 0; i != this.dataObjects.size(); ++i) {
                byte[] byArray2 = (byte[])this.dataObjects.get(i);
                if (byArray != null) {
                    this.hashes.add(DataGroup.calcDigest(digestCalculator, Arrays.concatenate((byte[])DataGroup.calcDigest(digestCalculator, byArray2), (byte[])byArray)));
                    continue;
                }
                this.hashes.add(DataGroup.calcDigest(digestCalculator, byArray2));
            }
        }
        return this.hashes;
    }

    public byte[] getHash(DigestCalculator digestCalculator) {
        if (this.groupHash == null) {
            TreeSet treeSet = this.getHashes(digestCalculator);
            if (treeSet.size() > 1) {
                byte[] byArray = new byte[]{};
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    byArray = Arrays.concatenate((byte[])byArray, (byte[])((byte[])iterator.next()));
                }
                this.groupHash = DataGroup.calcDigest(digestCalculator, byArray);
            } else {
                this.groupHash = (byte[])treeSet.first();
            }
        }
        return this.groupHash;
    }

    static byte[] calcDigest(DigestCalculator digestCalculator, byte[] byArray) {
        try {
            OutputStream outputStream = digestCalculator.getOutputStream();
            outputStream.write(byArray);
            outputStream.close();
            return digestCalculator.getDigest();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("digest calculator failure: " + iOException.getMessage());
        }
    }

    private class ByteArrayComparator
    implements Comparator {
        private ByteArrayComparator() {
        }

        public int compare(Object object, Object object2) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = (byte[])object2;
            int n = byArray.length < byArray2.length ? byArray.length : byArray2.length;
            for (int i = 0; i != n; ++i) {
                int n2 = byArray[i] & 0xFF;
                int n3 = byArray2[i] & 0xFF;
                if (n2 == n3) continue;
                return n2 - n3;
            }
            return byArray.length - byArray2.length;
        }
    }
}

