/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import org.bouncycastle.asn1.cms.OriginatorPublicKey;
import org.bouncycastle.asn1.cms.RecipientEncryptedKey;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.IntRecipientInfoGenerator;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.MQVPrivateKeySpec;
import org.bouncycastle.jce.spec.MQVPublicKeySpec;

class KeyAgreeIntRecipientInfoGenerator
implements IntRecipientInfoGenerator {
    private DERObjectIdentifier keyAgreementOID;
    private DERObjectIdentifier keyEncryptionOID;
    private ArrayList recipientCerts;
    private KeyPair senderKeyPair;

    KeyAgreeIntRecipientInfoGenerator() {
    }

    void setKeyAgreementOID(DERObjectIdentifier dERObjectIdentifier) {
        this.keyAgreementOID = dERObjectIdentifier;
    }

    void setKeyEncryptionOID(DERObjectIdentifier dERObjectIdentifier) {
        this.keyEncryptionOID = dERObjectIdentifier;
    }

    void setRecipientCerts(Collection collection) {
        this.recipientCerts = new ArrayList(collection);
    }

    void setSenderKeyPair(KeyPair keyPair) {
        this.senderKeyPair = keyPair;
    }

    public RecipientInfo generate(SecretKey secretKey, SecureRandom secureRandom, Provider provider) throws GeneralSecurityException {
        KeyPair keyPair;
        KeyPairGenerator keyPairGenerator;
        ASN1EncodableVector aSN1EncodableVector;
        OriginatorIdentifierOrKey originatorIdentifierOrKey;
        PublicKey publicKey = this.senderKeyPair.getPublic();
        PrivateKey privateKey = this.senderKeyPair.getPrivate();
        try {
            originatorIdentifierOrKey = new OriginatorIdentifierOrKey(KeyAgreeIntRecipientInfoGenerator.createOriginatorPublicKey(publicKey));
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("cannot extract originator public key: " + iOException);
        }
        DEROctetString dEROctetString = null;
        if (this.keyAgreementOID.getId().equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
            try {
                aSN1EncodableVector = ((ECPublicKey)publicKey).getParameters();
                keyPairGenerator = KeyPairGenerator.getInstance(this.keyAgreementOID.getId(), provider);
                keyPairGenerator.initialize((AlgorithmParameterSpec)aSN1EncodableVector, secureRandom);
                keyPair = keyPairGenerator.generateKeyPair();
                dEROctetString = new DEROctetString((DEREncodable)new MQVuserKeyingMaterial(KeyAgreeIntRecipientInfoGenerator.createOriginatorPublicKey(keyPair.getPublic()), null));
                privateKey = new MQVPrivateKeySpec(privateKey, keyPair.getPrivate(), keyPair.getPublic());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidKeyException("cannot determine MQV ephemeral key pair parameters from public key: " + invalidAlgorithmParameterException);
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("cannot extract MQV ephemeral public key: " + iOException);
            }
        }
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)this.keyEncryptionOID);
        aSN1EncodableVector.add((DEREncodable)DERNull.INSTANCE);
        keyPairGenerator = new AlgorithmIdentifier(this.keyAgreementOID, (DEREncodable)new DERSequence(aSN1EncodableVector));
        keyPair = new ASN1EncodableVector();
        Iterator iterator = this.recipientCerts.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier = new KeyAgreeRecipientIdentifier(CMSUtils.getIssuerAndSerialNumber(x509Certificate));
            PublicKey publicKey2 = x509Certificate.getPublicKey();
            if (this.keyAgreementOID.getId().equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
                publicKey2 = new MQVPublicKeySpec(publicKey2, publicKey2);
            }
            KeyAgreement keyAgreement = KeyAgreement.getInstance(this.keyAgreementOID.getId(), provider);
            keyAgreement.init((Key)privateKey, secureRandom);
            keyAgreement.doPhase(publicKey2, true);
            SecretKey secretKey2 = keyAgreement.generateSecret(this.keyEncryptionOID.getId());
            Cipher cipher = CMSEnvelopedHelper.INSTANCE.createSymmetricCipher(this.keyEncryptionOID.getId(), provider);
            cipher.init(3, (Key)secretKey2, secureRandom);
            byte[] byArray = cipher.wrap(secretKey);
            DEROctetString dEROctetString2 = new DEROctetString(byArray);
            keyPair.add((DEREncodable)new RecipientEncryptedKey(keyAgreeRecipientIdentifier, (ASN1OctetString)dEROctetString2));
        }
        return new RecipientInfo(new KeyAgreeRecipientInfo(originatorIdentifierOrKey, (ASN1OctetString)dEROctetString, (AlgorithmIdentifier)keyPairGenerator, (ASN1Sequence)new DERSequence((ASN1EncodableVector)keyPair)));
    }

    private static OriginatorPublicKey createOriginatorPublicKey(PublicKey publicKey) throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)ASN1Object.fromByteArray((byte[])publicKey.getEncoded()));
        return new OriginatorPublicKey(new AlgorithmIdentifier(subjectPublicKeyInfo.getAlgorithmId().getObjectId(), (DEREncodable)DERNull.INSTANCE), subjectPublicKeyInfo.getPublicKeyData().getBytes());
    }
}

