/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldBeEqualByComparingFieldByFieldRecursively;
import org.assertj.core.error.ShouldBeEqualByComparingOnlyGivenFields;
import org.assertj.core.error.ShouldBeEqualToIgnoringFields;
import org.assertj.core.error.ShouldBeExactlyInstanceOf;
import org.assertj.core.error.ShouldBeIn;
import org.assertj.core.error.ShouldBeInstance;
import org.assertj.core.error.ShouldBeInstanceOfAny;
import org.assertj.core.error.ShouldBeOfClassIn;
import org.assertj.core.error.ShouldBeSame;
import org.assertj.core.error.ShouldHavePropertyOrField;
import org.assertj.core.error.ShouldHavePropertyOrFieldWithValue;
import org.assertj.core.error.ShouldHaveSameClass;
import org.assertj.core.error.ShouldHaveToString;
import org.assertj.core.error.ShouldNotBeEqual;
import org.assertj.core.error.ShouldNotBeExactlyInstanceOf;
import org.assertj.core.error.ShouldNotBeIn;
import org.assertj.core.error.ShouldNotBeInstance;
import org.assertj.core.error.ShouldNotBeInstanceOfAny;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.error.ShouldNotBeOfClassIn;
import org.assertj.core.error.ShouldNotBeSame;
import org.assertj.core.error.ShouldNotHaveSameClass;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.DeepDifference;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Sets;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.FieldSupport;
import org.assertj.core.util.introspection.IntrospectionError;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;
import org.assertj.core.util.introspection.PropertySupport;

public class Objects {
    private static final Objects INSTANCE = new Objects();
    @VisibleForTesting
    final PropertySupport propertySupport = PropertySupport.instance();
    private final ComparisonStrategy comparisonStrategy;
    @VisibleForTesting
    Failures failures = Failures.instance();
    private final FieldSupport fieldSupport = FieldSupport.comparison();

    public static Objects instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Objects() {
        this(StandardComparisonStrategy.instance());
    }

    public Objects(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        return this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy ? ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator() : null;
    }

    @VisibleForTesting
    public ComparisonStrategy getComparisonStrategy() {
        return this.comparisonStrategy;
    }

    public void assertIsInstanceOf(AssertionInfo info, Object actual, Class<?> type) {
        if (!this.isInstanceOfClass(actual, type, info)) {
            throw this.failures.failure(info, ShouldBeInstance.shouldBeInstance(actual, type));
        }
    }

    public void assertIsInstanceOfAny(AssertionInfo info, Object actual, Class<?>[] types) {
        if (this.objectIsInstanceOfOneOfGivenClasses(actual, types, info)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInstanceOfAny.shouldBeInstanceOfAny(actual, types));
    }

    private boolean objectIsInstanceOfOneOfGivenClasses(Object actual, Class<?>[] types, AssertionInfo info) {
        this.checkIsNotNullAndIsNotEmpty(types);
        this.assertNotNull(info, actual);
        for (Class<?> type : types) {
            String format = "The given array of types:<%s> should not have null elements";
            Preconditions.checkNotNull(type, String.format(format, info.representation().toStringOf(types)));
            if (!type.isInstance(actual)) continue;
            return true;
        }
        return false;
    }

    public void assertIsNotInstanceOf(AssertionInfo info, Object actual, Class<?> type) {
        if (this.isInstanceOfClass(actual, type, info)) {
            throw this.failures.failure(info, ShouldNotBeInstance.shouldNotBeInstance(actual, type));
        }
    }

    private boolean isInstanceOfClass(Object actual, Class<?> clazz, AssertionInfo info) {
        this.assertNotNull(info, actual);
        CommonValidations.checkTypeIsNotNull(clazz);
        return clazz.isInstance(actual);
    }

    public void assertIsNotInstanceOfAny(AssertionInfo info, Object actual, Class<?>[] types) {
        if (!this.objectIsInstanceOfOneOfGivenClasses(actual, types, info)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeInstanceOfAny.shouldNotBeInstanceOfAny(actual, types));
    }

    public void assertHasSameClassAs(AssertionInfo info, Object actual, Object other) {
        if (!this.haveSameClass(actual, other, info)) {
            throw this.failures.failure(info, ShouldHaveSameClass.shouldHaveSameClass(actual, other));
        }
    }

    private boolean haveSameClass(Object actual, Object other, AssertionInfo info) {
        this.assertNotNull(info, actual);
        Preconditions.checkNotNull(other, "The given object should not be null");
        Class<?> actualClass = actual.getClass();
        Class<?> otherClass = other.getClass();
        return actualClass.equals(otherClass);
    }

    public void assertDoesNotHaveSameClassAs(AssertionInfo info, Object actual, Object other) {
        if (this.haveSameClass(actual, other, info)) {
            throw this.failures.failure(info, ShouldNotHaveSameClass.shouldNotHaveSameClass(actual, other));
        }
    }

    public void assertIsExactlyInstanceOf(AssertionInfo info, Object actual, Class<?> type) {
        if (!this.actualIsExactlyInstanceOfType(actual, type, info)) {
            throw this.failures.failure(info, ShouldBeExactlyInstanceOf.shouldBeExactlyInstance(actual, type));
        }
    }

    private boolean actualIsExactlyInstanceOfType(Object actual, Class<?> expectedType, AssertionInfo info) {
        this.assertNotNull(info, actual);
        CommonValidations.checkTypeIsNotNull(expectedType);
        return expectedType.equals(actual.getClass());
    }

    public void assertIsNotExactlyInstanceOf(AssertionInfo info, Object actual, Class<?> type) {
        if (this.actualIsExactlyInstanceOfType(actual, type, info)) {
            throw this.failures.failure(info, ShouldNotBeExactlyInstanceOf.shouldNotBeExactlyInstance(actual, type));
        }
    }

    public void assertIsOfAnyClassIn(AssertionInfo info, Object actual, Class<?>[] types) {
        boolean itemInArray = this.isOfOneOfGivenTypes(actual, types, info);
        if (!itemInArray) {
            throw this.failures.failure(info, ShouldBeOfClassIn.shouldBeOfClassIn(actual, types));
        }
    }

    private boolean isOfOneOfGivenTypes(Object actual, Class<?>[] types, AssertionInfo info) {
        this.assertNotNull(info, actual);
        Preconditions.checkNotNull(types, "The given types should not be null");
        return this.isItemInArray(actual.getClass(), types);
    }

    public void assertIsNotOfAnyClassIn(AssertionInfo info, Object actual, Class<?>[] types) {
        boolean itemInArray = this.isOfOneOfGivenTypes(actual, types, info);
        if (itemInArray) {
            throw this.failures.failure(info, ShouldNotBeOfClassIn.shouldNotBeOfClassIn(actual, types));
        }
    }

    private void checkIsNotNullAndIsNotEmpty(Class<?>[] types) {
        Preconditions.checkNotNull(types, "The given array of types should not be null");
        if (types.length == 0) {
            throw new IllegalArgumentException("The given array of types should not be empty");
        }
    }

    public void assertEqual(AssertionInfo info, Object actual, Object expected) {
        if (this.areEqual(actual, expected)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(actual, expected, this.comparisonStrategy, info.representation()));
    }

    public void assertNotEqual(AssertionInfo info, Object actual, Object other) {
        if (!this.areEqual(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEqual.shouldNotBeEqual(actual, other, this.comparisonStrategy));
    }

    private boolean areEqual(Object actual, Object other) {
        return this.comparisonStrategy.areEqual(actual, other);
    }

    public void assertNull(AssertionInfo info, Object actual) {
        if (actual == null) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(actual, null, this.comparisonStrategy, info.representation()));
    }

    public void assertNotNull(AssertionInfo info, Object actual) {
        if (actual != null) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeNull.shouldNotBeNull());
    }

    public void assertSame(AssertionInfo info, Object actual, Object expected) {
        if (actual == expected) {
            return;
        }
        throw this.failures.failure(info, ShouldBeSame.shouldBeSame(actual, expected));
    }

    public void assertNotSame(AssertionInfo info, Object actual, Object other) {
        if (actual != other) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeSame.shouldNotBeSame(actual));
    }

    public void assertHasToString(AssertionInfo info, Object actual, String expectedToString) {
        this.assertNotNull(info, actual);
        if (!actual.toString().equals(expectedToString)) {
            throw this.failures.failure(info, ShouldHaveToString.shouldHaveToString(actual, expectedToString));
        }
    }

    public void assertIsIn(AssertionInfo info, Object actual, Object[] values) {
        this.checkIsNotNullAndNotEmpty(values);
        this.assertIsIn(info, actual, Arrays.asList(values));
    }

    public void assertIsNotIn(AssertionInfo info, Object actual, Object[] values) {
        this.checkIsNotNullAndNotEmpty(values);
        this.assertIsNotIn(info, actual, Arrays.asList(values));
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        Preconditions.checkNotNull(values, "The given array should not be null");
        if (values.length == 0) {
            throw new IllegalArgumentException("The given array should not be empty");
        }
    }

    private boolean isItemInArray(Object item, Object[] arrayOfValues) {
        for (Object value : arrayOfValues) {
            if (!this.areEqual(value, item)) continue;
            return true;
        }
        return false;
    }

    public void assertIsIn(AssertionInfo info, Object actual, Iterable<?> values) {
        this.checkIsNotNullAndNotEmpty(values);
        if (!this.isActualIn(actual, values)) {
            throw this.failures.failure(info, ShouldBeIn.shouldBeIn(actual, values, this.comparisonStrategy));
        }
    }

    public void assertIsNotIn(AssertionInfo info, Object actual, Iterable<?> values) {
        this.checkIsNotNullAndNotEmpty(values);
        if (this.isActualIn(actual, values)) {
            throw this.failures.failure(info, ShouldNotBeIn.shouldNotBeIn(actual, values, this.comparisonStrategy));
        }
    }

    private void checkIsNotNullAndNotEmpty(Iterable<?> values) {
        Preconditions.checkNotNull(values, "The given iterable should not be null");
        if (!values.iterator().hasNext()) {
            throw new IllegalArgumentException("The given iterable should not be empty");
        }
    }

    private boolean isActualIn(Object actual, Iterable<?> values) {
        for (Object value : values) {
            if (!this.areEqual(value, actual)) continue;
            return true;
        }
        return false;
    }

    public <A> void assertIsEqualToIgnoringNullFields(AssertionInfo info, A actual, A other, Map<String, Comparator<?>> comparatorByPropertyOrField, Map<Class<?>, Comparator<?>> comparatorByType) {
        this.assertNotNull(info, actual);
        LinkedList<String> fieldsNames = new LinkedList<String>();
        LinkedList<Object> rejectedValues = new LinkedList<Object>();
        LinkedList<Object> expectedValues = new LinkedList<Object>();
        LinkedList<String> nullFields = new LinkedList<String>();
        for (Field field : Objects.getDeclaredFieldsIncludingInherited(actual.getClass())) {
            if (!this.canReadFieldValue(field, actual)) continue;
            String fieldName = field.getName();
            Object otherFieldValue = this.getPropertyOrFieldValue(other, fieldName);
            if (otherFieldValue == null) {
                nullFields.add(fieldName);
                continue;
            }
            Object actualFieldValue = this.getPropertyOrFieldValue(actual, fieldName);
            if (Objects.propertyOrFieldValuesAreEqual(actualFieldValue, otherFieldValue, fieldName, comparatorByPropertyOrField, comparatorByType)) continue;
            fieldsNames.add(fieldName);
            rejectedValues.add(actualFieldValue);
            expectedValues.add(otherFieldValue);
        }
        if (!fieldsNames.isEmpty()) {
            throw this.failures.failure(info, ShouldBeEqualToIgnoringFields.shouldBeEqualToIgnoringGivenFields(actual, fieldsNames, rejectedValues, expectedValues, nullFields));
        }
    }

    public <A> void assertIsEqualToComparingOnlyGivenFields(AssertionInfo info, A actual, A other, Map<String, Comparator<?>> comparatorByPropertyOrField, Map<Class<?>, Comparator<?>> comparatorByType, String ... fields) {
        this.assertNotNull(info, actual);
        ByFieldsComparison byFieldsComparison = this.isEqualToComparingOnlyGivenFields(actual, other, comparatorByPropertyOrField, comparatorByType, fields);
        if (byFieldsComparison.isFieldsNamesNotEmpty()) {
            throw this.failures.failure(info, ShouldBeEqualByComparingOnlyGivenFields.shouldBeEqualComparingOnlyGivenFields(actual, byFieldsComparison.fieldsNames, byFieldsComparison.rejectedValues, byFieldsComparison.expectedValues, Lists.newArrayList(fields)));
        }
    }

    private <A> ByFieldsComparison isEqualToComparingOnlyGivenFields(A actual, A other, Map<String, Comparator<?>> comparatorByPropertyOrField, Map<Class<?>, Comparator<?>> comparatorByType, String[] fields) {
        LinkedList<String> rejectedFieldsNames = new LinkedList<String>();
        LinkedList<Object> expectedValues = new LinkedList<Object>();
        LinkedList<Object> rejectedValues = new LinkedList<Object>();
        for (String fieldName : fields) {
            Object otherFieldValue;
            Object actualFieldValue = this.getPropertyOrFieldValue(actual, fieldName);
            if (Objects.propertyOrFieldValuesAreEqual(actualFieldValue, otherFieldValue = this.getPropertyOrFieldValue(other, fieldName), fieldName, comparatorByPropertyOrField, comparatorByType)) continue;
            rejectedFieldsNames.add(fieldName);
            expectedValues.add(otherFieldValue);
            rejectedValues.add(actualFieldValue);
        }
        return new ByFieldsComparison(rejectedFieldsNames, expectedValues, rejectedValues);
    }

    public <A> void assertIsEqualToIgnoringGivenFields(AssertionInfo info, A actual, A other, Map<String, Comparator<?>> comparatorByPropertyOrField, Map<Class<?>, Comparator<?>> comparatorByType, String ... fields) {
        this.assertNotNull(info, actual);
        ByFieldsComparison byFieldsComparison = this.isEqualToIgnoringGivenFields(actual, other, comparatorByPropertyOrField, comparatorByType, fields);
        if (byFieldsComparison.isFieldsNamesNotEmpty()) {
            throw this.failures.failure(info, ShouldBeEqualToIgnoringFields.shouldBeEqualToIgnoringGivenFields(actual, byFieldsComparison.fieldsNames, byFieldsComparison.rejectedValues, byFieldsComparison.expectedValues, Lists.newArrayList(fields)));
        }
    }

    private <A> ByFieldsComparison isEqualToIgnoringGivenFields(A actual, A other, Map<String, Comparator<?>> comparatorByPropertyOrField, Map<Class<?>, Comparator<?>> comparatorByType, String[] givenIgnoredFields) {
        Set<Field> declaredFieldsIncludingInherited = Objects.getDeclaredFieldsIncludingInherited(actual.getClass());
        LinkedList<String> fieldsNames = new LinkedList<String>();
        LinkedList<Object> expectedValues = new LinkedList<Object>();
        LinkedList<Object> rejectedValues = new LinkedList<Object>();
        LinkedHashSet<String> ignoredFields = Sets.newLinkedHashSet(givenIgnoredFields);
        for (Field field : declaredFieldsIncludingInherited) {
            Object otherFieldValue;
            Object actualFieldValue;
            String fieldName = field.getName();
            if (ignoredFields.contains(fieldName) || !this.canReadFieldValue(field, actual) || Objects.propertyOrFieldValuesAreEqual(actualFieldValue = this.getPropertyOrFieldValue(actual, fieldName), otherFieldValue = this.getPropertyOrFieldValue(other, fieldName), fieldName, comparatorByPropertyOrField, comparatorByType)) continue;
            fieldsNames.add(fieldName);
            rejectedValues.add(actualFieldValue);
            expectedValues.add(otherFieldValue);
        }
        return new ByFieldsComparison(fieldsNames, expectedValues, rejectedValues);
    }

    static boolean propertyOrFieldValuesAreEqual(Object actualFieldValue, Object otherFieldValue, String fieldName, Map<String, Comparator<?>> comparatorByPropertyOrField, Map<Class<?>, Comparator<?>> comparatorByType) {
        if (actualFieldValue != null && otherFieldValue != null && actualFieldValue.getClass() == otherFieldValue.getClass()) {
            Comparator<?> fieldComparator;
            Comparator<?> comparator = fieldComparator = comparatorByPropertyOrField.containsKey(fieldName) ? comparatorByPropertyOrField.get(fieldName) : comparatorByType.get(actualFieldValue.getClass());
            if (fieldComparator != null) {
                return fieldComparator.compare(actualFieldValue, otherFieldValue) == 0;
            }
        }
        return org.assertj.core.util.Objects.areEqual(actualFieldValue, otherFieldValue);
    }

    private <A> boolean canReadFieldValue(Field field, A actual) {
        return this.fieldSupport.isAllowedToRead(field) || this.propertySupport.publicGetterExistsFor(field.getName(), actual);
    }

    public <A> void assertIsEqualToComparingFieldByFieldRecursively(AssertionInfo info, A actual, A other, Map<String, Comparator<?>> comparatorByPropertyOrField, Map<Class<?>, Comparator<?>> comparatorByType) {
        this.assertNotNull(info, actual);
        List<DeepDifference.Difference> differences = DeepDifference.determineDifferences(actual, other, comparatorByPropertyOrField, comparatorByType);
        if (!differences.isEmpty()) {
            throw this.failures.failure(info, ShouldBeEqualByComparingFieldByFieldRecursively.shouldBeEqualByComparingFieldByFieldRecursive(actual, other, differences));
        }
    }

    private <A> Object getPropertyOrFieldValue(A a, String fieldName) {
        return PropertyOrFieldSupport.COMPARISON.getValueOf(fieldName, a);
    }

    public static Set<Field> getDeclaredFieldsIncludingInherited(Class<?> clazz) {
        Preconditions.checkNotNull(clazz, "expecting Class parameter not to be null");
        Set<Field> declaredFields = Objects.getDeclaredFieldsIgnoringSynthetic(clazz);
        for (Class<?> superclazz = clazz.getSuperclass(); superclazz != null && !superclazz.getName().startsWith("java.lang"); superclazz = superclazz.getSuperclass()) {
            declaredFields.addAll(Objects.getDeclaredFieldsIgnoringSynthetic(superclazz));
        }
        return declaredFields;
    }

    private static Set<Field> getDeclaredFieldsIgnoringSynthetic(Class<?> clazz) {
        LinkedHashSet<Field> fields = Sets.newLinkedHashSet(clazz.getDeclaredFields());
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            if (!((Field)iterator.next()).isSynthetic()) continue;
            iterator.remove();
        }
        return fields;
    }

    public boolean areEqualToIgnoringGivenFields(Object actual, Object other, Map<String, Comparator<?>> comparatorByPropertyOrField, Map<Class<?>, Comparator<?>> comparatorByType, String ... fields) {
        return this.isEqualToIgnoringGivenFields(actual, other, comparatorByPropertyOrField, comparatorByType, fields).isFieldsNamesEmpty();
    }

    public boolean areEqualToComparingOnlyGivenFields(Object actual, Object other, Map<String, Comparator<?>> comparatorByPropertyOrField, Map<Class<?>, Comparator<?>> comparatorByType, String ... fields) {
        return this.isEqualToComparingOnlyGivenFields(actual, other, comparatorByPropertyOrField, comparatorByType, fields).isFieldsNamesEmpty();
    }

    public <A> void assertHasFieldOrProperty(AssertionInfo info, A actual, String name) {
        this.assertNotNull(info, actual);
        try {
            this.extractPropertyOrField(actual, name);
        }
        catch (IntrospectionError error) {
            throw this.failures.failure(info, ShouldHavePropertyOrField.shouldHavePropertyOrField(actual, name));
        }
    }

    public <A> void assertHasFieldOrPropertyWithValue(AssertionInfo info, A actual, String name, Object expectedValue) {
        this.assertHasFieldOrProperty(info, actual, name);
        Object value = this.extractPropertyOrField(actual, name);
        if (!org.assertj.core.util.Objects.areEqual(value, expectedValue)) {
            throw this.failures.failure(info, ShouldHavePropertyOrFieldWithValue.shouldHavePropertyOrFieldWithValue(actual, name, expectedValue, value));
        }
    }

    private <A> Object extractPropertyOrField(A actual, String name) {
        return PropertyOrFieldSupport.EXTRACTION.getValueOf(name, actual);
    }

    public static class ByFieldsComparison {
        private final List<String> fieldsNames;
        private final List<Object> expectedValues;
        private final List<Object> rejectedValues;

        public ByFieldsComparison(List<String> fieldsNames, List<Object> expectedValues, List<Object> rejectedValues) {
            this.fieldsNames = fieldsNames;
            this.expectedValues = expectedValues;
            this.rejectedValues = rejectedValues;
        }

        public ByFieldsComparison() {
            this(new ArrayList<String>(), new ArrayList<Object>(), new ArrayList<Object>());
        }

        public boolean isFieldsNamesEmpty() {
            return this.fieldsNames.isEmpty();
        }

        public boolean isFieldsNamesNotEmpty() {
            return !this.isFieldsNamesEmpty();
        }
    }
}

