/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import java.util.Iterator;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.IterableUtil;

public class IterableElementComparisonStrategy<T>
extends StandardComparisonStrategy {
    private Comparator<? super T> elementComparator;

    public IterableElementComparisonStrategy(Comparator<? super T> elementComparator) {
        this.elementComparator = elementComparator;
    }

    @Override
    public boolean areEqual(Object actual, Object other) {
        if (actual == null && other == null) {
            return true;
        }
        if (actual == null || other == null) {
            return false;
        }
        return actual instanceof Iterable && other instanceof Iterable && this.compareElementsOf((Iterable)actual, (Iterable)other);
    }

    private boolean compareElementsOf(Iterable<T> actual, Iterable<T> other) {
        if (IterableUtil.sizeOf(actual) != IterableUtil.sizeOf(other)) {
            return false;
        }
        Iterator<T> iterator = other.iterator();
        for (T actualElement : actual) {
            T otherElement;
            if (this.elementComparator.compare(actualElement, otherElement = iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "IterableElementComparisonStrategy using " + StandardRepresentation.STANDARD_REPRESENTATION.toStringOf(this.elementComparator);
    }

    @Override
    public String asText() {
        return "when comparing elements using " + StandardRepresentation.STANDARD_REPRESENTATION.toStringOf(this.elementComparator);
    }

    @Override
    public boolean isStandard() {
        return false;
    }
}

