/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.assertj.core.api.AfterAssertionErrorCollected;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.FieldValue;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.StubValue;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.SuperCall;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.SuperMethod;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.This;

public class ErrorCollector {
    public static final String FIELD_NAME = "errorCollector";
    private static final String INTERCEPT_METHOD_NAME = "intercept";
    private static final String CLASS_NAME = ErrorCollector.class.getName();
    private final List<AssertionError> errors = Collections.synchronizedList(new ArrayList());
    private final LastResult lastResult = new LastResult();
    private AfterAssertionErrorCollected afterAssertionErrorCollected;

    void setAfterAssertionErrorCollected(AfterAssertionErrorCollected afterAssertionErrorCollected) {
        this.afterAssertionErrorCollected = afterAssertionErrorCollected;
    }

    @RuntimeType
    public static Object intercept(@FieldValue(value="errorCollector") ErrorCollector errorCollector, @This Object assertion, @SuperCall Callable<?> proxy, @SuperMethod(nullIfImpossible=true) Method method, @StubValue Object stub) throws Exception {
        try {
            Object result = proxy.call();
            errorCollector.lastResult.setSuccess(true);
            return result;
        }
        catch (AssertionError assertionError) {
            if (errorCollector.isNestedErrorCollectorProxyCall()) {
                throw assertionError;
            }
            errorCollector.addError(assertionError);
            if (method != null && !method.getReturnType().isInstance(assertion)) {
                return stub;
            }
            return assertion;
        }
    }

    void addError(AssertionError error) {
        this.errors.add(error);
        this.lastResult.setSuccess(false);
        if (this.afterAssertionErrorCollected != null) {
            this.afterAssertionErrorCollected.onAssertionErrorCollected(error);
        }
    }

    public List<AssertionError> errors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean wasSuccess() {
        return this.lastResult.wasSuccess();
    }

    private boolean isNestedErrorCollectorProxyCall() {
        return ErrorCollector.countErrorCollectorProxyCalls() > 1L;
    }

    private static long countErrorCollectorProxyCalls() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).filter(stackTraceElement -> CLASS_NAME.equals(stackTraceElement.getClassName()) && stackTraceElement.getMethodName().startsWith(INTERCEPT_METHOD_NAME)).count();
    }

    private static class LastResult {
        private volatile boolean wasSuccess = true;
        private volatile boolean errorFound = false;

        private LastResult() {
        }

        private boolean wasSuccess() {
            return this.wasSuccess;
        }

        private void setSuccess(boolean success) {
            this.errorFound |= !success;
            this.wasSuccess = success;
            if (this.resolvingOutermostErrorCollectorProxyNestedCall()) {
                this.errorFound = false;
            }
        }

        private boolean resolvingOutermostErrorCollectorProxyNestedCall() {
            return ErrorCollector.countErrorCollectorProxyCalls() == 1L;
        }

        public String toString() {
            return String.format("LastResult [wasSuccess=%s, errorFound=%s]", this.wasSuccess, this.errorFound);
        }
    }
}

