/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.DBStatus;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Database;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IndexException;

final class Chunk {
    private final byte[] fBuffer = new byte[4096];
    final Database fDatabase;
    final int fSequenceNumber;
    boolean fCacheHitFlag;
    boolean fDirty;
    boolean fLocked;
    int fCacheIndex = -1;

    Chunk(Database db, int sequenceNumber) {
        this.fDatabase = db;
        this.fSequenceNumber = sequenceNumber;
    }

    void read() throws IndexException {
        try {
            ByteBuffer buf = ByteBuffer.wrap(this.fBuffer);
            this.fDatabase.read(buf, (long)this.fSequenceNumber * 4096L);
        }
        catch (IOException e) {
            throw new IndexException(new DBStatus(e));
        }
    }

    boolean flush() throws IndexException {
        boolean wasCanceled = false;
        try {
            ByteBuffer buf = ByteBuffer.wrap(this.fBuffer);
            wasCanceled = this.fDatabase.write(buf, (long)this.fSequenceNumber * 4096L);
        }
        catch (IOException e) {
            throw new IndexException(new DBStatus(e));
        }
        this.fDirty = false;
        return wasCanceled;
    }

    private static int recPtrToIndex(long offset) {
        return (int)(offset & 0xFFFL);
    }

    public void putByte(long offset, byte value) {
        assert (this.fLocked);
        this.fDirty = true;
        this.fBuffer[Chunk.recPtrToIndex((long)offset)] = value;
    }

    public byte getByte(long offset) {
        return this.fBuffer[Chunk.recPtrToIndex(offset)];
    }

    public byte[] getBytes(long offset, int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(this.fBuffer, Chunk.recPtrToIndex(offset), bytes, 0, length);
        return bytes;
    }

    public void putBytes(long offset, byte[] bytes) {
        assert (this.fLocked);
        this.fDirty = true;
        System.arraycopy(bytes, 0, this.fBuffer, Chunk.recPtrToIndex(offset), bytes.length);
    }

    public void putInt(long offset, int value) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        Chunk.putInt(value, this.fBuffer, idx);
    }

    static final void putInt(int value, byte[] buffer, int idx) {
        buffer[idx] = (byte)(value >> 24);
        buffer[++idx] = (byte)(value >> 16);
        buffer[++idx] = (byte)(value >> 8);
        buffer[++idx] = (byte)value;
    }

    public int getInt(long offset) {
        return Chunk.getInt(this.fBuffer, Chunk.recPtrToIndex(offset));
    }

    static final int getInt(byte[] buffer, int idx) {
        return (buffer[idx] & 0xFF) << 24 | (buffer[++idx] & 0xFF) << 16 | (buffer[++idx] & 0xFF) << 8 | (buffer[++idx] & 0xFF) << 0;
    }

    static int compressFreeRecPtr(long value) {
        assert ((value & 7L) == 0L);
        int dense = (int)(value >> 3);
        return dense;
    }

    static long expandToFreeRecPtr(int value) {
        long address = (long)value & 0xFFFFFFFFL;
        return address << 3;
    }

    public void putRecPtr(long offset, long value) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        Database.putRecPtr(value, this.fBuffer, idx);
    }

    public void putFreeRecPtr(long offset, long value) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        Chunk.putInt(Chunk.compressFreeRecPtr(value), this.fBuffer, idx);
    }

    public long getRecPtr(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return Database.getRecPtr(this.fBuffer, idx);
    }

    public long getFreeRecPtr(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        int value = Chunk.getInt(this.fBuffer, idx);
        return Chunk.expandToFreeRecPtr(value);
    }

    public void put3ByteUnsignedInt(long offset, int value) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        this.fBuffer[idx] = (byte)(value >> 16);
        this.fBuffer[++idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
    }

    public int get3ByteUnsignedInt(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return (this.fBuffer[idx] & 0xFF) << 16 | (this.fBuffer[++idx] & 0xFF) << 8 | (this.fBuffer[++idx] & 0xFF) << 0;
    }

    public void putShort(long offset, short value) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        this.fBuffer[idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
    }

    public short getShort(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return (short)(this.fBuffer[idx] << 8 | this.fBuffer[++idx] & 0xFF);
    }

    public long getLong(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return ((long)this.fBuffer[idx] & 0xFFL) << 56 | ((long)this.fBuffer[++idx] & 0xFFL) << 48 | ((long)this.fBuffer[++idx] & 0xFFL) << 40 | ((long)this.fBuffer[++idx] & 0xFFL) << 32 | ((long)this.fBuffer[++idx] & 0xFFL) << 24 | ((long)this.fBuffer[++idx] & 0xFFL) << 16 | ((long)this.fBuffer[++idx] & 0xFFL) << 8 | ((long)this.fBuffer[++idx] & 0xFFL) << 0;
    }

    public double getDouble(long offset) {
        return Double.longBitsToDouble(this.getLong(offset));
    }

    public float getFloat(long offset) {
        return Float.intBitsToFloat(this.getInt(offset));
    }

    public void putLong(long offset, long value) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        this.fBuffer[idx] = (byte)(value >> 56);
        this.fBuffer[++idx] = (byte)(value >> 48);
        this.fBuffer[++idx] = (byte)(value >> 40);
        this.fBuffer[++idx] = (byte)(value >> 32);
        this.fBuffer[++idx] = (byte)(value >> 24);
        this.fBuffer[++idx] = (byte)(value >> 16);
        this.fBuffer[++idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
    }

    public void putChar(long offset, char value) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        this.fBuffer[idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
    }

    public void putChars(long offset, char[] chars, int start, int len) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset) - 1;
        int end = start + len;
        int i = start;
        while (i < end) {
            char value = chars[i];
            this.fBuffer[++idx] = (byte)(value >> 8);
            this.fBuffer[++idx] = (byte)value;
            ++i;
        }
    }

    public void putCharsAsBytes(long offset, char[] chars, int start, int len) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset) - 1;
        int end = start + len;
        int i = start;
        while (i < end) {
            char value = chars[i];
            this.fBuffer[++idx] = (byte)value;
            ++i;
        }
    }

    public void putDouble(long offset, double value) {
        this.putLong(offset, Double.doubleToLongBits(value));
    }

    public void putFloat(long offset, float value) {
        this.putInt(offset, Float.floatToIntBits(value));
    }

    public char getChar(long offset) {
        int idx = Chunk.recPtrToIndex(offset);
        return (char)(this.fBuffer[idx] << 8 | this.fBuffer[++idx] & 0xFF);
    }

    public void getChars(long offset, char[] result, int start, int len) {
        ByteBuffer buf = ByteBuffer.wrap(this.fBuffer);
        buf.position(Chunk.recPtrToIndex(offset));
        buf.asCharBuffer().get(result, start, len);
    }

    public void getCharsFromBytes(long offset, char[] result, int start, int len) {
        int pos = Chunk.recPtrToIndex(offset);
        int i = 0;
        while (i < len) {
            result[start + i] = (char)(this.fBuffer[pos + i] & 0xFF);
            ++i;
        }
    }

    void clear(long offset, int length) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        int end = idx + length;
        while (idx < end) {
            this.fBuffer[idx] = 0;
            ++idx;
        }
    }

    void put(long offset, byte[] data, int len) {
        this.put(offset, data, 0, len);
    }

    void put(long offset, byte[] data, int dataPos, int len) {
        assert (this.fLocked);
        this.fDirty = true;
        int idx = Chunk.recPtrToIndex(offset);
        System.arraycopy(data, dataPos, this.fBuffer, idx, len);
    }

    public void get(long offset, byte[] data) {
        this.get(offset, data, 0, data.length);
    }

    public void get(long offset, byte[] data, int dataPos, int len) {
        int idx = Chunk.recPtrToIndex(offset);
        System.arraycopy(this.fBuffer, idx, data, dataPos, len);
    }
}

