/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.util.ArrayList;
import java.util.List;
import org.apache.xmlgraphics.xmp.XMPArrayType;
import org.apache.xmlgraphics.xmp.XMPComplexValue;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMPArray
extends XMPComplexValue {
    private XMPArrayType type;
    private List values = new ArrayList();
    private List xmllang = new ArrayList();

    public XMPArray(XMPArrayType type) {
        this.type = type;
    }

    public XMPArrayType getType() {
        return this.type;
    }

    public Object getValue(int idx) {
        return this.values.get(idx);
    }

    public Object getSimpleValue() {
        if (this.values.size() == 1) {
            return this.getValue(0);
        }
        return null;
    }

    public String getLangValue(String lang) {
        String v = null;
        int c = this.values.size();
        for (int i = 0; i < c; ++i) {
            String l = (String)this.xmllang.get(i);
            if ((l != null || lang != null) && (l == null || !l.equals(lang))) continue;
            v = this.values.get(i).toString();
            break;
        }
        if (lang == null && v == null && (v = this.getLangValue("x-default")) == null && this.values.size() > 0) {
            v = this.getValue(0).toString();
        }
        return v;
    }

    public void removeLangValue(String lang) {
        if (lang == null && "".equals(lang)) {
            return;
        }
        int c = this.values.size();
        for (int i = 0; i < c; ++i) {
            String l = (String)this.xmllang.get(i);
            if (!lang.equals(l)) continue;
            this.values.remove(i);
            this.xmllang.remove(i);
            return;
        }
    }

    public void add(Object value) {
        this.values.add(value);
        this.xmllang.add(null);
    }

    public void add(String value, String lang) {
        this.values.add(value);
        this.xmllang.add(lang);
    }

    public int getSize() {
        return this.values.size();
    }

    public Object[] toObjectArray() {
        Object[] res = new Object[this.getSize()];
        int c = res.length;
        for (int i = 0; i < c; ++i) {
            res[i] = this.getValue(i);
        }
        return res;
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        handler.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", this.type.getName(), "rdf:" + this.type.getName(), atts);
        int c = this.values.size();
        for (int i = 0; i < c; ++i) {
            String value = (String)this.values.get(i);
            String lang = (String)this.xmllang.get(i);
            atts.clear();
            if (lang != null) {
                atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", lang);
            }
            handler.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "li", "rdf:li", atts);
            char[] chars = value.toCharArray();
            handler.characters(chars, 0, chars.length);
            handler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "li", "rdf:li");
        }
        handler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", this.type.getName(), "rdf:" + this.type.getName());
    }

    public String toString() {
        return "XMP array: " + this.type + ", " + this.getSize();
    }
}

