/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.mqtt;

import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.receiver.Receiver;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m2Q!\u0001\u0002\u0001\t1\u0011A\"T)U)J+7-Z5wKJT!a\u0001\u0003\u0002\t5\fH\u000f\u001e\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\"\u0001A\u0007\u0011\u00079\t2#D\u0001\u0010\u0015\t\u0001B!\u0001\u0005sK\u000e,\u0017N^3s\u0013\t\u0011rB\u0001\u0005SK\u000e,\u0017N^3s!\t!\"D\u0004\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIb#\u0001\u0004Qe\u0016$WMZ\u0005\u00037q\u0011aa\u0015;sS:<'BA\r\u0017\u0011!q\u0002A!A!\u0002\u0013\u0019\u0012!\u00032s_.,'/\u0016:m\u0007\u0001A\u0001\"\t\u0001\u0003\u0002\u0003\u0006IaE\u0001\u0006i>\u0004\u0018n\u0019\u0005\nG\u0001\u0011\t\u0011)A\u0005I)\nAb\u001d;pe\u0006<W\rT3wK2\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\u0004\u0002\u000fM$xN]1hK&\u0011\u0011F\n\u0002\r'R|'/Y4f\u0019\u00164X\r\\\u0005\u0003GEAQ\u0001\f\u0001\u0005\u00025\na\u0001P5oSRtD\u0003\u0002\u00181cI\u0002\"a\f\u0001\u000e\u0003\tAQAH\u0016A\u0002MAQ!I\u0016A\u0002MAQaI\u0016A\u0002\u0011BQ\u0001\u000e\u0001\u0005\u0002U\naa\u001c8Ti>\u0004H#\u0001\u001c\u0011\u0005U9\u0014B\u0001\u001d\u0017\u0005\u0011)f.\u001b;\t\u000bi\u0002A\u0011A\u001b\u0002\u000f=t7\u000b^1si\u0002")
public class MQTTReceiver
extends Receiver<String> {
    private final String brokerUrl;
    private final String topic;

    public void onStop() {
    }

    public void onStart() {
        MemoryPersistence persistence = new MemoryPersistence();
        MqttClient client = new MqttClient(this.brokerUrl, MqttClient.generateClientId(), (MqttClientPersistence)persistence);
        MqttCallback callback = new MqttCallback(this){
            private final /* synthetic */ MQTTReceiver $outer;

            public void messageArrived(String topic, MqttMessage message) {
                this.$outer.store(new String(message.getPayload(), "utf-8"));
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }

            public void connectionLost(Throwable cause) {
                this.$outer.restart("Connection lost ", cause);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        client.setCallback(callback);
        client.connect();
        client.subscribe(this.topic);
    }

    public MQTTReceiver(String brokerUrl, String topic, StorageLevel storageLevel) {
        this.brokerUrl = brokerUrl;
        this.topic = topic;
        super(storageLevel);
    }
}

