/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.package$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.LongOffset$;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.MemoryStreamDataReaderFactory;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.sources.v2.reader.DataReaderFactory;
import org.apache.spark.sql.sources.v2.reader.SupportsScanUnsafeRow;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r-v!B\u0001\u0003\u0011\u0003y\u0011\u0001D'f[>\u0014\u0018p\u0015;sK\u0006l'BA\u0002\u0005\u0003%\u0019HO]3b[&twM\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA\ta\u0005\u0002\r\u001b\u0016lwN]=TiJ,\u0017-\\\n\u0004#QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006=E!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=Aq!I\tC\u0002\u0013E!%\u0001\bdkJ\u0014XM\u001c;CY>\u001c7.\u00133\u0016\u0003\r\u0002\"\u0001J\u0017\u000e\u0003\u0015R!AJ\u0014\u0002\r\u0005$x.\\5d\u0015\tA\u0013&\u0001\u0006d_:\u001cWO\u001d:f]RT!AK\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0002Y\u0005!!.\u0019<b\u0013\tqSEA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\u0007aE\u0001\u000b\u0011B\u0012\u0002\u001f\r,(O]3oi\ncwnY6JI\u0002BqAM\tC\u0002\u0013E!%\u0001\bnK6|'/_*ue\u0016\fW.\u00133\t\rQ\n\u0002\u0015!\u0003$\u0003=iW-\\8ssN#(/Z1n\u0013\u0012\u0004\u0003\"\u0002\u001c\u0012\t\u00039\u0014!B1qa2LXc\u0001\u001d\u0004hQ)\u0011h!\u001b\u0004pA!\u0001COB3\r\u0011\u0011\"\u0001Q\u001e\u0016\u0005q\u001a8c\u0002\u001e>\u0007:\u0013\u0006L\u0007\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001.\nA\u0001\\1oO&\u0011!i\u0010\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0011cU\"A#\u000b\u0005\r1%BA$I\u0003\u0019\u0011X-\u00193fe*\u0011\u0011JS\u0001\u0003mJR!a\u0013\u0004\u0002\u000fM|WO]2fg&\u0011Q*\u0012\u0002\u0011\u001b&\u001c'o\u001c\"bi\u000eD'+Z1eKJ\u0004\"a\u0014)\u000e\u0003\u0019K!!\u0015$\u0003+M+\b\u000f]8siN\u001c6-\u00198V]N\fg-\u001a*poB\u00111KV\u0007\u0002)*\u0011Q\u000bC\u0001\tS:$XM\u001d8bY&\u0011q\u000b\u0016\u0002\b\u0019><w-\u001b8h!\t)\u0012,\u0003\u0002[-\t9\u0001K]8ek\u000e$\b\u0002\u0003/;\u0005+\u0007I\u0011A/\u0002\u0005%$W#\u00010\u0011\u0005Uy\u0016B\u00011\u0017\u0005\rIe\u000e\u001e\u0005\tEj\u0012\t\u0012)A\u0005=\u0006\u0019\u0011\u000e\u001a\u0011\t\u0011\u0011T$Q3A\u0005\u0002\u0015\f!b]9m\u0007>tG/\u001a=u+\u00051\u0007CA4i\u001b\u00051\u0011BA5\u0007\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010\u001e\u0005\tWj\u0012\t\u0012)A\u0005M\u0006Y1/\u001d7D_:$X\r\u001f;!\u0011!i'HaA!\u0002\u0017q\u0017AC3wS\u0012,gnY3%eA\u0019qm\\9\n\u0005A4!aB#oG>$WM\u001d\t\u0003eNd\u0001\u0001B\u0003uu\t\u0007QOA\u0001B#\t1\u0018\u0010\u0005\u0002\u0016o&\u0011\u0001P\u0006\u0002\b\u001d>$\b.\u001b8h!\t)\"0\u0003\u0002|-\t\u0019\u0011I\\=\t\u000byQD\u0011A?\u0015\u000by\f\u0019!!\u0002\u0015\u0007}\f\t\u0001E\u0002\u0011uEDQ!\u001c?A\u00049DQ\u0001\u0018?A\u0002yCQ\u0001\u001a?A\u0002\u0019D\u0011\"!\u0003;\u0005\u0004%\t\"a\u0003\u0002\u000f\u0015t7m\u001c3feV\u0011\u0011Q\u0002\t\u0006\u0003\u001f\tI\"]\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005AQM\\2pI\u0016\u00148OC\u0002\u0002\u0018\u0019\t\u0001bY1uC2L8\u000f^\u0005\u0005\u00037\t\tBA\tFqB\u0014Xm]:j_:,enY8eKJD\u0001\"a\b;A\u0003%\u0011QB\u0001\tK:\u001cw\u000eZ3sA!I\u00111\u0005\u001eC\u0002\u0013%\u0011QE\u0001\u000bCR$(/\u001b2vi\u0016\u001cXCAA\u0014!\u0019\tI#!\u000f\u0002@9!\u00111FA\u001b\u001d\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019\u001d\u00051AH]8pizJ\u0011aF\u0005\u0004\u0003o1\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003w\tiDA\u0002TKFT1!a\u000e\u0017!\u0011\t\t%a\u0012\u000e\u0005\u0005\r#\u0002BA#\u0003+\t1\"\u001a=qe\u0016\u001c8/[8og&!\u0011\u0011JA\"\u0005I\tE\u000f\u001e:jEV$XMU3gKJ,gnY3\t\u0011\u00055#\b)A\u0005\u0003O\t1\"\u0019;ue&\u0014W\u000f^3tA!I\u0011\u0011\u000b\u001eC\u0002\u0013E\u00111K\u0001\fY><\u0017nY1m!2\fg.\u0006\u0002\u0002VA\u0019\u0001#a\u0016\n\u0007\u0005e#A\u0001\u000eTiJ,\u0017-\\5oO\u0016CXmY;uS>t'+\u001a7bi&|g\u000e\u0003\u0005\u0002^i\u0002\u000b\u0011BA+\u00031awnZ5dC2\u0004F.\u00198!\u0011%\t\tG\u000fb\u0001\n#\t\u0019'\u0001\u0004pkR\u0004X\u000f^\u000b\u0003\u0003K\u0002b!!\u000b\u0002:\u0005\u001d\u0004\u0003BA!\u0003SJA!a\u001b\u0002D\tI\u0011\t\u001e;sS\n,H/\u001a\u0005\t\u0003_R\u0004\u0015!\u0003\u0002f\u00059q.\u001e;qkR\u0004\u0003\"CA:u\t\u0007I\u0011CA;\u0003\u001d\u0011\u0017\r^2iKN,\"!a\u001e\u0011\r\u0005e\u00141QAD\u001b\t\tYH\u0003\u0003\u0002~\u0005}\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u00033\u0012AC2pY2,7\r^5p]&!\u0011QQA>\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u0006+\u0005%\u0015QR\u0005\u0004\u0003\u00173\"!B!se\u0006L\b\u0003BA!\u0003\u001fKA!!%\u0002D\tIQK\\:bM\u0016\u0014vn\u001e\u0005\t\u0003+S\u0004\u0015!\u0003\u0002x\u0005A!-\u0019;dQ\u0016\u001c\b\u0005\u000b\u0005\u0002\u0014\u0006e\u00151VAW!\u0011\tY*a*\u000e\u0005\u0005u%b\u0001\u0015\u0002 *!\u0011\u0011UAR\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0003K\u000bQA[1wCbLA!!+\u0002\u001e\nIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003_\u000bA\u0001\u001e5jg\"I\u00111\u0017\u001eA\u0002\u0013E\u0011QW\u0001\u000eGV\u0014(/\u001a8u\u001f\u001a47/\u001a;\u0016\u0005\u0005]\u0006c\u0001\t\u0002:&\u0019\u00111\u0018\u0002\u0003\u00151{gnZ(gMN,G\u000fC\u0005\u0002@j\u0002\r\u0011\"\u0005\u0002B\u0006\t2-\u001e:sK:$xJ\u001a4tKR|F%Z9\u0015\t\u0005\r\u0017\u0011\u001a\t\u0004+\u0005\u0015\u0017bAAd-\t!QK\\5u\u0011)\tY-!0\u0002\u0002\u0003\u0007\u0011qW\u0001\u0004q\u0012\n\u0004\u0002CAhu\u0001\u0006K!a.\u0002\u001d\r,(O]3oi>3gm]3uA!B\u0011QZAM\u0003W\u000bi\u000bC\u0005\u0002Vj\u0002\r\u0011\"\u0003\u00026\u0006Y1\u000f^1si>3gm]3u\u0011%\tIN\u000fa\u0001\n\u0013\tY.A\bti\u0006\u0014Ho\u00144gg\u0016$x\fJ3r)\u0011\t\u0019-!8\t\u0015\u0005-\u0017q[A\u0001\u0002\u0004\t9\f\u0003\u0005\u0002bj\u0002\u000b\u0015BA\\\u00031\u0019H/\u0019:u\u001f\u001a47/\u001a;!Q!\ty.!'\u0002,\u00065\u0006\"CAtu\u0001\u0007I\u0011BA[\u0003%)g\u000eZ(gMN,G\u000fC\u0005\u0002lj\u0002\r\u0011\"\u0003\u0002n\u0006iQM\u001c3PM\u001a\u001cX\r^0%KF$B!a1\u0002p\"Q\u00111ZAu\u0003\u0003\u0005\r!a.\t\u0011\u0005M(\b)Q\u0005\u0003o\u000b!\"\u001a8e\u001f\u001a47/\u001a;!Q!\t\t0!'\u0002,\u00065\u0006\"CA}u\u0001\u0007I\u0011CA[\u0003Ma\u0017m\u001d;PM\u001a\u001cX\r^\"p[6LG\u000f^3e\u0011%\tiP\u000fa\u0001\n#\ty0A\fmCN$xJ\u001a4tKR\u001cu.\\7jiR,Gm\u0018\u0013fcR!\u00111\u0019B\u0001\u0011)\tY-a?\u0002\u0002\u0003\u0007\u0011q\u0017\u0005\t\u0005\u000bQ\u0004\u0015)\u0003\u00028\u0006!B.Y:u\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e;fI\u0002B\u0003Ba\u0001\u0002\u001a\u0006-\u0016Q\u0016\u0005\b\u0005\u0017QD\u0011\u0001B\u0007\u0003\u0011!x\u000eR*\u0015\u0005\t=\u0001\u0003B4\u0003\u0012EL1Aa\u0005\u0007\u0005\u001d!\u0015\r^1tKRDqAa\u0006;\t\u0003\u0011I\"\u0001\u0003u_\u00123EC\u0001B\u000e!\u0011\u0011iB!\r\u000f\t\t}!q\u0006\b\u0005\u0005C\u0011iC\u0004\u0003\u0003$\t-b\u0002\u0002B\u0013\u0005SqA!!\f\u0003(%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I1!a\u000e\u0007\u0013\u0011\u0011\u0019D!\u000e\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAA\u001c\r!9!\u0011\b\u001e\u0005\u0002\tm\u0012aB1eI\u0012\u000bG/\u0019\u000b\u0005\u0005{\u0011\u0019\u0005E\u0002\u0011\u0005\u007fI1A!\u0011\u0003\u0005\u0019yeMZ:fi\"A!Q\tB\u001c\u0001\u0004\u00119%\u0001\u0003eCR\f\u0007\u0003B\u000b\u0003JEL1Aa\u0013\u0017\u0005)a$/\u001a9fCR,GM\u0010\u0005\b\u0005sQD\u0011\u0001B()\u0011\u0011iD!\u0015\t\u0011\t\u0015#Q\na\u0001\u0005'\u0002R!!\u000b\u0003VELAAa\u0016\u0002>\tyAK]1wKJ\u001c\u0018M\u00197f\u001f:\u001cW\rC\u0004\u0003\\i\"\tE!\u0018\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\u0018\u0011\t\t\u0005$q\r\b\u0004+\t\r\u0014b\u0001B3-\u00051\u0001K]3eK\u001aLAA!\u001b\u0003l\t11\u000b\u001e:j]\u001eT1A!\u001a\u0017\u0011\u001d\u0011yG\u000fC!\u0005c\nab]3u\u001f\u001a47/\u001a;SC:<W\r\u0006\u0004\u0002D\nM$1\u0011\u0005\t\u0005k\u0012i\u00071\u0001\u0003x\u0005)1\u000f^1siB1!\u0011\u0010B>\u0005\u007fj\u0011!K\u0005\u0004\u0005{J#\u0001C(qi&|g.\u00197\u0011\u0007\u0011\u0013\t)C\u0002\u0003B\u0015C\u0001B!\"\u0003n\u0001\u0007!qO\u0001\u0004K:$\u0007b\u0002BEu\u0011\u0005#1R\u0001\u000be\u0016\fGmU2iK6\fGC\u0001BG!\u0011\u0011yI!&\u000e\u0005\tE%b\u0001BJ\r\u0005)A/\u001f9fg&!!q\u0013BI\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u00057SD\u0011\tBO\u0003E!Wm]3sS\u0006d\u0017N_3PM\u001a\u001cX\r\u001e\u000b\u0005\u0005\u007f\u0012y\n\u0003\u0005\u0003\"\ne\u0005\u0019\u0001B0\u0003\u0011Q7o\u001c8\t\u000f\t\u0015&\b\"\u0011\u0003(\u0006qq-\u001a;Ti\u0006\u0014Ho\u00144gg\u0016$HC\u0001B@\u0011\u001d\u0011YK\u000fC!\u0005O\u000bAbZ3u\u000b:$wJ\u001a4tKRDqAa,;\t\u0003\u0012\t,\u0001\u0010de\u0016\fG/Z+og\u00064WMU8x%\u0016\fG-\u001a:GC\u000e$xN]5fgR\u0011!1\u0017\t\u0007\u0005s\u0012)L!/\n\u0007\t]\u0016F\u0001\u0003MSN$\b#B(\u0003<\u00065\u0015b\u0001B_\r\n\tB)\u0019;b%\u0016\fG-\u001a:GC\u000e$xN]=\t\u000f\t\u0005'\b\"\u0003\u0003D\u0006\u0019r-\u001a8fe\u0006$X\rR3ck\u001e\u001cFO]5oORA!q\fBc\u0005\u0017\u0014y\r\u0003\u0005\u0003H\n}\u0006\u0019\u0001Be\u0003\u0011\u0011xn^:\u0011\r\u0005%\u0012\u0011HAG\u0011\u001d\u0011iMa0A\u0002y\u000bAb\u001d;beR|%\u000fZ5oC2DqA!5\u0003@\u0002\u0007a,\u0001\u0006f]\u0012|%\u000fZ5oC2DqA!6;\t\u0003\u00129.\u0001\u0004d_6l\u0017\u000e\u001e\u000b\u0005\u0003\u0007\u0014I\u000e\u0003\u0005\u0003\u0006\nM\u0007\u0019\u0001B@\u0011\u001d\u0011iN\u000fC!\u0005?\fAa\u001d;paR\u0011\u00111\u0019\u0005\b\u0005GTD\u0011\u0001Bp\u0003\u0015\u0011Xm]3u\u0011%\u00119OOA\u0001\n\u0003\u0011I/\u0001\u0003d_BLX\u0003\u0002Bv\u0005g$bA!<\u0003z\nmH\u0003\u0002Bx\u0005k\u0004B\u0001\u0005\u001e\u0003rB\u0019!Oa=\u0005\rQ\u0014)O1\u0001v\u0011\u001di'Q\u001da\u0002\u0005o\u0004BaZ8\u0003r\"AAL!:\u0011\u0002\u0003\u0007a\f\u0003\u0005e\u0005K\u0004\n\u00111\u0001g\u0011%\u0011yPOI\u0001\n\u0003\u0019\t!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\t\r\r1qC\u000b\u0003\u0007\u000bQ3AXB\u0004W\t\u0019I\u0001\u0005\u0003\u0004\f\rMQBAB\u0007\u0015\u0011\u0019ya!\u0005\u0002\u0013Ut7\r[3dW\u0016$'bAAQ-%!1QCB\u0007\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0007i\nu(\u0019A;\t\u0013\rm!(%A\u0005\u0002\ru\u0011AD2paf$C-\u001a4bk2$HEM\u000b\u0005\u0007?\u0019\u0019#\u0006\u0002\u0004\")\u001aama\u0002\u0005\rQ\u001cIB1\u0001v\u0011%\u00199COA\u0001\n\u0003\u001aI#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0007W\u00012APB\u0017\u0013\r\u0011Ig\u0010\u0005\t\u0007cQ\u0014\u0011!C\u0001;\u0006a\u0001O]8ek\u000e$\u0018I]5us\"I1Q\u0007\u001e\u0002\u0002\u0013\u00051qG\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rI8\u0011\b\u0005\n\u0003\u0017\u001c\u0019$!AA\u0002yC\u0011b!\u0010;\u0003\u0003%\tea\u0010\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0011\u0011\u000b\r\r3QI=\u000e\u0005\u0005}\u0014\u0002BB$\u0003\u007f\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0007\u0017R\u0014\u0011!C\u0001\u0007\u001b\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0007\u001f\u001a)\u0006E\u0002\u0016\u0007#J1aa\u0015\u0017\u0005\u001d\u0011un\u001c7fC:D\u0011\"a3\u0004J\u0005\u0005\t\u0019A=\t\u0013\re#(!A\u0005B\rm\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003yC\u0011ba\u0018;\u0003\u0003%\te!\u0019\u0002\r\u0015\fX/\u00197t)\u0011\u0019yea\u0019\t\u0013\u0005-7QLA\u0001\u0002\u0004I\bc\u0001:\u0004h\u0011)A/\u000eb\u0001k\"I11N\u001b\u0002\u0002\u0003\u000f1QN\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004\u0003B4p\u0007KBQ\u0001Z\u001bA\u0004\u0019D\u0001BN\t\u0002\u0002\u0013\u000551O\u000b\u0005\u0007k\u001ai\b\u0006\u0004\u0004x\r\r5Q\u0011\u000b\u0005\u0007s\u001ay\b\u0005\u0003\u0011u\rm\u0004c\u0001:\u0004~\u00111Ao!\u001dC\u0002UDq!\\B9\u0001\b\u0019\t\t\u0005\u0003h_\u000em\u0004B\u0002/\u0004r\u0001\u0007a\f\u0003\u0004e\u0007c\u0002\rA\u001a\u0005\n\u0007\u0013\u000b\u0012\u0011!CA\u0007\u0017\u000bq!\u001e8baBd\u00170\u0006\u0003\u0004\u000e\u000e\rF\u0003BBH\u00077\u0003R!FBI\u0007+K1aa%\u0017\u0005\u0019y\u0005\u000f^5p]B)Qca&_M&\u00191\u0011\u0014\f\u0003\rQ+\b\u000f\\33\u0011)\u0019ija\"\u0002\u0002\u0003\u00071qT\u0001\u0004q\u0012\u0002\u0004\u0003\u0002\t;\u0007C\u00032A]BR\t\u0019!8q\u0011b\u0001k\"I1qU\t\u0002\u0002\u0013%1\u0011V\u0001\fe\u0016\fGMU3t_24X\rF\u0001>\u0001")
public class MemoryStream<A>
implements MicroBatchReader,
SupportsScanUnsafeRow,
Logging,
Product,
Serializable {
    private final int id;
    private final SQLContext sqlContext;
    private final Encoder<A> evidence$2;
    private final ExpressionEncoder<A> encoder;
    private final Seq<AttributeReference> attributes;
    private final StreamingExecutionRelation logicalPlan;
    private final Seq<Attribute> output;
    @GuardedBy(value="this")
    private final ListBuffer<UnsafeRow[]> batches;
    @GuardedBy(value="this")
    private LongOffset currentOffset;
    @GuardedBy(value="this")
    private LongOffset startOffset;
    @GuardedBy(value="this")
    private LongOffset endOffset;
    @GuardedBy(value="this")
    private LongOffset lastOffsetCommitted;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <A> Option<Tuple2<Object, SQLContext>> unapply(MemoryStream<A> memoryStream) {
        return MemoryStream$.MODULE$.unapply(memoryStream);
    }

    public static <A> MemoryStream<A> apply(int n, SQLContext sQLContext, Encoder<A> encoder) {
        return MemoryStream$.MODULE$.apply(n, sQLContext, encoder);
    }

    public static <A> MemoryStream<A> apply(Encoder<A> encoder, SQLContext sQLContext) {
        return MemoryStream$.MODULE$.apply(encoder, sQLContext);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public int id() {
        return this.id;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public ExpressionEncoder<A> encoder() {
        return this.encoder;
    }

    private Seq<AttributeReference> attributes() {
        return this.attributes;
    }

    public StreamingExecutionRelation logicalPlan() {
        return this.logicalPlan;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    public ListBuffer<UnsafeRow[]> batches() {
        return this.batches;
    }

    public LongOffset currentOffset() {
        return this.currentOffset;
    }

    public void currentOffset_$eq(LongOffset x$1) {
        this.currentOffset = x$1;
    }

    private LongOffset startOffset() {
        return this.startOffset;
    }

    private void startOffset_$eq(LongOffset x$1) {
        this.startOffset = x$1;
    }

    private LongOffset endOffset() {
        return this.endOffset;
    }

    private void endOffset_$eq(LongOffset x$1) {
        this.endOffset = x$1;
    }

    public LongOffset lastOffsetCommitted() {
        return this.lastOffsetCommitted;
    }

    public void lastOffsetCommitted_$eq(LongOffset x$1) {
        this.lastOffsetCommitted = x$1;
    }

    public Dataset<A> toDS() {
        return Dataset$.MODULE$.apply(this.sqlContext().sparkSession(), (LogicalPlan)this.logicalPlan(), this.evidence$2);
    }

    public Dataset<Row> toDF() {
        return Dataset$.MODULE$.ofRows(this.sqlContext().sparkSession(), (LogicalPlan)this.logicalPlan());
    }

    public Offset addData(Seq<A> data) {
        return this.addData((TraversableOnce<A>)data.toTraversable());
    }

    public Offset addData(TraversableOnce<A> data) {
        Seq objects = data.toSeq();
        UnsafeRow[] rows = (UnsafeRow[])objects.iterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryStream $outer;

            public final UnsafeRow apply(A d) {
                return (UnsafeRow)this.$outer.encoder().toRow(d).copy();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).toArray(ClassTag$.MODULE$.apply(UnsafeRow.class));
        this.logDebug((Function0<String>)new Serializable(this, objects){
            public static final long serialVersionUID = 0L;
            private final Seq objects$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.objects$1}));
            }
            {
                this.objects$1 = objects$1;
            }
        });
        MemoryStream memoryStream = this;
        synchronized (memoryStream) {
            this.currentOffset_$eq(this.currentOffset().$plus(1L));
            this.batches().$plus$eq((Object)rows);
            LongOffset longOffset = this.currentOffset();
            return longOffset;
        }
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MemoryStream[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.truncatedString(this.output(), ",")}));
    }

    @Override
    public synchronized void setOffsetRange(Optional<org.apache.spark.sql.sources.v2.reader.streaming.Offset> start2, Optional<org.apache.spark.sql.sources.v2.reader.streaming.Offset> end) {
        this.startOffset_$eq((LongOffset)start2.orElse(new LongOffset(-1L)));
        this.endOffset_$eq((LongOffset)end.orElse(this.currentOffset()));
    }

    @Override
    public StructType readSchema() {
        return this.encoder().schema();
    }

    @Override
    public org.apache.spark.sql.sources.v2.reader.streaming.Offset deserializeOffset(String json) {
        return new LongOffset(new StringOps(Predef$.MODULE$.augmentString(json)).toLong());
    }

    @Override
    public synchronized org.apache.spark.sql.sources.v2.reader.streaming.Offset getStartOffset() {
        return this.startOffset().offset() == -1L ? null : this.startOffset();
    }

    @Override
    public synchronized org.apache.spark.sql.sources.v2.reader.streaming.Offset getEndOffset() {
        return this.endOffset().offset() == -1L ? null : this.endOffset();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized List<DataReaderFactory<UnsafeRow>> createUnsafeRowReaderFactories() {
        Object object;
        int startOrdinal = (int)this.startOffset().offset() + 1;
        int endOrdinal = (int)this.endOffset().offset() + 1;
        MemoryStream memoryStream = this;
        synchronized (memoryStream) {
            int sliceStart = startOrdinal - (int)this.lastOffsetCommitted().offset() - 1;
            int sliceEnd = endOrdinal - (int)this.lastOffsetCommitted().offset() - 1;
            Predef$.MODULE$.assert(sliceStart <= sliceEnd, (Function0)new Serializable(this, sliceStart, sliceEnd){
                public static final long serialVersionUID = 0L;
                private final int sliceStart$1;
                private final int sliceEnd$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sliceStart: ", " sliceEnd: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.sliceStart$1), BoxesRunTime.boxToInteger((int)this.sliceEnd$1)}));
                }
                {
                    this.sliceStart$1 = sliceStart$1;
                    this.sliceEnd$1 = sliceEnd$1;
                }
            });
            object = this.batches().slice(sliceStart, sliceEnd);
        }
        ListBuffer newBlocks = (ListBuffer)object;
        this.logDebug((Function0<String>)new Serializable(this, startOrdinal, endOrdinal, newBlocks){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryStream $outer;
            private final int startOrdinal$1;
            private final int endOrdinal$1;
            private final ListBuffer newBlocks$1;

            public final String apply() {
                return this.$outer.org$apache$spark$sql$execution$streaming$MemoryStream$$generateDebugString((Seq<UnsafeRow>)((Seq)this.newBlocks$1.flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<UnsafeRow> apply(UnsafeRow[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                })), this.startOrdinal$1, this.endOrdinal$1);
            }
            {
                void var4_4;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.startOrdinal$1 = startOrdinal$1;
                this.endOrdinal$1 = endOrdinal$1;
                this.newBlocks$1 = var4_4;
            }
        });
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)newBlocks.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DataReaderFactory<UnsafeRow> apply(UnsafeRow[] block) {
                return new MemoryStreamDataReaderFactory(block);
            }
        }, ListBuffer$.MODULE$.canBuildFrom())).asJava();
    }

    public String org$apache$spark$sql$execution$streaming$MemoryStream$$generateDebugString(Seq<UnsafeRow> rows, int startOrdinal, int endOrdinal) {
        ExpressionEncoder expressionEncoder = this.encoder().resolveAndBind(this.encoder().resolveAndBind$default$1(), this.encoder().resolveAndBind$default$2());
        Serializable fromRow = new Serializable(this, expressionEncoder){
            public static final long serialVersionUID = 0L;
            private final ExpressionEncoder eta$0$1$1;

            public final A apply(InternalRow row) {
                return (A)this.eta$0$1$1.fromRow(row);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        };
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MemoryBatch [", ", ", "]: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)startOrdinal), BoxesRunTime.boxToInteger((int)endOrdinal)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)rows.map((Function1)new Serializable(this, (Function1)fromRow){
            public static final long serialVersionUID = 0L;
            private final Function1 fromRow$1;

            public final A apply(UnsafeRow row) {
                return (A)this.fromRow$1.apply((Object)row);
            }
            {
                this.fromRow$1 = fromRow$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")}))).toString();
    }

    @Override
    public synchronized void commit(org.apache.spark.sql.sources.v2.reader.streaming.Offset end) {
        Option<LongOffset> option = LongOffset$.MODULE$.convert(end);
        if (option instanceof Some) {
            Some some = (Some)option;
            LongOffset lo = (LongOffset)some.x();
            this.check$1(lo, end);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MemoryStream.commit() received an offset (", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{end}))).append((Object)"that did not originate with an instance of this class").toString());
        }
        throw new MatchError(option);
    }

    @Override
    public void stop() {
    }

    public synchronized void reset() {
        this.batches().clear();
        this.startOffset_$eq(new LongOffset(-1L));
        this.endOffset_$eq(new LongOffset(-1L));
        this.currentOffset_$eq(new LongOffset(-1L));
        this.lastOffsetCommitted_$eq(new LongOffset(-1L));
    }

    public <A> MemoryStream<A> copy(int id, SQLContext sqlContext, Encoder<A> evidence$2) {
        return new MemoryStream<A>(id, sqlContext, evidence$2);
    }

    public <A> int copy$default$1() {
        return this.id();
    }

    public <A> SQLContext copy$default$2() {
        return this.sqlContext();
    }

    public String productPrefix() {
        return "MemoryStream";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.sqlContext();
                break;
            }
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.id());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MemoryStream;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.id());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sqlContext()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MemoryStream)) return false;
        boolean bl = true;
        if (!bl) return false;
        MemoryStream memoryStream = (MemoryStream)x$1;
        if (this.id() != memoryStream.id()) return false;
        SQLContext sQLContext = this.sqlContext();
        SQLContext sQLContext2 = memoryStream.sqlContext();
        if (sQLContext == null) {
            if (sQLContext2 != null) {
                return false;
            }
        } else if (!sQLContext.equals(sQLContext2)) return false;
        if (!memoryStream.canEqual(this)) return false;
        return true;
    }

    private final void check$1(LongOffset newOffset, org.apache.spark.sql.sources.v2.reader.streaming.Offset end$1) {
        int offsetDiff = (int)(newOffset.offset() - this.lastOffsetCommitted().offset());
        if (offsetDiff < 0) {
            throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offsets committed out of order: ", " followed by ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.lastOffsetCommitted(), end$1})));
        }
        this.batches().trimStart(offsetDiff);
        this.lastOffsetCommitted_$eq(newOffset);
    }

    public MemoryStream(int id, SQLContext sqlContext, Encoder<A> evidence$2) {
        this.id = id;
        this.sqlContext = sqlContext;
        this.evidence$2 = evidence$2;
        Logging.class.$init$((Logging)this);
        Product.class.$init$((Product)this);
        this.encoder = package$.MODULE$.encoderFor(evidence$2);
        this.attributes = this.encoder().schema().toAttributes();
        this.logicalPlan = new StreamingExecutionRelation(this, this.attributes(), sqlContext.sparkSession());
        this.output = this.logicalPlan().output();
        this.batches = new ListBuffer();
        this.currentOffset = new LongOffset(-1L);
        this.startOffset = new LongOffset(-1L);
        this.endOffset = new LongOffset(-1L);
        this.lastOffsetCommitted = new LongOffset(-1L);
    }
}

