/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogColumnStat;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Ceil;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Least;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxCountDistinctForIntervals;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxCountDistinctForIntervals$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.command.AnalyzeColumnCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand$class;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\rc\u0001B\u0001\u0003\u0001>\u0011A#\u00118bYfTXmQ8mk6t7i\\7nC:$'BA\u0002\u0005\u0003\u001d\u0019w.\\7b]\u0012T!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u00115y!\u0003CA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u001dawnZ5dC2T!!\u0006\f\u0002\u000bAd\u0017M\\:\u000b\u0005]1\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005e\u0011\"a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"a\u0007\u000f\u000e\u0003\tI!!\b\u0002\u0003\u001fI+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002 K%\u0011a\u0005\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tQ\u0001\u0011)\u001a!C\u0001S\u0005QA/\u00192mK&#WM\u001c;\u0016\u0003)\u0002\"a\u000b\u0017\u000e\u0003YI!!\f\f\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJD\u0001b\f\u0001\u0003\u0012\u0003\u0006IAK\u0001\fi\u0006\u0014G.Z%eK:$\b\u0005\u0003\u00052\u0001\tU\r\u0011\"\u00013\u0003-\u0019w\u000e\\;n]:\u000bW.Z:\u0016\u0003M\u00022\u0001\u000e\u001f@\u001d\t)$H\u0004\u00027s5\tqG\u0003\u00029\u001d\u00051AH]8pizJ\u0011!I\u0005\u0003w\u0001\nq\u0001]1dW\u0006<W-\u0003\u0002>}\t\u00191+Z9\u000b\u0005m\u0002\u0003C\u0001!D\u001d\ty\u0012)\u0003\u0002CA\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\rM#(/\u001b8h\u0015\t\u0011\u0005\u0005\u0003\u0005H\u0001\tE\t\u0015!\u00034\u00031\u0019w\u000e\\;n]:\u000bW.Z:!\u0011\u0015I\u0005\u0001\"\u0001K\u0003\u0019a\u0014N\\5u}Q\u00191\nT'\u0011\u0005m\u0001\u0001\"\u0002\u0015I\u0001\u0004Q\u0003\"B\u0019I\u0001\u0004\u0019\u0004\"B(\u0001\t\u0003\u0002\u0016a\u0001:v]R\u0011\u0011K\u0016\t\u0004iq\u0012\u0006CA*U\u001b\u00051\u0011BA+\u0007\u0005\r\u0011vn\u001e\u0005\u0006/:\u0003\r\u0001W\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003'fK!A\u0017\u0004\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000bq\u0003A\u0011B/\u0002%\r|W\u000e];uK\u000e{G.^7o'R\fGo\u001d\u000b\u0005=6tw\u000e\u0005\u0003 ?\u0006$\u0017B\u00011!\u0005\u0019!V\u000f\u001d7feA\u0011qDY\u0005\u0003G\u0002\u0012A\u0001T8oOB!\u0001)Z h\u0013\t1WIA\u0002NCB\u0004\"\u0001[6\u000e\u0003%T!A\u001b\f\u0002\u000f\r\fG/\u00197pO&\u0011A.\u001b\u0002\u0012\u0007\u0006$\u0018\r\\8h\u0007>dW/\u001c8Ti\u0006$\b\"B,\\\u0001\u0004A\u0006\"\u0002\u0015\\\u0001\u0004Q\u0003\"B\u0019\\\u0001\u0004\u0019\u0004\"B9\u0001\t\u0013\u0011\u0018AE2p[B,H/\u001a)fe\u000e,g\u000e^5mKN$ba]@\u0002\f\u00055\u0001c\u0001;xs6\tQO\u0003\u0002w-\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\tAXO\u0001\u0007BiR\u0014\u0018NY;uK6\u000b\u0007\u000f\u0005\u0002{{6\t1P\u0003\u0002}-\u0005!Q\u000f^5m\u0013\tq8PA\u0005BeJ\f\u0017\u0010R1uC\"9\u0011\u0011\u00019A\u0002\u0005\r\u0011aE1uiJL'-\u001e;fgR{\u0017I\\1msj,\u0007\u0003\u0002\u001b=\u0003\u000b\u00012\u0001^A\u0004\u0013\r\tI!\u001e\u0002\n\u0003R$(/\u001b2vi\u0016DQa\u00169A\u0002aCa!a\u0004q\u0001\u0004\u0001\u0012\u0001\u0003:fY\u0006$\u0018n\u001c8\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016\u0005a1/\u001e9q_J$8\u000fV=qKR!\u0011qCA\u000f!\ry\u0012\u0011D\u0005\u0004\u00037\u0001#a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003?\t\t\u00021\u0001\u0002\"\u0005AA-\u0019;b)f\u0004X\r\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9CB\u0001\u0006if\u0004Xm]\u0005\u0005\u0003W\t)C\u0001\u0005ECR\fG+\u001f9f\u0011\u001d\ty\u0003\u0001C\u0005\u0003c\t\u0011c];qa>\u0014Ho\u001d%jgR|wM]1n)\u0011\t9\"a\r\t\u0011\u0005}\u0011Q\u0006a\u0001\u0003CAq!a\u000e\u0001\t\u0013\tI$A\u0005ti\u0006$X\t\u001f9sgRA\u00111HA!\u0003\u000b\n)\u0006E\u0002u\u0003{I1!a\u0010v\u0005E\u0019%/Z1uK:\u000bW.\u001a3TiJ,8\r\u001e\u0005\t\u0003\u0007\n)\u00041\u0001\u0002\u0006\u0005\u00191m\u001c7\t\u0011\u0005\u001d\u0013Q\u0007a\u0001\u0003\u0013\nAaY8oMB!\u00111JA)\u001b\t\tiEC\u0002\u0002P\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0003'\niEA\u0004T#2\u001buN\u001c4\t\u000f\u0005]\u0013Q\u0007a\u0001g\u0006q1m\u001c7QKJ\u001cWM\u001c;jY\u0016\u001c\bbBA.\u0001\u0011%\u0011QL\u0001\u0010e><Hk\\\"pYVlgn\u0015;biRQ\u0011qLA3\u0003_\n\u0019(a\u001e\u0011\u0007E\t\t'C\u0002\u0002dI\u0011!bQ8mk6t7\u000b^1u\u0011!\t9'!\u0017A\u0002\u0005%\u0014a\u0001:poB\u00191&a\u001b\n\u0007\u00055dCA\u0006J]R,'O\\1m%><\b\u0002CA9\u00033\u0002\r!!\u0002\u0002\t\u0005$HO\u001d\u0005\b\u0003k\nI\u00061\u0001b\u0003!\u0011xn^\"pk:$\b\u0002CA=\u00033\u0002\r!a\u001f\u0002\u0017A,'oY3oi&dWm\u001d\t\u0005?\u0005u\u00140C\u0002\u0002\u0000\u0001\u0012aa\u00149uS>t\u0007\"CAB\u0001\u0005\u0005I\u0011AAC\u0003\u0011\u0019w\u000e]=\u0015\u000b-\u000b9)!#\t\u0011!\n\t\t%AA\u0002)B\u0001\"MAA!\u0003\u0005\ra\r\u0005\n\u0003\u001b\u0003\u0011\u0013!C\u0001\u0003\u001f\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0012*\u001a!&a%,\u0005\u0005U\u0005\u0003BAL\u0003Ck!!!'\u000b\t\u0005m\u0015QT\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a(!\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\u000bIJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a*\u0001#\u0003%\t!!+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0016\u0016\u0004g\u0005M\u0005\"CAX\u0001\u0005\u0005I\u0011IAY\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0017\t\u0005\u0003k\u000by,\u0004\u0002\u00028*!\u0011\u0011XA^\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0016\u0001\u00026bm\u0006L1\u0001RA\\\u0011%\t\u0019\rAA\u0001\n\u0003\t)-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002HB\u0019q$!3\n\u0007\u0005-\u0007EA\u0002J]RD\u0011\"a4\u0001\u0003\u0003%\t!!5\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111[Am!\ry\u0012Q[\u0005\u0004\u0003/\u0004#aA!os\"Q\u00111\\Ag\u0003\u0003\u0005\r!a2\u0002\u0007a$\u0013\u0007C\u0005\u0002`\u0002\t\t\u0011\"\u0011\u0002b\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002dB1\u0011Q]Av\u0003'l!!a:\u000b\u0007\u0005%\b%\u0001\u0006d_2dWm\u0019;j_:LA!!<\u0002h\nA\u0011\n^3sCR|'\u000fC\u0005\u0002r\u0002\t\t\u0011\"\u0001\u0002t\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0018\u0005U\bBCAn\u0003_\f\t\u00111\u0001\u0002T\"I\u0011\u0011 \u0001\u0002\u0002\u0013\u0005\u00131`\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005]\u0011Q \u0005\u000b\u00037\f90!AA\u0002\u0005Mw!\u0003B\u0001\u0005\u0005\u0005\t\u0012\u0001B\u0002\u0003Q\te.\u00197zu\u0016\u001cu\u000e\\;n]\u000e{W.\\1oIB\u00191D!\u0002\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0005\u000f\u0019RA!\u0002\u0003\n\u0011\u0002rAa\u0003\u0003\u0012)\u001a4*\u0004\u0002\u0003\u000e)\u0019!q\u0002\u0011\u0002\u000fI,h\u000e^5nK&!!1\u0003B\u0007\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b\u0013\n\u0015A\u0011\u0001B\f)\t\u0011\u0019\u0001\u0003\u0006\u0003\u001c\t\u0015\u0011\u0011!C#\u0005;\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003gC!B!\t\u0003\u0006\u0005\u0005I\u0011\u0011B\u0012\u0003\u0015\t\u0007\u000f\u001d7z)\u0015Y%Q\u0005B\u0014\u0011\u0019A#q\u0004a\u0001U!1\u0011Ga\bA\u0002MB!Ba\u000b\u0003\u0006\u0005\u0005I\u0011\u0011B\u0017\u0003\u001d)h.\u00199qYf$BAa\f\u00034A)q$! \u00032A!qd\u0018\u00164\u0011%\u0011)D!\u000b\u0002\u0002\u0003\u00071*A\u0002yIAB!B!\u000f\u0003\u0006\u0005\u0005I\u0011\u0002B\u001e\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tu\u0002\u0003BA[\u0005\u007fIAA!\u0011\u00028\n1qJ\u00196fGR\u0004")
public class AnalyzeColumnCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableIdent;
    private final Seq<String> columnNames;
    private final Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Seq<String>>> unapply(AnalyzeColumnCommand analyzeColumnCommand) {
        return AnalyzeColumnCommand$.MODULE$.unapply(analyzeColumnCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Seq<String>>, AnalyzeColumnCommand> tupled() {
        return AnalyzeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<String>, AnalyzeColumnCommand>> curried() {
        return AnalyzeColumnCommand$.MODULE$.curried();
    }

    private Map metrics$lzycompute() {
        AnalyzeColumnCommand analyzeColumnCommand = this;
        synchronized (analyzeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand$class.metrics(this);
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.class.children((Command)this);
    }

    public TableIdentifier tableIdent() {
        return this.tableIdent;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionState sessionState2 = sparkSession.sessionState();
        String db = (String)this.tableIdent().database().getOrElse((Function0)new Serializable(this, sessionState2){
            public static final long serialVersionUID = 0L;
            private final SessionState sessionState$1;

            public final String apply() {
                return this.sessionState$1.catalog().getCurrentDatabase();
            }
            {
                this.sessionState$1 = sessionState$1;
            }
        });
        TableIdentifier tableIdentWithDB = new TableIdentifier(this.tableIdent().table(), (Option)new Some((Object)db));
        CatalogTable tableMeta = sessionState2.catalog().getTableMetadata(tableIdentWithDB);
        CatalogTableType catalogTableType = tableMeta.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException("ANALYZE TABLE is not supported on views.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        BigInt sizeInBytes2 = CommandUtils$.MODULE$.calculateTotalSize(sessionState2, tableMeta);
        Tuple2<Object, Map<String, CatalogColumnStat>> tuple2 = this.computeColumnStats(sparkSession, tableIdentWithDB, this.columnNames());
        if (tuple2 != null) {
            Tuple2 tuple22;
            long rowCount = tuple2._1$mcJ$sp();
            Map newColStats = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
            long rowCount2 = tuple23._1$mcJ$sp();
            Map newColStats2 = (Map)tuple23._2();
            CatalogStatistics statistics = new CatalogStatistics(sizeInBytes2, (Option)new Some((Object)BigInt$.MODULE$.long2bigInt(rowCount2)), ((MapLike)tableMeta.stats().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Map<String, CatalogColumnStat> apply(CatalogStatistics x$2) {
                    return x$2.colStats();
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Map<String, Nothing$> apply() {
                    return Predef$.MODULE$.Map().empty();
                }
            })).$plus$plus((GenTraversableOnce)newColStats2));
            sessionState2.catalog().alterTableStats(tableIdentWithDB, (Option)new Some((Object)statistics));
            return (Seq)Seq$.MODULE$.empty();
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<Object, Map<String, CatalogColumnStat>> computeColumnStats(SparkSession sparkSession, TableIdentifier tableIdent, Seq<String> columnNames) {
        SQLConf conf = sparkSession.sessionState().conf();
        LogicalPlan relation = sparkSession.table(tableIdent).logicalPlan();
        Seq attributesToAnalyze = (Seq)columnNames.map((Function1)new Serializable(this, conf, relation){
            public static final long serialVersionUID = 0L;
            public final SQLConf conf$1;
            private final LogicalPlan relation$1;

            public final Attribute apply(String col) {
                Option exprOption = this.relation$1.output().find((Function1)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final String col$2;

                    public final boolean apply(Attribute attr) {
                        return BoxesRunTime.unboxToBoolean((Object)this.$outer.conf$1.resolver().apply((Object)attr.name(), (Object)this.col$2));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.col$2 = col$2;
                    }
                });
                return (Attribute)exprOption.getOrElse((Function0)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final String col$2;

                    public final Nothing$ apply() {
                        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.col$2})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    {
                        this.col$2 = col$2;
                    }
                });
            }
            {
                this.conf$1 = conf$1;
                this.relation$1 = relation$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        attributesToAnalyze.foreach((Function1)new Serializable(this, tableIdent){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AnalyzeColumnCommand $outer;
            private final TableIdentifier tableIdent$1;

            public final void apply(Attribute attr) {
                if (this.$outer.org$apache$spark$sql$execution$command$AnalyzeColumnCommand$$supportsType(attr.dataType())) {
                    return;
                }
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", " in table ", " is of type ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr.name(), this.tableIdent$1, attr.dataType()}))).append((Object)"and Spark does not support statistics collection on this column type.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableIdent$1 = tableIdent$1;
            }
        });
        AttributeMap<ArrayData> attributePercentiles = this.computePercentiles((Seq<Attribute>)attributesToAnalyze, sparkSession, relation);
        AggregateExpression aggregateExpression = Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression();
        Seq expressions = (Seq)((SeqLike)attributesToAnalyze.map((Function1)new Serializable(this, conf, attributePercentiles){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AnalyzeColumnCommand $outer;
            private final SQLConf conf$1;
            private final AttributeMap attributePercentiles$1;

            public final CreateNamedStruct apply(Attribute x$3) {
                return this.$outer.org$apache$spark$sql$execution$command$AnalyzeColumnCommand$$statExprs(x$3, this.conf$1, (AttributeMap<ArrayData>)this.attributePercentiles$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conf$1 = conf$1;
                this.attributePercentiles$1 = attributePercentiles$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)aggregateExpression, Seq$.MODULE$.canBuildFrom());
        Seq namedExpressions = (Seq)expressions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Alias apply(Expression e) {
                Expression x$6 = e;
                String x$7 = e.toString();
                ExprId x$8 = Alias$.MODULE$.apply$default$3(x$6, x$7);
                Option x$9 = Alias$.MODULE$.apply$default$4(x$6, x$7);
                Option x$10 = Alias$.MODULE$.apply$default$5(x$6, x$7);
                return new Alias(x$6, x$7, x$8, x$9, x$10);
            }
        }, Seq$.MODULE$.canBuildFrom());
        InternalRow statsRow = (InternalRow)Predef$.MODULE$.refArrayOps((Object[])new QueryExecution(sparkSession, (LogicalPlan)new Aggregate((Seq)Nil$.MODULE$, namedExpressions, relation)).executedPlan().executeTake(1)).head();
        long rowCount = statsRow.getLong(0);
        Map columnStats = ((TraversableOnce)((TraversableLike)attributesToAnalyze.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, attributePercentiles, statsRow, rowCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AnalyzeColumnCommand $outer;
            private final AttributeMap attributePercentiles$1;
            private final InternalRow statsRow$1;
            private final long rowCount$1;

            public final Tuple2<String, CatalogColumnStat> apply(Tuple2<Attribute, Object> x0$1) {
                Tuple2<Attribute, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Attribute attr = (Attribute)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)attr.name(), (Object)this.$outer.org$apache$spark$sql$execution$command$AnalyzeColumnCommand$$rowToColumnStat(this.statsRow$1.getStruct(i + 1, 7), attr, this.rowCount$1, (Option<ArrayData>)this.attributePercentiles$1.get(attr)).toCatalogColumnStat(attr.name(), attr.dataType()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.attributePercentiles$1 = attributePercentiles$1;
                this.statsRow$1 = statsRow$1;
                this.rowCount$1 = rowCount$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)columnStats);
    }

    private AttributeMap<ArrayData> computePercentiles(Seq<Attribute> attributesToAnalyze, SparkSession sparkSession, LogicalPlan relation) {
        Nil$ attrsToGenHistogram = this.conf().histogramEnabled() ? (Seq)attributesToAnalyze.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AnalyzeColumnCommand $outer;

            public final boolean apply(Attribute a) {
                return this.$outer.org$apache$spark$sql$execution$command$AnalyzeColumnCommand$$supportsHistogram(a.dataType());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }) : Nil$.MODULE$;
        HashMap attributePercentiles = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (attrsToGenHistogram.nonEmpty()) {
            double[] percentiles = (double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.conf().histogramNumBins()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AnalyzeColumnCommand $outer;

                public final double apply(int i) {
                    return this.apply$mcDI$sp(i);
                }

                public double apply$mcDI$sp(int i) {
                    return (double)i / (double)this.$outer.conf().histogramNumBins();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            Seq namedExprs = (Seq)attrsToGenHistogram.map((Function1)new Serializable(this, percentiles){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AnalyzeColumnCommand $outer;
                private final double[] percentiles$1;

                public final Alias apply(Attribute attr) {
                    AggregateExpression expr;
                    ApproximatePercentile aggFunc = new ApproximatePercentile((Expression)attr, (Expression)Literal$.MODULE$.apply((Object)this.percentiles$1), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.$outer.conf().percentileAccuracy())));
                    AggregateExpression x$11 = expr = aggFunc.toAggregateExpression();
                    String x$12 = expr.toString();
                    ExprId x$13 = Alias$.MODULE$.apply$default$3((Expression)x$11, x$12);
                    Option x$14 = Alias$.MODULE$.apply$default$4((Expression)x$11, x$12);
                    Option x$15 = Alias$.MODULE$.apply$default$5((Expression)x$11, x$12);
                    return new Alias((Expression)x$11, x$12, x$13, x$14, x$15);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.percentiles$1 = percentiles$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            InternalRow percentilesRow = (InternalRow)Predef$.MODULE$.refArrayOps((Object[])new QueryExecution(sparkSession, (LogicalPlan)new Aggregate((Seq)Nil$.MODULE$, namedExprs, relation)).executedPlan().executeTake(1)).head();
            ((IterableLike)attrsToGenHistogram.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, attributePercentiles, percentilesRow){
                public static final long serialVersionUID = 0L;
                private final HashMap attributePercentiles$2;
                private final InternalRow percentilesRow$1;

                public final Object apply(Tuple2<Attribute, Object> x0$2) {
                    Tuple2<Attribute, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        Attribute attr = (Attribute)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        ArrayData percentiles = this.percentilesRow$1.getArray(i);
                        BoxedUnit boxedUnit = percentiles == null ? BoxedUnit.UNIT : this.attributePercentiles$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attr), (Object)percentiles));
                        return boxedUnit;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.attributePercentiles$2 = attributePercentiles$2;
                    this.percentilesRow$1 = percentilesRow$1;
                }
            });
        }
        return AttributeMap$.MODULE$.apply(attributePercentiles.toSeq());
    }

    public boolean org$apache$spark$sql$execution$command$AnalyzeColumnCommand$$supportsType(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof IntegralType) {
            bl = true;
        } else if (dataType2 instanceof DecimalType) {
            bl = true;
        } else {
            boolean bl2 = DoubleType$.MODULE$.equals(dataType2) ? true : FloatType$.MODULE$.equals(dataType2);
            if (bl2) {
                bl = true;
            } else if (BooleanType$.MODULE$.equals(dataType2)) {
                bl = true;
            } else if (DateType$.MODULE$.equals(dataType2)) {
                bl = true;
            } else if (TimestampType$.MODULE$.equals(dataType2)) {
                bl = true;
            } else {
                boolean bl3 = BinaryType$.MODULE$.equals(dataType2) ? true : StringType$.MODULE$.equals(dataType2);
                bl = bl3;
            }
        }
        return bl;
    }

    public boolean org$apache$spark$sql$execution$command$AnalyzeColumnCommand$$supportsHistogram(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        boolean bl2 = dataType2 instanceof IntegralType ? true : (dataType2 instanceof DecimalType ? true : ((bl = DoubleType$.MODULE$.equals(dataType2) ? true : FloatType$.MODULE$.equals(dataType2)) ? true : (DateType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2))));
        return bl2;
    }

    public CreateNamedStruct org$apache$spark$sql$execution$command$AnalyzeColumnCommand$$statExprs(Attribute col, SQLConf conf, AttributeMap<ArrayData> colPercentiles) {
        block9: {
            CreateNamedStruct createNamedStruct;
            block3: {
                DataType dataType;
                Literal nullArray;
                Literal defaultSize;
                Subtract numNulls;
                Least ndv;
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        Literal one = new Literal((Object)BoxesRunTime.boxToInteger((int)1), (DataType)LongType$.MODULE$);
                                        Count numNonNulls = col.nullable() ? Count$.MODULE$.apply((Expression)col) : Count$.MODULE$.apply((Expression)one);
                                        ndv = new Least((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregateFunction[]{new HyperLogLogPlusPlus((Expression)col, conf.ndvMaxError(), HyperLogLogPlusPlus$.MODULE$.apply$default$3(), HyperLogLogPlusPlus$.MODULE$.apply$default$4()), numNonNulls})));
                                        numNulls = new Subtract((Expression)Count$.MODULE$.apply((Expression)one), (Expression)numNonNulls);
                                        defaultSize = new Literal((Object)BoxesRunTime.boxToInteger((int)col.dataType().defaultSize()), (DataType)LongType$.MODULE$);
                                        nullArray = new Literal(null, (DataType)ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$));
                                        dataType = col.dataType();
                                        if (!(dataType instanceof IntegralType)) break block2;
                                        createNamedStruct = this.fixedLenTypeStruct$1(col, conf, colPercentiles, ndv, numNulls, defaultSize, nullArray);
                                        break block3;
                                    }
                                    if (!(dataType instanceof DecimalType)) break block4;
                                    createNamedStruct = this.fixedLenTypeStruct$1(col, conf, colPercentiles, ndv, numNulls, defaultSize, nullArray);
                                    break block3;
                                }
                                boolean bl = DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType);
                                if (!bl) break block5;
                                createNamedStruct = this.fixedLenTypeStruct$1(col, conf, colPercentiles, ndv, numNulls, defaultSize, nullArray);
                                break block3;
                            }
                            if (!BooleanType$.MODULE$.equals(dataType)) break block6;
                            createNamedStruct = this.fixedLenTypeStruct$1(col, conf, colPercentiles, ndv, numNulls, defaultSize, nullArray);
                            break block3;
                        }
                        if (!DateType$.MODULE$.equals(dataType)) break block7;
                        createNamedStruct = this.fixedLenTypeStruct$1(col, conf, colPercentiles, ndv, numNulls, defaultSize, nullArray);
                        break block3;
                    }
                    if (!TimestampType$.MODULE$.equals(dataType)) break block8;
                    createNamedStruct = this.fixedLenTypeStruct$1(col, conf, colPercentiles, ndv, numNulls, defaultSize, nullArray);
                    break block3;
                }
                boolean bl = BinaryType$.MODULE$.equals(dataType) ? true : StringType$.MODULE$.equals(dataType);
                if (!bl) break block9;
                Literal nullLit = new Literal(null, col.dataType());
                createNamedStruct = this.struct$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{ndv, nullLit, nullLit, numNulls, new Coalesce((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Ceil((Expression)new Average((Expression)new Length((Expression)col))), defaultSize}))), new Coalesce((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Cast((Expression)new Max((Expression)new Length((Expression)col)), (DataType)LongType$.MODULE$, Cast$.MODULE$.apply$default$3()), defaultSize}))), nullArray}));
            }
            return createNamedStruct;
        }
        throw new AnalysisException(new StringBuilder().append((Object)"Analyzing column statistics is not supported for column ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " of data type: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col.name(), col.dataType()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public ColumnStat org$apache$spark$sql$execution$command$AnalyzeColumnCommand$$rowToColumnStat(InternalRow row, Attribute attr, long rowCount, Option<ArrayData> percentiles) {
        ColumnStat columnStat;
        ColumnStat cs = new ColumnStat(Option$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(row.getLong(0))), Option$.MODULE$.apply(row.get(1, attr.dataType())), Option$.MODULE$.apply(row.get(2, attr.dataType())), Option$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(row.getLong(3))), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)row.getLong(4))), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)row.getLong(5))), ColumnStat$.MODULE$.apply$default$7());
        if (row.isNullAt(6) || cs.nullCount().isEmpty()) {
            columnStat = cs;
        } else {
            long[] ndvs = row.getArray(6).toLongArray();
            Predef$.MODULE$.assert(((ArrayData)percentiles.get()).numElements() == ndvs.length + 1);
            double[] endpoints = (double[])Predef$.MODULE$.genericArrayOps(((ArrayData)percentiles.get()).toArray(attr.dataType(), ClassTag$.MODULE$.Any())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Object x$5) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$5.toString())).toDouble();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            HistogramBin[] bins = (HistogramBin[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.longArrayOps(ndvs).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this, endpoints){
                public static final long serialVersionUID = 0L;
                private final double[] endpoints$1;

                public final HistogramBin apply(Tuple2<Object, Object> x0$3) {
                    Tuple2<Object, Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        long ndv = tuple2._1$mcJ$sp();
                        int i = tuple2._2$mcI$sp();
                        HistogramBin histogramBin = new HistogramBin(this.endpoints$1[i], this.endpoints$1[i + 1], ndv);
                        return histogramBin;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.endpoints$1 = endpoints$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HistogramBin.class)));
            BigInt nonNullRows = BigInt$.MODULE$.long2bigInt(rowCount).$minus((BigInt)cs.nullCount().get());
            Histogram histogram = new Histogram(nonNullRows.toDouble() / (double)ndvs.length, bins);
            Some x$16 = new Some((Object)histogram);
            Option x$17 = cs.copy$default$1();
            Option x$18 = cs.copy$default$2();
            Option x$19 = cs.copy$default$3();
            Option x$20 = cs.copy$default$4();
            Option x$21 = cs.copy$default$5();
            Option x$22 = cs.copy$default$6();
            columnStat = cs.copy(x$17, x$18, x$19, x$20, x$21, x$22, (Option)x$16);
        }
        return columnStat;
    }

    public AnalyzeColumnCommand copy(TableIdentifier tableIdent, Seq<String> columnNames) {
        return new AnalyzeColumnCommand(tableIdent, columnNames);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdent();
    }

    public Seq<String> copy$default$2() {
        return this.columnNames();
    }

    public String productPrefix() {
        return "AnalyzeColumnCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        TableIdentifier tableIdentifier;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                tableIdentifier = this.columnNames();
                break;
            }
            case 0: {
                tableIdentifier = this.tableIdent();
            }
        }
        return tableIdentifier;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AnalyzeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AnalyzeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AnalyzeColumnCommand analyzeColumnCommand = (AnalyzeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.tableIdent();
        TableIdentifier tableIdentifier2 = analyzeColumnCommand.tableIdent();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<String> seq = this.columnNames();
        Seq<String> seq2 = analyzeColumnCommand.columnNames();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!analyzeColumnCommand.canEqual(this)) return false;
        return true;
    }

    private final CreateNamedStruct struct$1(Seq exprs) {
        return CreateStruct$.MODULE$.apply((Seq)exprs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Expression apply(Expression expr) {
                return (Expression)expr.transformUp((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof AggregateFunction) {
                            AggregateFunction aggregateFunction = (AggregateFunction)A1;
                            object = aggregateFunction.toAggregateExpression();
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Expression x1) {
                        Expression expression = x1;
                        boolean bl = expression instanceof AggregateFunction;
                        return bl;
                    }
                });
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    private final CreateNamedStruct fixedLenTypeStruct$1(Attribute col$1, SQLConf conf$2, AttributeMap colPercentiles$1, Least ndv$1, Subtract numNulls$1, Literal defaultSize$1, Literal nullArray$1) {
        boolean genHistogram = this.org$apache$spark$sql$execution$command$AnalyzeColumnCommand$$supportsHistogram(col$1.dataType()) && colPercentiles$1.contains(col$1);
        Literal intervalNdvsExpr = genHistogram ? new ApproxCountDistinctForIntervals((Expression)col$1, (Expression)new Literal(colPercentiles$1.apply((Object)col$1), (DataType)ArrayType$.MODULE$.apply(col$1.dataType())), conf$2.ndvMaxError(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$4(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$5()) : nullArray$1;
        return this.struct$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{ndv$1, new Cast((Expression)new Min((Expression)col$1), col$1.dataType(), Cast$.MODULE$.apply$default$3()), new Cast((Expression)new Max((Expression)col$1), col$1.dataType(), Cast$.MODULE$.apply$default$3()), numNulls$1, defaultSize$1, defaultSize$1, intervalNdvsExpr}));
    }

    public AnalyzeColumnCommand(TableIdentifier tableIdent, Seq<String> columnNames) {
        this.tableIdent = tableIdent;
        this.columnNames = columnNames;
        Command.class.$init$((Command)this);
        RunnableCommand$class.$init$(this);
    }
}

