/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.base.seata.at;

import com.google.common.base.Preconditions;
import io.seata.config.FileConfiguration;
import io.seata.core.context.RootContext;
import io.seata.core.exception.TransactionException;
import io.seata.core.rpc.netty.RmNettyRemotingClient;
import io.seata.core.rpc.netty.TmNettyRemotingClient;
import io.seata.rm.RMClient;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.tm.TMClient;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.transaction.base.seata.at.SeataTransactionHolder;
import org.apache.shardingsphere.transaction.core.ResourceDataSource;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.spi.ShardingSphereTransactionManager;

public final class SeataATShardingSphereTransactionManager
implements ShardingSphereTransactionManager {
    private final Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
    private final String applicationId;
    private final String transactionServiceGroup;
    private final boolean enableSeataAT;
    private final int globalTXTimeout;

    public SeataATShardingSphereTransactionManager() {
        FileConfiguration config = new FileConfiguration("seata.conf");
        this.enableSeataAT = config.getBoolean("sharding.transaction.seata.at.enable", true);
        this.applicationId = config.getConfig("client.application.id");
        this.transactionServiceGroup = config.getConfig("client.transaction.service.group", "default");
        this.globalTXTimeout = config.getInt("sharding.transaction.seata.tx.timeout", 60);
    }

    public void init(DatabaseType databaseType, Collection<ResourceDataSource> resourceDataSources, String providerType) {
        if (this.enableSeataAT) {
            this.initSeataRPCClient();
            resourceDataSources.forEach(each -> this.dataSourceMap.put(each.getOriginalName(), (DataSource)new DataSourceProxy(each.getDataSource())));
        }
    }

    private void initSeataRPCClient() {
        Preconditions.checkNotNull((Object)this.applicationId, (Object)"please config application id within seata.conf file.");
        TMClient.init((String)this.applicationId, (String)this.transactionServiceGroup);
        RMClient.init((String)this.applicationId, (String)this.transactionServiceGroup);
    }

    public TransactionType getTransactionType() {
        return TransactionType.BASE;
    }

    public boolean isInTransaction() {
        Preconditions.checkState((boolean)this.enableSeataAT, (Object)"sharding seata-at transaction has been disabled.");
        return null != RootContext.getXID();
    }

    public Connection getConnection(String databaseName, String dataSourceName) throws SQLException {
        Preconditions.checkState((boolean)this.enableSeataAT, (Object)"sharding seata-at transaction has been disabled.");
        return this.dataSourceMap.get(databaseName + "." + dataSourceName).getConnection();
    }

    public void begin() {
        this.begin(this.globalTXTimeout);
    }

    public void begin(int timeout) {
        if (timeout < 0) {
            throw new TransactionException("timeout should more than 0s");
        }
        Preconditions.checkState((boolean)this.enableSeataAT, (Object)"sharding seata-at transaction has been disabled.");
        GlobalTransaction globalTransaction = GlobalTransactionContext.getCurrentOrCreate();
        globalTransaction.begin(timeout * 1000);
        SeataTransactionHolder.set(globalTransaction);
    }

    public void commit(boolean rollbackOnly) {
        Preconditions.checkState((boolean)this.enableSeataAT, (Object)"sharding seata-at transaction has been disabled.");
        try {
            SeataTransactionHolder.get().commit();
        }
        finally {
            SeataTransactionHolder.clear();
            RootContext.unbind();
        }
    }

    public void rollback() {
        Preconditions.checkState((boolean)this.enableSeataAT, (Object)"sharding seata-at transaction has been disabled.");
        try {
            SeataTransactionHolder.get().rollback();
        }
        finally {
            SeataTransactionHolder.clear();
            RootContext.unbind();
        }
    }

    public void close() {
        this.dataSourceMap.clear();
        SeataTransactionHolder.clear();
        RmNettyRemotingClient.getInstance().destroy();
        TmNettyRemotingClient.getInstance().destroy();
    }
}

