/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContextFactory;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.event.DropSchemaEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class DropSchemaStatementSchemaRefresher
implements MetaDataRefresher<DropSchemaStatement> {
    private static final String TYPE = DropSchemaStatement.class.getName();

    @Override
    public Optional<MetaDataRefreshedEvent> refresh(ShardingSphereDatabase database, FederationDatabaseMetaData federationDatabaseMetaData, Map<String, OptimizerPlannerContext> optimizerPlanners, Collection<String> logicDataSourceNames, String schemaName, DropSchemaStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        LinkedHashSet tobeRemovedTables = new LinkedHashSet();
        LinkedHashSet<String> tobeRemovedSchemas = new LinkedHashSet<String>();
        Collection<String> schemaNames = this.getSchemaNames(sqlStatement);
        for (String each : schemaNames) {
            Optional.ofNullable((ShardingSphereSchema)database.getSchemas().remove(each)).ifPresent(optional -> tobeRemovedTables.addAll(optional.getAllTableNames()));
            tobeRemovedSchemas.add(each.toLowerCase());
            federationDatabaseMetaData.removeSchemaMetadata(each);
            optimizerPlanners.put(federationDatabaseMetaData.getName(), OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)federationDatabaseMetaData));
        }
        Collection rules = database.getRuleMetaData().findRules(MutableDataNodeRule.class);
        for (String each : tobeRemovedTables) {
            this.removeDataNode(rules, each, tobeRemovedSchemas);
        }
        return Optional.of(new DropSchemaEvent(database.getName(), schemaNames));
    }

    private Collection<String> getSchemaNames(DropSchemaStatement sqlStatement) {
        LinkedList<String> result = new LinkedList<String>();
        for (IdentifierValue each : sqlStatement.getSchemaNames()) {
            result.add(each.getValue());
        }
        return result;
    }

    private void removeDataNode(Collection<MutableDataNodeRule> rules, String tobeRemovedTable, Collection<String> schemaNames) {
        for (MutableDataNodeRule each : rules) {
            each.remove(schemaNames, tobeRemovedTable);
        }
    }

    public String getType() {
        return TYPE;
    }
}

