/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresherFactory;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class MetaDataRefreshEngine {
    private static final Set<Class<? extends SQLStatement>> IGNORABLE_SQL_STATEMENT_CLASSES = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ShardingSphereDatabase database;
    private final FederationDatabaseMetaData federationMetaData;
    private final Map<String, OptimizerPlannerContext> optimizerPlanners;
    private final ConfigurationProperties props;

    public Optional<MetaDataRefreshedEvent> refresh(SQLStatementContext<?> sqlStatementContext, Supplier<Collection<String>> logicDataSourceNamesSupplier) throws SQLException {
        Class<?> sqlStatementClass = sqlStatementContext.getSqlStatement().getClass();
        if (IGNORABLE_SQL_STATEMENT_CLASSES.contains(sqlStatementClass)) {
            return Optional.empty();
        }
        Optional<MetaDataRefresher> schemaRefresher = MetaDataRefresherFactory.findInstance(sqlStatementClass);
        if (schemaRefresher.isPresent()) {
            String schemaName = sqlStatementContext.getTablesContext().getSchemaName().orElseGet(() -> DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)this.database.getName()));
            return schemaRefresher.get().refresh(this.database, this.federationMetaData, this.optimizerPlanners, logicDataSourceNamesSupplier.get(), schemaName, sqlStatementContext.getSqlStatement(), this.props);
        }
        IGNORABLE_SQL_STATEMENT_CLASSES.add(sqlStatementClass);
        return Optional.empty();
    }

    @Generated
    public MetaDataRefreshEngine(ShardingSphereDatabase database, FederationDatabaseMetaData federationMetaData, Map<String, OptimizerPlannerContext> optimizerPlanners, ConfigurationProperties props) {
        this.database = database;
        this.federationMetaData = federationMetaData;
        this.optimizerPlanners = optimizerPlanners;
        this.props = props;
    }
}

