/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContextFactory;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.TableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;

public final class AlterTableStatementSchemaRefresher
implements MetaDataRefresher<AlterTableStatement> {
    private static final String TYPE = AlterTableStatement.class.getName();

    @Override
    public void refresh(ShardingSphereMetaData schemaMetaData, FederationDatabaseMetaData database, Map<String, OptimizerPlannerContext> optimizerPlanners, Collection<String> logicDataSourceNames, AlterTableStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        SchemaAlteredEvent event = new SchemaAlteredEvent(schemaMetaData.getName());
        if (sqlStatement.getRenameTable().isPresent()) {
            String renameTable = ((SimpleTableSegment)sqlStatement.getRenameTable().get()).getTableName().getIdentifier().getValue();
            this.putTableMetaData(schemaMetaData, database, optimizerPlanners, logicDataSourceNames, renameTable, props);
            this.removeTableMetaData(schemaMetaData, database, optimizerPlanners, tableName);
            event.getAlteredTables().add(schemaMetaData.getDefaultSchema().get(renameTable));
            event.getDroppedTables().add(tableName);
        } else {
            this.putTableMetaData(schemaMetaData, database, optimizerPlanners, logicDataSourceNames, tableName, props);
            event.getAlteredTables().add(schemaMetaData.getDefaultSchema().get(tableName));
        }
        ShardingSphereEventBus.getInstance().post((Object)event);
    }

    private void removeTableMetaData(ShardingSphereMetaData schemaMetaData, FederationDatabaseMetaData database, Map<String, OptimizerPlannerContext> optimizerPlanners, String tableName) {
        schemaMetaData.getDefaultSchema().remove(tableName);
        schemaMetaData.getRuleMetaData().findRules(MutableDataNodeRule.class).forEach(each -> each.remove(tableName));
        database.remove(tableName);
        optimizerPlanners.put(database.getName(), OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)database));
    }

    private void putTableMetaData(ShardingSphereMetaData schemaMetaData, FederationDatabaseMetaData database, Map<String, OptimizerPlannerContext> optimizerPlanners, Collection<String> logicDataSourceNames, String tableName, ConfigurationProperties props) throws SQLException {
        if (!this.containsInDataNodeContainedRule(tableName, schemaMetaData)) {
            schemaMetaData.getRuleMetaData().findRules(MutableDataNodeRule.class).forEach(each -> each.put(tableName, (String)logicDataSourceNames.iterator().next()));
        }
        SchemaBuilderMaterials materials = new SchemaBuilderMaterials(schemaMetaData.getResource().getDatabaseType(), schemaMetaData.getResource().getDataSources(), schemaMetaData.getRuleMetaData().getRules(), props);
        Optional actualTableMetaData = Optional.ofNullable(TableMetaDataBuilder.load(Collections.singletonList(tableName), (SchemaBuilderMaterials)materials).get(tableName));
        actualTableMetaData.ifPresent(tableMetaData -> {
            schemaMetaData.getDefaultSchema().put(tableName, tableMetaData);
            database.put(tableMetaData);
            optimizerPlanners.put(database.getName(), OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)database));
        });
    }

    private boolean containsInDataNodeContainedRule(String tableName, ShardingSphereMetaData schemaMetaData) {
        return schemaMetaData.getRuleMetaData().findRules(DataNodeContainedRule.class).stream().anyMatch(each -> each.getAllTables().contains(tableName));
    }

    public String getType() {
        return TYPE;
    }
}

