/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.config.swapper.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.util.yaml.YamlConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperFactory;

public final class YamlRuleConfigurationSwapperEngine {
    public Collection<YamlRuleConfiguration> swapToYamlRuleConfigurations(Collection<RuleConfiguration> ruleConfigs) {
        return YamlRuleConfigurationSwapperFactory.getInstanceMapByRuleConfigurations(ruleConfigs).entrySet().stream().map(entry -> (YamlRuleConfiguration)((YamlRuleConfigurationSwapper)entry.getValue()).swapToYamlConfiguration(entry.getKey())).collect(Collectors.toList());
    }

    public Collection<RuleConfiguration> swapToRuleConfigurations(Collection<YamlRuleConfiguration> yamlRuleConfigs) {
        LinkedList<RuleConfiguration> result = new LinkedList<RuleConfiguration>();
        Collection ruleConfigTypes = yamlRuleConfigs.stream().map(YamlRuleConfiguration::getRuleConfigurationType).collect(Collectors.toList());
        for (Map.Entry<Class<?>, YamlRuleConfigurationSwapper> entry : YamlRuleConfigurationSwapperFactory.getInstanceMapByRuleConfigurationClasses(ruleConfigTypes).entrySet()) {
            result.addAll(this.swapToRuleConfigurations(yamlRuleConfigs, entry.getKey(), entry.getValue()));
        }
        return result;
    }

    private Collection<RuleConfiguration> swapToRuleConfigurations(Collection<YamlRuleConfiguration> yamlRuleConfigs, Class<?> ruleConfigType, YamlRuleConfigurationSwapper swapper) {
        return yamlRuleConfigs.stream().filter(each -> each.getRuleConfigurationType().equals(ruleConfigType)).map(each -> (RuleConfiguration)swapper.swapToObject((YamlConfiguration)each)).collect(Collectors.toList());
    }

    public RuleConfiguration swapToRuleConfiguration(YamlRuleConfiguration yamlRuleConfig) {
        List<Class<?>> types = Collections.singletonList(yamlRuleConfig.getRuleConfigurationType());
        YamlRuleConfigurationSwapper swapper = YamlRuleConfigurationSwapperFactory.getInstanceMapByRuleConfigurationClasses(types).get(yamlRuleConfig.getRuleConfigurationType());
        return (RuleConfiguration)swapper.swapToObject(yamlRuleConfig);
    }
}

