/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.common.config;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;

public final class DataSourceConfiguration {
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private static final Collection<Class<?>> GENERAL_CLASS_TYPE = Sets.newHashSet((Object[])new Class[]{Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, String.class, Collection.class, List.class});
    private static final Collection<String> SKIPPED_PROPERTY_NAMES = Sets.newHashSet((Object[])new String[]{"loginTimeout"});
    private final String dataSourceClassName;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public static DataSourceConfiguration getDataSourceConfiguration(DataSource dataSource) {
        DataSourceConfiguration result = new DataSourceConfiguration(dataSource.getClass().getName());
        result.getProperties().putAll(DataSourceConfiguration.findAllGetterProperties(dataSource));
        return result;
    }

    private static Map<String, Object> findAllGetterProperties(Object target) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Method each : DataSourceConfiguration.findAllGetterMethods(target.getClass())) {
            String propertyName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, each.getName().substring(GETTER_PREFIX.length()));
            if (!GENERAL_CLASS_TYPE.contains(each.getReturnType()) || SKIPPED_PROPERTY_NAMES.contains(propertyName)) continue;
            result.put(propertyName, each.invoke(target, new Object[0]));
        }
        return result;
    }

    private static Collection<Method> findAllGetterMethods(Class<?> clazz) {
        HashSet<Method> result = new HashSet<Method>();
        for (Method each : clazz.getMethods()) {
            if (!each.getName().startsWith(GETTER_PREFIX) || 0 != each.getParameterTypes().length) continue;
            result.add(each);
        }
        return result;
    }

    public DataSource createDataSource() {
        DataSource result = (DataSource)Class.forName(this.dataSourceClassName).newInstance();
        Method[] methods = result.getClass().getMethods();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Optional<Method> setterMethod;
            if (SKIPPED_PROPERTY_NAMES.contains(entry.getKey()) || !(setterMethod = this.findSetterMethod(methods, entry.getKey())).isPresent()) continue;
            setterMethod.get().invoke((Object)result, entry.getValue());
        }
        return result;
    }

    private Optional<Method> findSetterMethod(Method[] methods, String property) {
        String setterMethodName = Joiner.on((String)"").join((Object)SETTER_PREFIX, (Object)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, property), new Object[0]);
        for (Method each : methods) {
            if (!each.getName().equals(setterMethodName) || 1 != each.getParameterTypes().length) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public boolean equals(Object obj) {
        return this == obj || null != obj && this.getClass() == obj.getClass() && this.equalsByProperties((DataSourceConfiguration)obj);
    }

    private boolean equalsByProperties(DataSourceConfiguration dataSourceConfiguration) {
        if (!this.dataSourceClassName.equals(dataSourceConfiguration.getDataSourceClassName())) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            if (String.valueOf(entry.getValue()).equals(String.valueOf(dataSourceConfiguration.getProperties().get(entry.getKey())))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            stringBuilder.append(entry.getKey()).append(entry.getValue().toString());
        }
        return Objects.hashCode((Object[])new Object[]{this.dataSourceClassName, stringBuilder.toString()});
    }

    public void addAlias(String ... alias) {
        Object value = null;
        for (String each : alias) {
            if (null == this.properties.get(each)) continue;
            value = this.properties.get(each);
        }
        if (null == value) {
            return;
        }
        for (String each : alias) {
            this.properties.put(each, value);
        }
    }

    @Generated
    public DataSourceConfiguration(String dataSourceClassName) {
        this.dataSourceClassName = dataSourceClassName;
    }

    @Generated
    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    @Generated
    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

