/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.broker.filter.ConsumerFilterData;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.filter.ExpressionType;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.filter.FilterFactory;
import org.apache.rocketmq.filter.util.BloomFilter;
import org.apache.rocketmq.filter.util.BloomFilterData;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class ConsumerFilterManager
extends ConfigManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqFilter");
    private static final long MS_24_HOUR = 86400000L;
    private ConcurrentMap<String, FilterDataMapByTopic> filterDataByTopic = new ConcurrentHashMap<String, FilterDataMapByTopic>(256);
    private transient BrokerController brokerController;
    private transient BloomFilter bloomFilter;

    public ConsumerFilterManager() {
        this.bloomFilter = BloomFilter.createByFn((int)20, (int)64);
    }

    public ConsumerFilterManager(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.bloomFilter = BloomFilter.createByFn((int)brokerController.getBrokerConfig().getMaxErrorRateOfBloomFilter(), (int)brokerController.getBrokerConfig().getExpectConsumerNumUseFilter());
        brokerController.getMessageStoreConfig().setBitMapLengthConsumeQueueExt(this.bloomFilter.getM());
    }

    public static ConsumerFilterData build(String topic, String consumerGroup, String expression, String type, long clientVersion) {
        if (ExpressionType.isTagType((String)type)) {
            return null;
        }
        ConsumerFilterData consumerFilterData = new ConsumerFilterData();
        consumerFilterData.setTopic(topic);
        consumerFilterData.setConsumerGroup(consumerGroup);
        consumerFilterData.setBornTime(System.currentTimeMillis());
        consumerFilterData.setDeadTime(0L);
        consumerFilterData.setExpression(expression);
        consumerFilterData.setExpressionType(type);
        consumerFilterData.setClientVersion(clientVersion);
        try {
            consumerFilterData.setCompiledExpression(FilterFactory.INSTANCE.get(type).compile(expression));
        }
        catch (Throwable e) {
            log.error("parse error: expr={}, topic={}, group={}, error={}", new Object[]{expression, topic, consumerGroup, e.getMessage()});
            return null;
        }
        return consumerFilterData;
    }

    public void register(String consumerGroup, Collection<SubscriptionData> subList) {
        for (SubscriptionData subscriptionData : subList) {
            this.register(subscriptionData.getTopic(), consumerGroup, subscriptionData.getSubString(), subscriptionData.getExpressionType(), subscriptionData.getSubVersion());
        }
        Collection<ConsumerFilterData> groupFilterData = this.getByGroup(consumerGroup);
        for (ConsumerFilterData filterData : groupFilterData) {
            boolean exist = false;
            for (SubscriptionData subscriptionData : subList) {
                if (!subscriptionData.getTopic().equals(filterData.getTopic())) continue;
                exist = true;
                break;
            }
            if (exist || filterData.isDead()) continue;
            filterData.setDeadTime(System.currentTimeMillis());
            log.info("Consumer filter changed: {}, make illegal topic dead:{}", (Object)consumerGroup, (Object)filterData);
        }
    }

    public boolean register(String topic, String consumerGroup, String expression, String type, long clientVersion) {
        if (ExpressionType.isTagType((String)type)) {
            return false;
        }
        if (expression == null || expression.length() == 0) {
            return false;
        }
        FilterDataMapByTopic filterDataMapByTopic = (FilterDataMapByTopic)this.filterDataByTopic.get(topic);
        if (filterDataMapByTopic == null) {
            FilterDataMapByTopic temp = new FilterDataMapByTopic(topic);
            FilterDataMapByTopic prev = this.filterDataByTopic.putIfAbsent(topic, temp);
            filterDataMapByTopic = prev != null ? prev : temp;
        }
        BloomFilterData bloomFilterData = this.bloomFilter.generate(consumerGroup + "#" + topic);
        return filterDataMapByTopic.register(consumerGroup, expression, type, bloomFilterData, clientVersion);
    }

    public void unRegister(String consumerGroup) {
        for (String topic : this.filterDataByTopic.keySet()) {
            ((FilterDataMapByTopic)this.filterDataByTopic.get(topic)).unRegister(consumerGroup);
        }
    }

    public ConsumerFilterData get(String topic, String consumerGroup) {
        if (!this.filterDataByTopic.containsKey(topic)) {
            return null;
        }
        if (((FilterDataMapByTopic)this.filterDataByTopic.get(topic)).getGroupFilterData().isEmpty()) {
            return null;
        }
        return (ConsumerFilterData)((FilterDataMapByTopic)this.filterDataByTopic.get(topic)).getGroupFilterData().get(consumerGroup);
    }

    public Collection<ConsumerFilterData> getByGroup(String consumerGroup) {
        HashSet<ConsumerFilterData> ret = new HashSet<ConsumerFilterData>();
        for (FilterDataMapByTopic filterDataMapByTopic : this.filterDataByTopic.values()) {
            for (ConsumerFilterData filterData : filterDataMapByTopic.getGroupFilterData().values()) {
                if (!filterData.getConsumerGroup().equals(consumerGroup)) continue;
                ret.add(filterData);
            }
        }
        return ret;
    }

    public final Collection<ConsumerFilterData> get(String topic) {
        if (!this.filterDataByTopic.containsKey(topic)) {
            return null;
        }
        if (((FilterDataMapByTopic)this.filterDataByTopic.get(topic)).getGroupFilterData().isEmpty()) {
            return null;
        }
        return ((FilterDataMapByTopic)this.filterDataByTopic.get(topic)).getGroupFilterData().values();
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        if (this.brokerController != null) {
            return BrokerPathConfigHelper.getConsumerFilterPath(this.brokerController.getMessageStoreConfig().getStorePathRootDir());
        }
        return BrokerPathConfigHelper.getConsumerFilterPath("./unit_test");
    }

    public void decode(String jsonString) {
        ConsumerFilterManager load = (ConsumerFilterManager)((Object)RemotingSerializable.fromJson((String)jsonString, ConsumerFilterManager.class));
        if (load != null && load.filterDataByTopic != null) {
            boolean bloomChanged = false;
            block2: for (String topic : load.filterDataByTopic.keySet()) {
                FilterDataMapByTopic dataMapByTopic = (FilterDataMapByTopic)load.filterDataByTopic.get(topic);
                if (dataMapByTopic == null) continue;
                for (String group : dataMapByTopic.getGroupFilterData().keySet()) {
                    ConsumerFilterData filterData = (ConsumerFilterData)dataMapByTopic.getGroupFilterData().get(group);
                    if (filterData == null) continue;
                    try {
                        filterData.setCompiledExpression(FilterFactory.INSTANCE.get(filterData.getExpressionType()).compile(filterData.getExpression()));
                    }
                    catch (Exception e) {
                        log.error("load filter data error, " + filterData, (Throwable)e);
                    }
                    if (!this.bloomFilter.isValid(filterData.getBloomFilterData())) {
                        bloomChanged = true;
                        log.info("Bloom filter is changed!So ignore all filter data persisted! {}, {}", (Object)this.bloomFilter, (Object)filterData.getBloomFilterData());
                        continue block2;
                    }
                    log.info("load exist consumer filter data: {}", (Object)filterData);
                    if (filterData.getDeadTime() != 0L) continue;
                    long deadTime = System.currentTimeMillis() - 30000L;
                    filterData.setDeadTime(deadTime <= filterData.getBornTime() ? filterData.getBornTime() : deadTime);
                }
            }
            if (!bloomChanged) {
                this.filterDataByTopic = load.filterDataByTopic;
            }
        }
    }

    public String encode(boolean prettyFormat) {
        this.clean();
        return RemotingSerializable.toJson((Object)((Object)this), (boolean)prettyFormat);
    }

    public void clean() {
        Iterator topicIterator = this.filterDataByTopic.entrySet().iterator();
        while (topicIterator.hasNext()) {
            Map.Entry filterDataMapByTopic = topicIterator.next();
            Iterator filterDataIterator = ((FilterDataMapByTopic)filterDataMapByTopic.getValue()).getGroupFilterData().entrySet().iterator();
            while (filterDataIterator.hasNext()) {
                Map.Entry filterDataByGroup = filterDataIterator.next();
                ConsumerFilterData filterData = (ConsumerFilterData)filterDataByGroup.getValue();
                if (filterData.howLongAfterDeath() < (this.brokerController == null ? 86400000L : this.brokerController.getBrokerConfig().getFilterDataCleanTimeSpan())) continue;
                log.info("Remove filter consumer {}, died too long!", filterDataByGroup.getValue());
                filterDataIterator.remove();
            }
            if (!((FilterDataMapByTopic)filterDataMapByTopic.getValue()).getGroupFilterData().isEmpty()) continue;
            log.info("Topic has no consumer, remove it! {}", filterDataMapByTopic.getKey());
            topicIterator.remove();
        }
    }

    public ConcurrentMap<String, FilterDataMapByTopic> getFilterDataByTopic() {
        return this.filterDataByTopic;
    }

    public void setFilterDataByTopic(ConcurrentHashMap<String, FilterDataMapByTopic> filterDataByTopic) {
        this.filterDataByTopic = filterDataByTopic;
    }

    public static class FilterDataMapByTopic {
        private ConcurrentMap<String, ConsumerFilterData> groupFilterData = new ConcurrentHashMap<String, ConsumerFilterData>();
        private String topic;

        public FilterDataMapByTopic() {
        }

        public FilterDataMapByTopic(String topic) {
            this.topic = topic;
        }

        public void unRegister(String consumerGroup) {
            if (!this.groupFilterData.containsKey(consumerGroup)) {
                return;
            }
            ConsumerFilterData data = (ConsumerFilterData)this.groupFilterData.get(consumerGroup);
            if (data == null || data.isDead()) {
                return;
            }
            long now = System.currentTimeMillis();
            log.info("Unregister consumer filter: {}, deadTime: {}", (Object)data, (Object)now);
            data.setDeadTime(now);
        }

        public boolean register(String consumerGroup, String expression, String type, BloomFilterData bloomFilterData, long clientVersion) {
            boolean change;
            ConsumerFilterData old = (ConsumerFilterData)this.groupFilterData.get(consumerGroup);
            if (old == null) {
                ConsumerFilterData consumerFilterData = ConsumerFilterManager.build(this.topic, consumerGroup, expression, type, clientVersion);
                if (consumerFilterData == null) {
                    return false;
                }
                consumerFilterData.setBloomFilterData(bloomFilterData);
                old = this.groupFilterData.putIfAbsent(consumerGroup, consumerFilterData);
                if (old == null) {
                    log.info("New consumer filter registered: {}", (Object)consumerFilterData);
                    return true;
                }
                if (clientVersion <= old.getClientVersion()) {
                    if (!type.equals(old.getExpressionType()) || !expression.equals(old.getExpression())) {
                        log.warn("Ignore consumer({} : {}) filter(concurrent), because of version {} <= {}, but maybe info changed!old={}:{}, ignored={}:{}", new Object[]{consumerGroup, this.topic, clientVersion, old.getClientVersion(), old.getExpressionType(), old.getExpression(), type, expression});
                    }
                    if (clientVersion == old.getClientVersion() && old.isDead()) {
                        this.reAlive(old);
                        return true;
                    }
                    return false;
                }
                this.groupFilterData.put(consumerGroup, consumerFilterData);
                log.info("New consumer filter registered(concurrent): {}, old: {}", (Object)consumerFilterData, (Object)old);
                return true;
            }
            if (clientVersion <= old.getClientVersion()) {
                if (!type.equals(old.getExpressionType()) || !expression.equals(old.getExpression())) {
                    log.info("Ignore consumer({}:{}) filter, because of version {} <= {}, but maybe info changed!old={}:{}, ignored={}:{}", new Object[]{consumerGroup, this.topic, clientVersion, old.getClientVersion(), old.getExpressionType(), old.getExpression(), type, expression});
                }
                if (clientVersion == old.getClientVersion() && old.isDead()) {
                    this.reAlive(old);
                    return true;
                }
                return false;
            }
            boolean bl = change = !old.getExpression().equals(expression) || !old.getExpressionType().equals(type);
            if (old.getBloomFilterData() == null && bloomFilterData != null) {
                change = true;
            }
            if (old.getBloomFilterData() != null && !old.getBloomFilterData().equals((Object)bloomFilterData)) {
                change = true;
            }
            if (change) {
                ConsumerFilterData consumerFilterData = ConsumerFilterManager.build(this.topic, consumerGroup, expression, type, clientVersion);
                if (consumerFilterData == null) {
                    this.groupFilterData.remove(consumerGroup);
                    return false;
                }
                consumerFilterData.setBloomFilterData(bloomFilterData);
                this.groupFilterData.put(consumerGroup, consumerFilterData);
                log.info("Consumer filter info change, old: {}, new: {}, change: {}", new Object[]{old, consumerFilterData, change});
                return true;
            }
            old.setClientVersion(clientVersion);
            if (old.isDead()) {
                this.reAlive(old);
            }
            return true;
        }

        protected void reAlive(ConsumerFilterData filterData) {
            long oldDeadTime = filterData.getDeadTime();
            filterData.setDeadTime(0L);
            log.info("Re alive consumer filter: {}, oldDeadTime: {}", (Object)filterData, (Object)oldDeadTime);
        }

        public final ConsumerFilterData get(String consumerGroup) {
            return (ConsumerFilterData)this.groupFilterData.get(consumerGroup);
        }

        public final ConcurrentMap<String, ConsumerFilterData> getGroupFilterData() {
            return this.groupFilterData;
        }

        public void setGroupFilterData(ConcurrentHashMap<String, ConsumerFilterData> groupFilterData) {
            this.groupFilterData = groupFilterData;
        }

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }
    }
}

