/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record.emfplus;

import java.io.IOException;
import org.apache.poi.hemf.record.emfplus.HemfPlusRecord;
import org.apache.poi.hemf.record.emfplus.HemfPlusRecordType;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndianInputStream;

@Internal
public class UnimplementedHemfPlusRecord
implements HemfPlusRecord {
    private static final int MAX_RECORD_LENGTH = 1000000;
    private HemfPlusRecordType recordType;
    private int flags;
    private byte[] recordBytes;

    @Override
    public HemfPlusRecordType getEmfPlusRecordType() {
        return this.recordType;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public long init(LittleEndianInputStream leis, long dataSize, long recordId, int flags) throws IOException {
        this.recordType = HemfPlusRecordType.getById(recordId);
        this.flags = flags;
        this.recordBytes = IOUtils.safelyAllocate((long)dataSize, (int)1000000);
        leis.readFully(this.recordBytes);
        return this.recordBytes.length;
    }

    public byte[] getRecordBytes() {
        return this.recordBytes;
    }
}

