/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.booter.SurefireExecutionException;

public class ClasspathConfiguration {
    private static final String CHILD_DELEGATION = "childDelegation";
    private static final String ENABLE_ASSERTIONS = "enableAssertions";
    private static final String CLASSPATH = "classPathUrl.";
    private static final String SUREFIRE_CLASSPATH = "surefireClassPathUrl.";
    private final Classpath classpathUrls;
    private final Classpath surefireClasspathUrls;
    private final Classpath inprocClasspath;
    private final boolean enableAssertions;
    private final boolean childDelegation;

    public ClasspathConfiguration(boolean enableAssertions, boolean childDelegation) {
        this(new Classpath(), new Classpath(), new Classpath(), enableAssertions, childDelegation);
    }

    ClasspathConfiguration(PropertiesWrapper properties) {
        this(properties.getClasspath(CLASSPATH), properties.getClasspath(SUREFIRE_CLASSPATH), new Classpath(), properties.getBooleanProperty(ENABLE_ASSERTIONS), properties.getBooleanProperty(CHILD_DELEGATION));
    }

    public ClasspathConfiguration(Classpath testClasspath, Classpath surefireClassPathUrls, Classpath inprocClasspath, boolean enableAssertions, boolean childDelegation) {
        this.enableAssertions = enableAssertions;
        this.childDelegation = childDelegation;
        this.inprocClasspath = inprocClasspath;
        this.classpathUrls = testClasspath;
        this.surefireClasspathUrls = surefireClassPathUrls;
    }

    public void setForkProperties(PropertiesWrapper properties) {
        properties.setClasspath(CLASSPATH, this.classpathUrls);
        properties.setClasspath(SUREFIRE_CLASSPATH, this.surefireClasspathUrls);
        properties.setProperty(ENABLE_ASSERTIONS, String.valueOf(this.enableAssertions));
        properties.setProperty(CHILD_DELEGATION, String.valueOf(this.childDelegation));
    }

    public ClassLoader createTestClassLoader(boolean childDelegation) throws SurefireExecutionException {
        return this.classpathUrls.createClassLoader(null, childDelegation, this.enableAssertions);
    }

    public ClassLoader createTestClassLoader() throws SurefireExecutionException {
        return this.classpathUrls.createClassLoader(null, this.childDelegation, this.enableAssertions);
    }

    public ClassLoader createSurefireClassLoader(ClassLoader parent) throws SurefireExecutionException {
        return this.surefireClasspathUrls.createClassLoader(parent, false, this.enableAssertions);
    }

    public ClassLoader createInprocSurefireClassLoader(ClassLoader parent) throws SurefireExecutionException {
        return this.inprocClasspath.createClassLoader(parent, false, this.enableAssertions);
    }

    public Classpath getTestClasspath() {
        return this.classpathUrls;
    }

    public ClassLoader createForkingTestClassLoader(boolean manifestOnlyJarRequestedAndUsable) throws SurefireExecutionException {
        if (manifestOnlyJarRequestedAndUsable) {
            System.setProperty("surefire.real.class.path", System.getProperty("java.class.path"));
            this.getTestClasspath().writeToSystemProperty("java.class.path");
            return this.getClass().getClassLoader();
        }
        return this.createTestClassLoader();
    }
}

