/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractRewritePomsPhase;
import org.apache.maven.shared.release.scm.ScmTranslator;
import org.codehaus.plexus.util.StringUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class RewritePomsForReleasePhase
extends AbstractRewritePomsPhase {
    private Map scmTranslators;

    protected void transformScm(MavenProject project, Element rootElement, Namespace namespace, ReleaseDescriptor releaseDescriptor, String projectId, ScmRepository scmRepository, ReleaseResult result, MavenProject rootProject) {
        if (project.getScm() != null) {
            Element scmRoot = rootElement.getChild("scm", namespace);
            if (scmRoot != null) {
                releaseDescriptor.mapOriginalScmInfo(projectId, project.getScm());
                this.translateScm(project, releaseDescriptor, scmRoot, namespace, scmRepository, result, rootProject);
            } else {
                releaseDescriptor.mapOriginalScmInfo(projectId, null);
                MavenProject parent = project.getParent();
                if (parent != null) {
                    String parentId = ArtifactUtils.versionlessKey((String)parent.getGroupId(), (String)parent.getArtifactId());
                    if (!releaseDescriptor.getOriginalScmInfo().containsKey(parentId)) {
                        scmRoot = new Element("scm");
                        scmRoot.addContent("\n  ");
                        if (this.translateScm(project, releaseDescriptor, scmRoot, namespace, scmRepository, result, rootProject)) {
                            rootElement.addContent("\n  ").addContent((Content)scmRoot).addContent("\n");
                        }
                    }
                }
            }
        }
    }

    private boolean translateScm(MavenProject project, ReleaseDescriptor releaseDescriptor, Element scmRoot, Namespace namespace, ScmRepository scmRepository, ReleaseResult relResult, MavenProject rootProject) {
        ScmTranslator translator = (ScmTranslator)this.scmTranslators.get(scmRepository.getProvider());
        boolean result = false;
        if (translator != null) {
            String value;
            String value2;
            String trunkUrl;
            Scm scm = project.getScm();
            String tag = releaseDescriptor.getScmReleaseLabel();
            String tagBase = releaseDescriptor.getScmTagBase();
            String subDirectoryTag = "";
            if (tagBase != null) {
                tagBase = "scm:svn:" + tagBase;
            }
            Scm rootScm = rootProject.getScm();
            if (scm.getConnection() != null) {
                String scmConnectionTag;
                if (rootScm.getConnection() != null && scm.getConnection().indexOf(rootScm.getConnection()) == 0) {
                    subDirectoryTag = scm.getConnection().substring(rootScm.getConnection().length());
                }
                if ((scmConnectionTag = tagBase) != null) {
                    trunkUrl = scm.getDeveloperConnection();
                    if (trunkUrl == null) {
                        trunkUrl = scm.getConnection();
                    }
                    scmConnectionTag = this.translateUrlPath(trunkUrl, tagBase, scm.getConnection());
                }
                if (!(value2 = translator.translateTagUrl(scm.getConnection(), tag + subDirectoryTag, scmConnectionTag)).equals(scm.getConnection())) {
                    this.rewriteElement("connection", value2, scmRoot, namespace);
                    result = true;
                }
            }
            if (scm.getDeveloperConnection() != null) {
                if (rootScm.getDeveloperConnection() != null && scm.getDeveloperConnection().indexOf(rootScm.getDeveloperConnection()) == 0) {
                    subDirectoryTag = scm.getDeveloperConnection().substring(rootScm.getDeveloperConnection().length());
                }
                if (!(value = translator.translateTagUrl(scm.getDeveloperConnection(), tag + subDirectoryTag, tagBase)).equals(scm.getDeveloperConnection())) {
                    this.rewriteElement("developerConnection", value, scmRoot, namespace);
                    result = true;
                }
            }
            if (scm.getUrl() != null) {
                String tagScmUrl;
                if (rootScm.getUrl() != null && scm.getUrl().indexOf(rootScm.getUrl()) == 0) {
                    subDirectoryTag = scm.getUrl().substring(rootScm.getUrl().length());
                }
                if ((tagScmUrl = tagBase) != null) {
                    trunkUrl = scm.getDeveloperConnection();
                    if (trunkUrl == null) {
                        trunkUrl = scm.getConnection();
                    }
                    tagScmUrl = this.translateUrlPath(trunkUrl, tagBase, scm.getUrl());
                }
                if (!(value2 = translator.translateTagUrl(scm.getUrl(), tag + subDirectoryTag, tagScmUrl)).equals(scm.getUrl())) {
                    this.rewriteElement("url", value2, scmRoot, namespace);
                    result = true;
                }
            }
            if (tag != null && (value = translator.resolveTag(tag)) != null && !value.equals(scm.getTag())) {
                this.rewriteElement("tag", value, scmRoot, namespace);
                result = true;
            }
        } else {
            String message = "No SCM translator found - skipping rewrite";
            relResult.appendDebug(message);
            this.getLogger().debug(message);
        }
        return result;
    }

    protected Map getOriginalVersionMap(ReleaseDescriptor releaseDescriptor, List reactorProjects) {
        return releaseDescriptor.getOriginalVersions(reactorProjects);
    }

    protected Map getNextVersionMap(ReleaseDescriptor releaseDescriptor) {
        return releaseDescriptor.getReleaseVersions();
    }

    protected String getResolvedSnapshotVersion(String artifactVersionlessKey, Map resolvedSnapshotsMap) {
        Map versionsMap = (Map)resolvedSnapshotsMap.get(artifactVersionlessKey);
        if (versionsMap != null) {
            return (String)versionsMap.get("rel");
        }
        return null;
    }

    private String translateUrlPath(String trunkPath, String tagPath, String urlPath) {
        int i;
        trunkPath = trunkPath.trim();
        tagPath = tagPath.trim();
        if (trunkPath.endsWith("/")) {
            trunkPath = trunkPath.substring(0, trunkPath.length() - 1);
        }
        if (tagPath.endsWith("/")) {
            tagPath = tagPath.substring(0, tagPath.length() - 1);
        }
        char[] tagPathChars = trunkPath.toCharArray();
        char[] trunkPathChars = tagPath.toCharArray();
        for (i = 0; i < tagPathChars.length && i < trunkPathChars.length && tagPathChars[i] == trunkPathChars[i]; ++i) {
        }
        if (i == 0 || urlPath.indexOf(trunkPath.substring(i)) < 0) {
            return tagPath;
        }
        return StringUtils.replace((String)urlPath, (String)trunkPath.substring(i), (String)tagPath.substring(i));
    }
}

