/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.exec.MavenExecutor;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractRunGoalsPhase
extends AbstractReleasePhase {
    private MavenExecutor mavenExecutor;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, File workingDirectory, String additionalArguments) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        try {
            String goals = this.getGoals(releaseDescriptor);
            if (!StringUtils.isEmpty((String)goals)) {
                this.logInfo(result, "Executing goals '" + goals + "'...");
                this.mavenExecutor.executeGoals(this.determineWorkingDirectory(workingDirectory, releaseDescriptor.getScmRelativePathProjectDirectory()), goals, releaseDescriptor.isInteractive(), additionalArguments, result);
            }
        }
        catch (MavenExecutorException e) {
            throw new ReleaseExecutionException(e.getMessage(), e);
        }
        result.setResultCode(0);
        return result;
    }

    public void setMavenExecutor(MavenExecutor mavenExecutor) {
        this.mavenExecutor = mavenExecutor;
    }

    protected abstract String getGoals(ReleaseDescriptor var1);

    protected File determineWorkingDirectory(File checkoutDirectory, String relativePathProjectDirectory) {
        if (StringUtils.isNotEmpty((String)relativePathProjectDirectory)) {
            return new File(checkoutDirectory, relativePathProjectDirectory);
        }
        return checkoutDirectory;
    }
}

