/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jlink;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractJLinkMojo
extends AbstractMojo {
    @Parameter
    private Map<String, String> jdkToolchain;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ToolchainManager toolchainManager;

    protected String getJLinkExecutable() throws IOException {
        Toolchain tc = this.getToolchain();
        String jLinkExecutable = null;
        if (tc != null) {
            jLinkExecutable = tc.findTool("jlink");
        }
        String jLinkCommand = "jlink" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        if (StringUtils.isNotEmpty((String)jLinkExecutable)) {
            File jLinkExe = new File(jLinkExecutable);
            if (jLinkExe.isDirectory()) {
                jLinkExe = new File(jLinkExe, jLinkCommand);
            }
            if (SystemUtils.IS_OS_WINDOWS && jLinkExe.getName().indexOf(46) < 0) {
                jLinkExe = new File(jLinkExe.getPath() + ".exe");
            }
            if (!jLinkExe.isFile()) {
                throw new IOException("The jlink executable '" + jLinkExe + "' doesn't exist or is not a file.");
            }
            return jLinkExe.getAbsolutePath();
        }
        File jLinkExe = new File(SystemUtils.getJavaHome() + File.separator + ".." + File.separator + "bin", jLinkCommand);
        if (!jLinkExe.exists() || !jLinkExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            String javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).getCanonicalFile().exists() || new File(javaHome).getCanonicalFile().isFile()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            jLinkExe = new File(javaHome + File.separator + "bin", jLinkCommand);
        }
        if (!jLinkExe.getCanonicalFile().exists() || !jLinkExe.getCanonicalFile().isFile()) {
            throw new IOException("The jlink executable '" + jLinkExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return jLinkExe.getAbsolutePath();
    }

    protected void executeCommand(Commandline cmd, File outputDirectory) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)CommandLineUtils.toString((String[])cmd.getCommandline()).replaceAll("'", ""));
        }
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        try {
            String output;
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
            String string = output = StringUtils.isEmpty((String)out.getOutput()) ? null : '\n' + out.getOutput().trim();
            if (exitCode != 0) {
                if (StringUtils.isNotEmpty(output)) {
                    this.getLog().error((CharSequence)output);
                }
                StringBuilder msg = new StringBuilder("\nExit code: ");
                msg.append(exitCode);
                if (StringUtils.isNotEmpty((String)err.getOutput())) {
                    msg.append(" - ").append(err.getOutput());
                }
                msg.append('\n');
                msg.append("Command line was: ").append(cmd).append('\n').append('\n');
                throw new MojoExecutionException(msg.toString());
            }
            if (StringUtils.isNotEmpty(output)) {
                this.getLog().info((CharSequence)output);
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute jlink command: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.jdkToolchain != null) {
            try {
                Method getToolchainsMethod = this.toolchainManager.getClass().getMethod("getToolchains", MavenSession.class, String.class, Map.class);
                List tcs = (List)getToolchainsMethod.invoke((Object)this.toolchainManager, this.session, "jdk", this.jdkToolchain);
                if (tcs != null && tcs.size() > 0) {
                    tc = (Toolchain)tcs.get(0);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        if (tc == null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected MavenSession getSession() {
        return this.session;
    }

    protected File getArchiveFile(File basedir, String finalName, String classifier, String archiveExt) {
        if (basedir == null) {
            throw new IllegalArgumentException("basedir is not allowed to be null");
        }
        if (finalName == null) {
            throw new IllegalArgumentException("finalName is not allowed to be null");
        }
        if (archiveExt == null) {
            throw new IllegalArgumentException("archiveExt is not allowed to be null");
        }
        if (finalName.isEmpty()) {
            throw new IllegalArgumentException("finalName is not allowed to be empty.");
        }
        if (archiveExt.isEmpty()) {
            throw new IllegalArgumentException("archiveExt is not allowed to be empty.");
        }
        StringBuilder fileName = new StringBuilder(finalName);
        if (this.hasClassifier(classifier)) {
            fileName.append("-").append(classifier);
        }
        fileName.append('.');
        fileName.append(archiveExt);
        return new File(basedir, fileName.toString());
    }

    protected boolean hasClassifier(String classifier) {
        boolean result = false;
        if (classifier != null && classifier.trim().length() > 0) {
            result = true;
        }
        return result;
    }

    protected StringBuilder convertSeparatedModulePathToPlatformSeparatedModulePath(String pluginModulePath) {
        String[] splitModule;
        StringBuilder sb = new StringBuilder();
        for (String module : splitModule = pluginModulePath.split("[;:]")) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(module);
        }
        return sb;
    }

    protected String getPlatformDependSeparateList(List<String> modulePaths) {
        StringBuilder sb = new StringBuilder();
        for (String module : modulePaths) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(module);
        }
        return sb.toString();
    }

    protected String getCommaSeparatedList(List<String> modules) {
        StringBuilder sb = new StringBuilder();
        for (String module : modules) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(module);
        }
        return sb.toString();
    }
}

