/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.enforcer.util;

import java.util.Iterator;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;

public class EnforcerUtils {
    public static synchronized boolean containsVersion(VersionRange allowedRange, ArtifactVersion theVersion) {
        boolean matched = false;
        ArtifactVersion recommendedVersion = allowedRange.getRecommendedVersion();
        if (recommendedVersion == null) {
            Iterator i = allowedRange.getRestrictions().iterator();
            while (i.hasNext() && !matched) {
                Restriction restriction = (Restriction)i.next();
                if (!restriction.containsVersion(theVersion)) continue;
                matched = true;
            }
        } else {
            int compareTo = recommendedVersion.compareTo(theVersion);
            matched = compareTo <= 0;
        }
        return matched;
    }
}

