/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.enforcer;

import org.apache.maven.shared.enforcer.rule.api.EnforcerRule;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRuleHelper;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RequireProperty
implements EnforcerRule {
    public String property = null;
    public String message = null;
    public String regex = null;
    public String regexMessage = null;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Object propValue = null;
        try {
            propValue = helper.evaluate("${" + this.property + "}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to evaluate property: " + this.property, (Exception)((Object)eee));
        }
        if (propValue == null) {
            if (this.message == null) {
                this.message = "Property \"" + this.property + "\" is required for this build.";
            }
            throw new EnforcerRuleException(this.message);
        }
        if (this.regex != null && !propValue.toString().matches(this.regex)) {
            if (this.regexMessage == null) {
                this.regexMessage = "Property \"" + this.property + "\" evaluates to \"" + propValue + "\".  " + "This does not match the regular expression \"" + this.regex + "\"";
            }
            throw new EnforcerRuleException(this.regexMessage);
        }
    }
}

