/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.enforcer;

import bsh.EvalError;
import bsh.Interpreter;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRule;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.shared.enforcer.rule.api.EnforcerRuleHelper;
import org.codehaus.plexus.util.StringUtils;

public class EvaluateBeanshell
implements EnforcerRule {
    private static final Interpreter bsh = new Interpreter();
    public String condition;
    public String message;
    static /* synthetic */ Class class$org$apache$maven$artifact$resolver$ArtifactResolver;
    static /* synthetic */ Class class$org$apache$maven$execution$RuntimeInformation;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            MavenSession session = (MavenSession)helper.evaluate("${session}");
            String target = (String)helper.evaluate("${project.build.directory}");
            String artifactId = (String)helper.evaluate("${project.artifactId}");
            ArtifactResolver resolver = (ArtifactResolver)helper.getComponent(class$org$apache$maven$artifact$resolver$ArtifactResolver == null ? (class$org$apache$maven$artifact$resolver$ArtifactResolver = EvaluateBeanshell.class$("org.apache.maven.artifact.resolver.ArtifactResolver")) : class$org$apache$maven$artifact$resolver$ArtifactResolver);
            RuntimeInformation rti = (RuntimeInformation)helper.getComponent(class$org$apache$maven$execution$RuntimeInformation == null ? (class$org$apache$maven$execution$RuntimeInformation = EvaluateBeanshell.class$("org.apache.maven.execution.RuntimeInformation")) : class$org$apache$maven$execution$RuntimeInformation);
            log.debug((CharSequence)("Retrieved Target Folder: " + target));
            log.debug((CharSequence)("Retrieved ArtifactId: " + artifactId));
            log.debug((CharSequence)("Retrieved Project: " + project));
            log.debug((CharSequence)("Retrieved RuntimeInfo: " + rti));
            log.debug((CharSequence)("Retrieved Session: " + session));
            log.debug((CharSequence)("Retrieved Resolver: " + resolver));
            log.debug((CharSequence)("Echo condition : " + this.condition));
            String script = (String)helper.evaluate(this.condition);
            log.debug((CharSequence)("Echo script : " + script));
            if (!this.evaluateCondition(script, log)) {
                if (StringUtils.isEmpty((String)this.message)) {
                    this.message = "The expression \"" + this.condition + "\" is not true.";
                }
                throw new EnforcerRuleException(this.message);
            }
        }
        catch (Exception e) {
            throw new EnforcerRuleException("Unable to lookup a component", e);
        }
    }

    protected boolean evaluateCondition(String script, Log log) {
        Boolean evaluation = Boolean.FALSE;
        try {
            evaluation = (Boolean)bsh.eval(script);
            log.debug((CharSequence)("Echo evaluating : " + evaluation));
        }
        catch (EvalError ex) {
            log.warn((CharSequence)("Couldn't evaluate condition: " + script), (Throwable)ex);
        }
        return evaluation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

