/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.AbstractStoreSupplier;
import org.apache.kafka.streams.state.internals.CachingSessionStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.MeteredSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBSessionStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.WindowStoreSupplier;

public class RocksDBSessionStoreSupplier<K, V>
extends AbstractStoreSupplier<K, V, SessionStore>
implements WindowStoreSupplier<SessionStore> {
    private static final int NUM_SEGMENTS = 3;
    public static final String METRIC_SCOPE = "rocksdb-session-store";
    private final long retentionPeriod;
    private final boolean cached;

    public RocksDBSessionStoreSupplier(String name, long retentionPeriod, Serde<K> keySerde, Serde<V> valueSerde, boolean logged, Map<String, String> logConfig, boolean cached) {
        super(name, keySerde, valueSerde, Time.SYSTEM, logged, logConfig);
        this.retentionPeriod = retentionPeriod;
        this.cached = cached;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public SessionStore<K, V> get() {
        SessionKeySchema keySchema = new SessionKeySchema();
        RocksDBSegmentedBytesStore segmented = new RocksDBSegmentedBytesStore(this.name, this.retentionPeriod, 3, keySchema);
        if (this.cached && this.logged) {
            ChangeLoggingSegmentedBytesStore logged = new ChangeLoggingSegmentedBytesStore(segmented);
            MeteredSegmentedBytesStore metered = new MeteredSegmentedBytesStore(logged, METRIC_SCOPE, this.time);
            RocksDBSessionStore<Bytes, byte[]> sessionStore = new RocksDBSessionStore<Bytes, byte[]>(metered, Serdes.Bytes(), Serdes.ByteArray());
            return new CachingSessionStore(sessionStore, this.keySerde, this.valueSerde);
        }
        if (this.cached) {
            MeteredSegmentedBytesStore metered = new MeteredSegmentedBytesStore(segmented, METRIC_SCOPE, this.time);
            RocksDBSessionStore<Bytes, byte[]> sessionStore = new RocksDBSessionStore<Bytes, byte[]>(metered, Serdes.Bytes(), Serdes.ByteArray());
            return new CachingSessionStore(sessionStore, this.keySerde, this.valueSerde);
        }
        if (this.logged) {
            ChangeLoggingSegmentedBytesStore logged = new ChangeLoggingSegmentedBytesStore(segmented);
            MeteredSegmentedBytesStore metered = new MeteredSegmentedBytesStore(logged, METRIC_SCOPE, this.time);
            return new RocksDBSessionStore(metered, this.keySerde, this.valueSerde);
        }
        return new RocksDBSessionStore(new MeteredSegmentedBytesStore(segmented, METRIC_SCOPE, this.time), this.keySerde, this.valueSerde);
    }

    @Override
    public long retentionPeriod() {
        return this.retentionPeriod;
    }
}

