/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.LinkedList;
import org.apache.kafka.streams.processor.internals.Stamped;
import org.apache.kafka.streams.processor.internals.TimestampTracker;

public class MinTimestampTracker<E>
implements TimestampTracker<E> {
    private final LinkedList<Stamped<E>> descendingSubsequence = new LinkedList();
    private long lastKnownTime = -1L;

    @Override
    public void addElement(Stamped<E> elem) {
        if (elem == null) {
            throw new NullPointerException();
        }
        Stamped<E> minElem = this.descendingSubsequence.peekLast();
        while (minElem != null && minElem.timestamp >= elem.timestamp) {
            this.descendingSubsequence.removeLast();
            minElem = this.descendingSubsequence.peekLast();
        }
        this.descendingSubsequence.offerLast(elem);
    }

    @Override
    public void removeElement(Stamped<E> elem) {
        if (elem == null) {
            return;
        }
        if (this.descendingSubsequence.peekFirst() == elem) {
            this.descendingSubsequence.removeFirst();
        }
        if (this.descendingSubsequence.isEmpty()) {
            this.lastKnownTime = elem.timestamp;
        }
    }

    @Override
    public int size() {
        return this.descendingSubsequence.size();
    }

    @Override
    public long get() {
        Stamped<E> stamped = this.descendingSubsequence.peekFirst();
        if (stamped == null) {
            return this.lastKnownTime;
        }
        return stamped.timestamp;
    }
}

