/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractTask.class);
    protected final TaskId id;
    protected final String applicationId;
    protected final ProcessorTopology topology;
    protected final Consumer consumer;
    protected final ProcessorStateManager stateMgr;
    protected final Set<TopicPartition> partitions;
    protected InternalProcessorContext processorContext;
    protected final ThreadCache cache;

    protected AbstractTask(TaskId id, String applicationId, Collection<TopicPartition> partitions, ProcessorTopology topology, Consumer<byte[], byte[]> consumer, Consumer<byte[], byte[]> restoreConsumer, boolean isStandby, StateDirectory stateDirectory, ThreadCache cache) {
        this.id = id;
        this.applicationId = applicationId;
        this.partitions = new HashSet<TopicPartition>(partitions);
        this.topology = topology;
        this.consumer = consumer;
        this.cache = cache;
        try {
            this.stateMgr = new ProcessorStateManager(id, partitions, restoreConsumer, isStandby, stateDirectory, topology.storeToChangelogTopic());
        }
        catch (IOException e) {
            throw new ProcessorStateException(String.format("task [%s] Error while creating the state manager", id), e);
        }
    }

    protected void initializeStateStores() {
        this.initializeOffsetLimits();
        for (StateStore store : this.topology.stateStores()) {
            log.trace("task [{}] Initializing store {}", (Object)this.id(), (Object)store.name());
            store.init(this.processorContext, store);
        }
    }

    public final TaskId id() {
        return this.id;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final Set<TopicPartition> partitions() {
        return this.partitions;
    }

    public final ProcessorTopology topology() {
        return this.topology;
    }

    public final ProcessorContext context() {
        return this.processorContext;
    }

    public final ThreadCache cache() {
        return this.cache;
    }

    public abstract void commit();

    public abstract void close();

    public abstract void initTopology();

    public abstract void closeTopology();

    public abstract void commitOffsets();

    void closeStateManager(boolean writeCheckpoint) {
        log.trace("task [{}] Closing", (Object)this.id());
        try {
            this.stateMgr.close(writeCheckpoint ? this.recordCollectorOffsets() : null);
        }
        catch (IOException e) {
            throw new ProcessorStateException("Error while closing the state manager", e);
        }
    }

    protected Map<TopicPartition, Long> recordCollectorOffsets() {
        return Collections.emptyMap();
    }

    protected void initializeOffsetLimits() {
        for (TopicPartition partition : this.partitions) {
            try {
                OffsetAndMetadata metadata = this.consumer.committed(partition);
                this.stateMgr.putOffsetLimit(partition, metadata != null ? metadata.offset() : 0L);
            }
            catch (AuthorizationException e) {
                throw new ProcessorStateException(String.format("task [%s] AuthorizationException when initializing offsets for %s", this.id, partition), e);
            }
            catch (WakeupException e) {
                throw e;
            }
            catch (KafkaException e) {
                throw new ProcessorStateException(String.format("task [%s] Failed to initialize offsets for %s", this.id, partition), e);
            }
        }
    }

    public StateStore getStore(String name) {
        return this.stateMgr.getStore(name);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder(indent + "StreamsTask taskId: " + this.id() + "\n");
        if (this.topology != null) {
            sb.append(indent).append(this.topology.toString(indent + "\t"));
        }
        if (this.partitions != null && !this.partitions.isEmpty()) {
            sb.append(indent).append("Partitions [");
            for (TopicPartition topicPartition : this.partitions) {
                sb.append(topicPartition.toString()).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("]\n");
        }
        return sb.toString();
    }

    public void flushState() {
        this.stateMgr.flush((InternalProcessorContext)this.context());
    }
}

