/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.http.parser.BaseParser;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.protocol.http.parser.URLString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTMLParser
extends BaseParser {
    private static final Logger log = LoggerFactory.getLogger(HTMLParser.class);
    protected static final String ATT_BACKGROUND = "background";
    protected static final String ATT_CODE = "code";
    protected static final String ATT_CODEBASE = "codebase";
    protected static final String ATT_DATA = "data";
    protected static final String ATT_HREF = "href";
    protected static final String ATT_REL = "rel";
    protected static final String ATT_SRC = "src";
    protected static final String ATT_STYLE = "style";
    protected static final String ATT_TYPE = "type";
    protected static final String ATT_IS_IMAGE = "image";
    protected static final String TAG_APPLET = "applet";
    protected static final String TAG_BASE = "base";
    protected static final String TAG_BGSOUND = "bgsound";
    protected static final String TAG_BODY = "body";
    protected static final String TAG_EMBED = "embed";
    protected static final String TAG_FRAME = "frame";
    protected static final String TAG_IFRAME = "iframe";
    protected static final String TAG_IMAGE = "img";
    protected static final String TAG_INPUT = "input";
    protected static final String TAG_LINK = "link";
    protected static final String TAG_OBJECT = "object";
    protected static final String TAG_SCRIPT = "script";
    protected static final String STYLESHEET = "stylesheet";
    protected static final String SHORTCUT_ICON = "shortcut icon";
    protected static final String ICON = "icon";
    protected static final String IE_UA = "MSIE ([0-9]+.[0-9]+)";
    protected static final Pattern IE_UA_PATTERN = Pattern.compile("MSIE ([0-9]+.[0-9]+)");
    private static final float IE_10 = 10.0f;
    public static final String PARSER_CLASSNAME = "htmlParser.className";
    public static final String DEFAULT_PARSER = "org.apache.jmeter.protocol.http.parser.LagartoBasedHtmlParser";
    private static final Pattern NORMALIZE_URL_PATTERN = Pattern.compile("[\n\r\b\f]+");

    protected HTMLParser() {
    }

    @Override
    public Iterator<URL> getEmbeddedResourceURLs(String userAgent, byte[] html, URL baseUrl, String encoding) throws HTMLParseException {
        LinkedHashSet<URLString> col = new LinkedHashSet<URLString>();
        return this.getEmbeddedResourceURLs(userAgent, html, baseUrl, new URLCollection(col), encoding);
    }

    public abstract Iterator<URL> getEmbeddedResourceURLs(String var1, byte[] var2, URL var3, URLCollection var4, String var5) throws HTMLParseException;

    public Iterator<URL> getEmbeddedResourceURLs(String userAgent, byte[] html, URL baseUrl, Collection<URLString> coll, String encoding) throws HTMLParseException {
        return this.getEmbeddedResourceURLs(userAgent, html, baseUrl, new URLCollection(coll), encoding);
    }

    protected final boolean isEnableConditionalComments(Float ieVersion) {
        return ieVersion != null && ieVersion.floatValue() < 10.0f;
    }

    protected Float extractIEVersion(String userAgent) {
        if (StringUtils.isEmpty((CharSequence)userAgent)) {
            log.info("userAgent is null");
            return null;
        }
        Matcher matcher = IE_UA_PATTERN.matcher(userAgent);
        String ieVersion = null;
        if (matcher.find()) {
            ieVersion = matcher.groupCount() > 0 ? matcher.group(1) : matcher.group();
        }
        if (ieVersion != null) {
            return Float.valueOf(ieVersion);
        }
        return null;
    }

    protected static String normalizeUrlValue(CharSequence url) {
        String trimmed;
        if (!StringUtils.isEmpty((CharSequence)url) && !(trimmed = NORMALIZE_URL_PATTERN.matcher(url.toString().trim()).replaceAll("")).isEmpty()) {
            return trimmed;
        }
        return null;
    }
}

