/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServlet;

public class ThriftHttpServlet
extends TServlet {
    private static final long serialVersionUID = 1L;
    public static final Log LOG = LogFactory.getLog((String)ThriftHttpServlet.class.getName());

    public ThriftHttpServlet(TProcessor processor, TProtocolFactory protocolFactory) {
        super(processor, protocolFactory);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logRequestHeader(request);
        super.doPost(request, response);
    }

    protected void logRequestHeader(HttpServletRequest request) {
        String authHeaderBase64 = request.getHeader("Authorization");
        if (authHeaderBase64 == null) {
            LOG.warn((Object)"ThriftHttpServlet: no HTTP Authorization header");
        } else if (!authHeaderBase64.startsWith("Basic")) {
            LOG.warn((Object)"ThriftHttpServlet: HTTP Authorization header exists but is not Basic.");
        } else if (LOG.isDebugEnabled()) {
            String authHeaderBase64_Payload = authHeaderBase64.substring("Basic ".length());
            String authHeaderString = StringUtils.newStringUtf8((byte[])Base64.decodeBase64((byte[])authHeaderBase64_Payload.getBytes()));
            String[] creds = authHeaderString.split(":");
            String username = null;
            String password = null;
            if (creds.length >= 1) {
                username = creds[0];
            }
            if (creds.length >= 2) {
                password = creds[1];
            }
            password = password == null || password.equals("null") || password.equals("") ? "<no password>" : "******";
            LOG.debug((Object)("HttpServlet:  HTTP Authorization header:: username=" + username + " password=" + password));
        }
    }
}

