/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.serde2.typeinfo.BaseTypeParams;
import org.apache.hive.service.cli.thrift.TTypeQualifierValue;
import org.apache.hive.service.cli.thrift.TTypeQualifiers;

public class TypeQualifiers {
    private Integer characterMaximumLength;

    public Integer getCharacterMaximumLength() {
        return this.characterMaximumLength;
    }

    public void setCharacterMaximumLength(int characterMaximumLength) {
        this.characterMaximumLength = characterMaximumLength;
    }

    public TTypeQualifiers toTTypeQualifiers() {
        TTypeQualifiers ret = null;
        HashMap<String, TTypeQualifierValue> qMap = new HashMap<String, TTypeQualifierValue>();
        if (this.getCharacterMaximumLength() != null) {
            TTypeQualifierValue val = new TTypeQualifierValue();
            val.setI32Value(this.getCharacterMaximumLength());
            qMap.put("characterMaximumLength", val);
        }
        if (qMap.size() > 0) {
            ret = new TTypeQualifiers(qMap);
        }
        return ret;
    }

    public static TypeQualifiers fromTTypeQualifiers(TTypeQualifiers ttq) {
        TypeQualifiers ret = null;
        if (ttq != null) {
            ret = new TypeQualifiers();
            Map<String, TTypeQualifierValue> tqMap = ttq.getQualifiers();
            if (tqMap.containsKey("characterMaximumLength")) {
                ret.setCharacterMaximumLength(tqMap.get("characterMaximumLength").getI32Value());
            }
        }
        return ret;
    }

    public static TypeQualifiers fromBaseTypeParams(BaseTypeParams typeParams) {
        TypeQualifiers ret = null;
        if (typeParams != null) {
            ret = new TypeQualifiers();
            if (typeParams.hasCharacterMaximumLength()) {
                ret.setCharacterMaximumLength(typeParams.getCharacterMaximumLength());
            }
        }
        return ret;
    }
}

