/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.util.List;
import org.apache.hadoop.hive.serde2.typeinfo.BaseTypeParams;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hive.service.cli.Type;
import org.apache.hive.service.cli.TypeQualifiers;
import org.apache.hive.service.cli.thrift.TPrimitiveTypeEntry;
import org.apache.hive.service.cli.thrift.TTypeDesc;
import org.apache.hive.service.cli.thrift.TTypeEntry;

public class TypeDescriptor {
    private final Type type;
    private String typeName = null;
    private TypeQualifiers typeQualifiers = null;

    public TypeDescriptor(Type type) {
        this.type = type;
    }

    public TypeDescriptor(TTypeDesc tTypeDesc) {
        List<TTypeEntry> tTypeEntries = tTypeDesc.getTypes();
        TPrimitiveTypeEntry top = tTypeEntries.get(0).getPrimitiveEntry();
        this.type = Type.getType(top.getType());
        if (top.isSetTypeQualifiers()) {
            this.setTypeQualifiers(TypeQualifiers.fromTTypeQualifiers(top.getTypeQualifiers()));
        }
    }

    public TypeDescriptor(String typeName) {
        TypeInfo pti;
        BaseTypeParams typeParams;
        this.type = Type.getType(typeName);
        if (this.type.isComplexType()) {
            this.typeName = typeName;
        } else if (this.type.isQualifiedType() && (typeParams = ((PrimitiveTypeInfo)(pti = TypeInfoFactory.getPrimitiveTypeInfo((String)typeName))).getTypeParams()) != null) {
            this.setTypeQualifiers(TypeQualifiers.fromBaseTypeParams(typeParams));
        }
    }

    public Type getType() {
        return this.type;
    }

    public TTypeDesc toTTypeDesc() {
        TPrimitiveTypeEntry primitiveEntry = new TPrimitiveTypeEntry(this.type.toTType());
        if (this.getTypeQualifiers() != null) {
            primitiveEntry.setTypeQualifiers(this.getTypeQualifiers().toTTypeQualifiers());
        }
        TTypeEntry entry = TTypeEntry.primitiveEntry(primitiveEntry);
        TTypeDesc desc = new TTypeDesc();
        desc.addToTypes(entry);
        return desc;
    }

    public String getTypeName() {
        if (this.typeName != null) {
            return this.typeName;
        }
        return this.type.getName();
    }

    public TypeQualifiers getTypeQualifiers() {
        return this.typeQualifiers;
    }

    public void setTypeQualifiers(TypeQualifiers typeQualifiers) {
        this.typeQualifiers = typeQualifiers;
    }
}

