/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.util.Map;
import javax.security.sasl.SaslException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.transport.TTransport;

public class KerberosSaslHelper {
    public static TProcessorFactory getKerberosProcessorFactory(HadoopThriftAuthBridge.Server saslServer, ThriftCLIService service) {
        return new CLIServiceProcessorFactory(saslServer, service);
    }

    public static TTransport getKerberosTransport(String principal, String host, TTransport underlyingTransport, Map<String, String> saslProps) throws SaslException {
        try {
            String[] names = principal.split("[/@]");
            if (names.length != 3) {
                throw new IllegalArgumentException("Kerberos principal should have 3 parts: " + principal);
            }
            HadoopThriftAuthBridge.Client authBridge = ShimLoader.getHadoopThriftAuthBridge().createClientWithConf("kerberos");
            return authBridge.createClientTransport(principal, host, "KERBEROS", null, underlyingTransport, saslProps);
        }
        catch (IOException e) {
            throw new SaslException("Failed to open client transport", e);
        }
    }

    private static class CLIServiceProcessorFactory
    extends TProcessorFactory {
        private final ThriftCLIService service;
        private final HadoopThriftAuthBridge.Server saslServer;

        public CLIServiceProcessorFactory(HadoopThriftAuthBridge.Server saslServer, ThriftCLIService service) {
            super(null);
            this.service = service;
            this.saslServer = saslServer;
        }

        public TProcessor getProcessor(TTransport trans) {
            TCLIService.Processor<ThriftCLIService> sqlProcessor = new TCLIService.Processor<ThriftCLIService>(this.service);
            return this.saslServer.wrapNonAssumingProcessor(sqlProcessor);
        }
    }
}

