/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeType;
import org.apache.hadoop.hive.ql.session.SessionState;

public class PrivilegeRegistry {
    protected static Map<PrivilegeType, Privilege> Registry = null;
    protected static Map<PrivilegeType, Privilege> RegistryV2 = null;

    public static Privilege getPrivilege(PrivilegeType privilegeType) {
        return Registry.get((Object)privilegeType);
    }

    public static Privilege getPrivilege(int privilegeToken) {
        PrivilegeType ptype = PrivilegeType.getPrivTypeByToken(privilegeToken);
        return PrivilegeRegistry.getPrivilegeFromRegistry(ptype);
    }

    public static Privilege getPrivilege(String privilegeName) {
        PrivilegeType ptype = PrivilegeType.getPrivTypeByName(privilegeName);
        return PrivilegeRegistry.getPrivilegeFromRegistry(ptype);
    }

    private static Privilege getPrivilegeFromRegistry(PrivilegeType ptype) {
        return SessionState.get().isAuthorizationModeV2() ? RegistryV2.get((Object)ptype) : Registry.get((Object)ptype);
    }

    static {
        Registry = new HashMap<PrivilegeType, Privilege>();
        Registry.put(Privilege.ALL.getPriv(), Privilege.ALL);
        Registry.put(Privilege.ALTER_DATA.getPriv(), Privilege.ALTER_DATA);
        Registry.put(Privilege.ALTER_METADATA.getPriv(), Privilege.ALTER_METADATA);
        Registry.put(Privilege.CREATE.getPriv(), Privilege.CREATE);
        Registry.put(Privilege.DROP.getPriv(), Privilege.DROP);
        Registry.put(Privilege.LOCK.getPriv(), Privilege.LOCK);
        Registry.put(Privilege.SELECT.getPriv(), Privilege.SELECT);
        Registry.put(Privilege.SHOW_DATABASE.getPriv(), Privilege.SHOW_DATABASE);
        RegistryV2 = new HashMap<PrivilegeType, Privilege>();
        RegistryV2.putAll(Registry);
        RegistryV2.put(Privilege.INSERT.getPriv(), Privilege.INSERT);
        RegistryV2.put(Privilege.DELETE.getPriv(), Privilege.DELETE);
    }
}

