/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplePruner
extends Transform {
    private static final Logger LOG = LoggerFactory.getLogger("hive.ql.optimizer.SamplePruner");

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        SamplePrunerCtx samplePrunerCtx = new SamplePrunerCtx(pctx.getOpToSamplePruner());
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", "(" + TableScanOperator.getOperatorName() + "%" + FilterOperator.getOperatorName() + "%" + FilterOperator.getOperatorName() + "%|" + TableScanOperator.getOperatorName() + "%" + FilterOperator.getOperatorName() + "%)"), SamplePruner.getFilterProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(SamplePruner.getDefaultProc(), opRules, samplePrunerCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    public static NodeProcessor getFilterProc() {
        return new FilterPPR();
    }

    public static NodeProcessor getDefaultProc() {
        return new DefaultPPR();
    }

    public static Path[] prune(Partition part, FilterDesc.SampleDesc sampleDescr) throws SemanticException {
        int num = sampleDescr.getNumerator();
        int den = sampleDescr.getDenominator();
        int bucketCount = part.getBucketCount();
        String fullScanMsg = "";
        if (sampleDescr.getInputPruning()) {
            LOG.trace("numerator = " + num);
            LOG.trace("denominator = " + den);
            LOG.trace("bucket count = " + bucketCount);
            if (bucketCount == den) {
                Path[] ret = new Path[]{part.getBucketPath(num - 1)};
                return ret;
            }
            if (bucketCount > den && bucketCount % den == 0) {
                int numPathsInSample = bucketCount / den;
                Path[] ret = new Path[numPathsInSample];
                for (int i = 0; i < numPathsInSample; ++i) {
                    ret[i] = part.getBucketPath(i * den + num - 1);
                }
                return ret;
            }
            if (bucketCount < den && den % bucketCount == 0) {
                Path[] ret = new Path[]{part.getBucketPath((num - 1) % bucketCount)};
                return ret;
            }
            fullScanMsg = "Tablesample denominator " + den + " is not multiple/divisor of bucket count " + bucketCount + " of table " + part.getTable().getTableName();
        } else {
            fullScanMsg = "Tablesample not on clustered columns";
        }
        LOG.warn(fullScanMsg + ", using full table scan");
        Path[] ret = part.getPath();
        return ret;
    }

    public static AddPathReturnStatus addPath(FileSystem fs, String pathPattern, long sizeLeft, int fileLimit, Collection<Path> retPathList) throws IOException {
        LOG.info("Path pattern = " + pathPattern);
        Object[] srcs = fs.globStatus(new Path(pathPattern));
        Arrays.sort(srcs);
        boolean hasFile = false;
        boolean allFile = true;
        for (Object src : srcs) {
            if (sizeLeft <= 0L) {
                allFile = false;
                break;
            }
            if (src.isDir()) {
                LOG.info("Got directory: " + src.getPath());
                AddPathReturnStatus ret = SamplePruner.addPath(fs, src.getPath().toString() + "/*", sizeLeft, fileLimit, retPathList);
                if (ret == null) {
                    return null;
                }
                sizeLeft = ret.sizeLeft;
                hasFile |= ret.hasFile;
                allFile &= ret.allFile;
                continue;
            }
            LOG.info("Got file: " + src.getPath());
            hasFile = true;
            retPathList.add(src.getPath());
            if (retPathList.size() < fileLimit || (sizeLeft -= src.getLen()) <= 0L) continue;
            return null;
        }
        return new AddPathReturnStatus(hasFile, allFile, sizeLeft);
    }

    public static LimitPruneRetStatus limitPrune(Partition part, long sizeLimit, int fileLimit, Collection<Path> retPathList) throws SemanticException {
        try {
            FileSystem fs = part.getDataLocation().getFileSystem((Configuration)Hive.get().getConf());
            String pathPattern = part.getDataLocation().toString() + "/*";
            AddPathReturnStatus ret = SamplePruner.addPath(fs, pathPattern, sizeLimit, fileLimit, retPathList);
            if (ret == null) {
                return LimitPruneRetStatus.NotQualify;
            }
            if (!ret.hasFile) {
                return LimitPruneRetStatus.NoFile;
            }
            if (ret.sizeLeft > 0L) {
                return LimitPruneRetStatus.NotQualify;
            }
            if (ret.allFile) {
                return LimitPruneRetStatus.NeedAllFiles;
            }
            return LimitPruneRetStatus.NeedSomeFiles;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get path", e);
        }
    }

    public static enum LimitPruneRetStatus {
        NoFile,
        NeedAllFiles,
        NeedSomeFiles,
        NotQualify;

    }

    public static class AddPathReturnStatus {
        public boolean hasFile;
        public boolean allFile;
        public long sizeLeft;

        public AddPathReturnStatus(boolean hasFile, boolean allFile, long sizeLeft) {
            this.hasFile = hasFile;
            this.allFile = allFile;
            this.sizeLeft = sizeLeft;
        }
    }

    public static class DefaultPPR
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    public static class FilterPPR
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator filOp = (FilterOperator)nd;
            FilterDesc filOpDesc = (FilterDesc)filOp.getConf();
            FilterDesc.SampleDesc sampleDescr = filOpDesc.getSampleDescr();
            if (sampleDescr == null || !sampleDescr.getInputPruning()) {
                return null;
            }
            assert (stack.size() == 3 && stack.get(1) instanceof FilterOperator || stack.size() == 2);
            TableScanOperator tsOp = (TableScanOperator)stack.get(0);
            ((SamplePrunerCtx)procCtx).getOpToSamplePruner().put(tsOp, sampleDescr);
            return null;
        }
    }

    public static class SamplePrunerCtx
    implements NodeProcessorCtx {
        HashMap<TableScanOperator, FilterDesc.SampleDesc> opToSamplePruner;

        public SamplePrunerCtx(HashMap<TableScanOperator, FilterDesc.SampleDesc> opToSamplePruner) {
            this.opToSamplePruner = opToSamplePruner;
        }

        public HashMap<TableScanOperator, FilterDesc.SampleDesc> getOpToSamplePruner() {
            return this.opToSamplePruner;
        }

        public void setOpToSamplePruner(HashMap<TableScanOperator, FilterDesc.SampleDesc> opToSamplePruner) {
            this.opToSamplePruner = opToSamplePruner;
        }
    }
}

